<?php
/**
 * Copyright 2007 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
# Generated by the protocol buffer compiler. DO NOT EDIT!
# source: google/appengine/ext/remote_api/remote_api.proto

namespace dummy {
  require_once 'google/appengine/runtime/proto/ProtocolMessage.php';
  require_once 'google/appengine/datastore/datastore_v3_pb.php';
  require_once 'google/appengine/datastore/entity_pb.php';
}
namespace google\appengine\ext\remote_api {
  class Request extends \google\net\ProtocolMessage {
    public function getServiceName() {
      if (!isset($this->service_name)) {
        return '';
      }
      return $this->service_name;
    }
    public function setServiceName($val) {
      $this->service_name = $val;
      return $this;
    }
    public function clearServiceName() {
      unset($this->service_name);
      return $this;
    }
    public function hasServiceName() {
      return isset($this->service_name);
    }
    public function getMethod() {
      if (!isset($this->method)) {
        return '';
      }
      return $this->method;
    }
    public function setMethod($val) {
      $this->method = $val;
      return $this;
    }
    public function clearMethod() {
      unset($this->method);
      return $this;
    }
    public function hasMethod() {
      return isset($this->method);
    }
    public function getRequest() {
      if (!isset($this->request)) {
        return '';
      }
      return $this->request;
    }
    public function setRequest($val) {
      $this->request = $val;
      return $this;
    }
    public function clearRequest() {
      unset($this->request);
      return $this;
    }
    public function hasRequest() {
      return isset($this->request);
    }
    public function getRequestId() {
      if (!isset($this->request_id)) {
        return '';
      }
      return $this->request_id;
    }
    public function setRequestId($val) {
      $this->request_id = $val;
      return $this;
    }
    public function clearRequestId() {
      unset($this->request_id);
      return $this;
    }
    public function hasRequestId() {
      return isset($this->request_id);
    }
    public function clear() {
      $this->clearServiceName();
      $this->clearMethod();
      $this->clearRequest();
      $this->clearRequestId();
    }
    public function byteSizePartial() {
      $res = 0;
      if (isset($this->service_name)) {
        $res += 1;
        $res += $this->lengthString(strlen($this->service_name));
      }
      if (isset($this->method)) {
        $res += 1;
        $res += $this->lengthString(strlen($this->method));
      }
      if (isset($this->request)) {
        $res += 1;
        $res += $this->lengthString(strlen($this->request));
      }
      if (isset($this->request_id)) {
        $res += 1;
        $res += $this->lengthString(strlen($this->request_id));
      }
      return $res;
    }
    public function outputPartial($out) {
      if (isset($this->service_name)) {
        $out->putVarInt32(18);
        $out->putPrefixedString($this->service_name);
      }
      if (isset($this->method)) {
        $out->putVarInt32(26);
        $out->putPrefixedString($this->method);
      }
      if (isset($this->request)) {
        $out->putVarInt32(34);
        $out->putPrefixedString($this->request);
      }
      if (isset($this->request_id)) {
        $out->putVarInt32(42);
        $out->putPrefixedString($this->request_id);
      }
    }
    public function tryMerge($d) {
      while($d->avail() > 0) {
        $tt = $d->getVarInt32();
        switch ($tt) {
          case 18:
            $length = $d->getVarInt32();
            $this->setServiceName(substr($d->buffer(), $d->pos(), $length));
            $d->skip($length);
            break;
          case 26:
            $length = $d->getVarInt32();
            $this->setMethod(substr($d->buffer(), $d->pos(), $length));
            $d->skip($length);
            break;
          case 34:
            $length = $d->getVarInt32();
            $this->setRequest(substr($d->buffer(), $d->pos(), $length));
            $d->skip($length);
            break;
          case 42:
            $length = $d->getVarInt32();
            $this->setRequestId(substr($d->buffer(), $d->pos(), $length));
            $d->skip($length);
            break;
          case 0:
            throw new \google\net\ProtocolBufferDecodeError();
            break;
          default:
            $d->skipData($tt);
        }
      };
    }
    public function checkInitialized() {
      if (!isset($this->service_name)) return 'service_name';
      if (!isset($this->method)) return 'method';
      if (!isset($this->request)) return 'request';
      return null;
    }
    public function mergeFrom($x) {
      if ($x === $this) { throw new \IllegalArgumentException('Cannot copy message to itself'); }
      if ($x->hasServiceName()) {
        $this->setServiceName($x->getServiceName());
      }
      if ($x->hasMethod()) {
        $this->setMethod($x->getMethod());
      }
      if ($x->hasRequest()) {
        $this->setRequest($x->getRequest());
      }
      if ($x->hasRequestId()) {
        $this->setRequestId($x->getRequestId());
      }
    }
    public function equals($x) {
      if ($x === $this) { return true; }
      if (isset($this->service_name) !== isset($x->service_name)) return false;
      if (isset($this->service_name) && $this->service_name !== $x->service_name) return false;
      if (isset($this->method) !== isset($x->method)) return false;
      if (isset($this->method) && $this->method !== $x->method) return false;
      if (isset($this->request) !== isset($x->request)) return false;
      if (isset($this->request) && $this->request !== $x->request) return false;
      if (isset($this->request_id) !== isset($x->request_id)) return false;
      if (isset($this->request_id) && $this->request_id !== $x->request_id) return false;
      return true;
    }
    public function shortDebugString($prefix = "") {
      $res = '';
      if (isset($this->service_name)) {
        $res .= $prefix . "service_name: " . $this->debugFormatString($this->service_name) . "\n";
      }
      if (isset($this->method)) {
        $res .= $prefix . "method: " . $this->debugFormatString($this->method) . "\n";
      }
      if (isset($this->request)) {
        $res .= $prefix . "request: " . $this->debugFormatString($this->request) . "\n";
      }
      if (isset($this->request_id)) {
        $res .= $prefix . "request_id: " . $this->debugFormatString($this->request_id) . "\n";
      }
      return $res;
    }
  }
}
namespace google\appengine\ext\remote_api {
  class ApplicationError extends \google\net\ProtocolMessage {
    public function getCode() {
      if (!isset($this->code)) {
        return 0;
      }
      return $this->code;
    }
    public function setCode($val) {
      $this->code = $val;
      return $this;
    }
    public function clearCode() {
      unset($this->code);
      return $this;
    }
    public function hasCode() {
      return isset($this->code);
    }
    public function getDetail() {
      if (!isset($this->detail)) {
        return '';
      }
      return $this->detail;
    }
    public function setDetail($val) {
      $this->detail = $val;
      return $this;
    }
    public function clearDetail() {
      unset($this->detail);
      return $this;
    }
    public function hasDetail() {
      return isset($this->detail);
    }
    public function clear() {
      $this->clearCode();
      $this->clearDetail();
    }
    public function byteSizePartial() {
      $res = 0;
      if (isset($this->code)) {
        $res += 1;
        $res += $this->lengthVarInt64($this->code);
      }
      if (isset($this->detail)) {
        $res += 1;
        $res += $this->lengthString(strlen($this->detail));
      }
      return $res;
    }
    public function outputPartial($out) {
      if (isset($this->code)) {
        $out->putVarInt32(8);
        $out->putVarInt32($this->code);
      }
      if (isset($this->detail)) {
        $out->putVarInt32(18);
        $out->putPrefixedString($this->detail);
      }
    }
    public function tryMerge($d) {
      while($d->avail() > 0) {
        $tt = $d->getVarInt32();
        switch ($tt) {
          case 8:
            $this->setCode($d->getVarInt32());
            break;
          case 18:
            $length = $d->getVarInt32();
            $this->setDetail(substr($d->buffer(), $d->pos(), $length));
            $d->skip($length);
            break;
          case 0:
            throw new \google\net\ProtocolBufferDecodeError();
            break;
          default:
            $d->skipData($tt);
        }
      };
    }
    public function checkInitialized() {
      if (!isset($this->code)) return 'code';
      if (!isset($this->detail)) return 'detail';
      return null;
    }
    public function mergeFrom($x) {
      if ($x === $this) { throw new \IllegalArgumentException('Cannot copy message to itself'); }
      if ($x->hasCode()) {
        $this->setCode($x->getCode());
      }
      if ($x->hasDetail()) {
        $this->setDetail($x->getDetail());
      }
    }
    public function equals($x) {
      if ($x === $this) { return true; }
      if (isset($this->code) !== isset($x->code)) return false;
      if (isset($this->code) && !$this->integerEquals($this->code, $x->code)) return false;
      if (isset($this->detail) !== isset($x->detail)) return false;
      if (isset($this->detail) && $this->detail !== $x->detail) return false;
      return true;
    }
    public function shortDebugString($prefix = "") {
      $res = '';
      if (isset($this->code)) {
        $res .= $prefix . "code: " . $this->debugFormatInt32($this->code) . "\n";
      }
      if (isset($this->detail)) {
        $res .= $prefix . "detail: " . $this->debugFormatString($this->detail) . "\n";
      }
      return $res;
    }
  }
}
namespace google\appengine\ext\remote_api {
  class Response extends \google\net\ProtocolMessage {
    public function getResponse() {
      if (!isset($this->response)) {
        return '';
      }
      return $this->response;
    }
    public function setResponse($val) {
      $this->response = $val;
      return $this;
    }
    public function clearResponse() {
      unset($this->response);
      return $this;
    }
    public function hasResponse() {
      return isset($this->response);
    }
    public function getException() {
      if (!isset($this->exception)) {
        return '';
      }
      return $this->exception;
    }
    public function setException($val) {
      $this->exception = $val;
      return $this;
    }
    public function clearException() {
      unset($this->exception);
      return $this;
    }
    public function hasException() {
      return isset($this->exception);
    }
    public function getApplicationError() {
      if (!isset($this->application_error)) {
        return new \google\appengine\ext\remote_api\ApplicationError();
      }
      return $this->application_error;
    }
    public function mutableApplicationError() {
      if (!isset($this->application_error)) {
        $res = new \google\appengine\ext\remote_api\ApplicationError();
        $this->application_error = $res;
        return $res;
      }
      return $this->application_error;
    }
    public function clearApplicationError() {
      if (isset($this->application_error)) {
        unset($this->application_error);
      }
    }
    public function hasApplicationError() {
      return isset($this->application_error);
    }
    public function getJavaException() {
      if (!isset($this->java_exception)) {
        return '';
      }
      return $this->java_exception;
    }
    public function setJavaException($val) {
      $this->java_exception = $val;
      return $this;
    }
    public function clearJavaException() {
      unset($this->java_exception);
      return $this;
    }
    public function hasJavaException() {
      return isset($this->java_exception);
    }
    public function clear() {
      $this->clearResponse();
      $this->clearException();
      $this->clearApplicationError();
      $this->clearJavaException();
    }
    public function byteSizePartial() {
      $res = 0;
      if (isset($this->response)) {
        $res += 1;
        $res += $this->lengthString(strlen($this->response));
      }
      if (isset($this->exception)) {
        $res += 1;
        $res += $this->lengthString(strlen($this->exception));
      }
      if (isset($this->application_error)) {
        $res += 1;
        $res += $this->lengthString($this->application_error->byteSizePartial());
      }
      if (isset($this->java_exception)) {
        $res += 1;
        $res += $this->lengthString(strlen($this->java_exception));
      }
      return $res;
    }
    public function outputPartial($out) {
      if (isset($this->response)) {
        $out->putVarInt32(10);
        $out->putPrefixedString($this->response);
      }
      if (isset($this->exception)) {
        $out->putVarInt32(18);
        $out->putPrefixedString($this->exception);
      }
      if (isset($this->application_error)) {
        $out->putVarInt32(26);
        $out->putVarInt32($this->application_error->byteSizePartial());
        $this->application_error->outputPartial($out);
      }
      if (isset($this->java_exception)) {
        $out->putVarInt32(34);
        $out->putPrefixedString($this->java_exception);
      }
    }
    public function tryMerge($d) {
      while($d->avail() > 0) {
        $tt = $d->getVarInt32();
        switch ($tt) {
          case 10:
            $length = $d->getVarInt32();
            $this->setResponse(substr($d->buffer(), $d->pos(), $length));
            $d->skip($length);
            break;
          case 18:
            $length = $d->getVarInt32();
            $this->setException(substr($d->buffer(), $d->pos(), $length));
            $d->skip($length);
            break;
          case 26:
            $length = $d->getVarInt32();
            $tmp = new \google\net\Decoder($d->buffer(), $d->pos(), $d->pos() + $length);
            $d->skip($length);
            $this->mutableApplicationError()->tryMerge($tmp);
            break;
          case 34:
            $length = $d->getVarInt32();
            $this->setJavaException(substr($d->buffer(), $d->pos(), $length));
            $d->skip($length);
            break;
          case 0:
            throw new \google\net\ProtocolBufferDecodeError();
            break;
          default:
            $d->skipData($tt);
        }
      };
    }
    public function checkInitialized() {
      if (isset($this->application_error) && (!$this->application_error->isInitialized())) return 'application_error';
      return null;
    }
    public function mergeFrom($x) {
      if ($x === $this) { throw new \IllegalArgumentException('Cannot copy message to itself'); }
      if ($x->hasResponse()) {
        $this->setResponse($x->getResponse());
      }
      if ($x->hasException()) {
        $this->setException($x->getException());
      }
      if ($x->hasApplicationError()) {
        $this->mutableApplicationError()->mergeFrom($x->getApplicationError());
      }
      if ($x->hasJavaException()) {
        $this->setJavaException($x->getJavaException());
      }
    }
    public function equals($x) {
      if ($x === $this) { return true; }
      if (isset($this->response) !== isset($x->response)) return false;
      if (isset($this->response) && $this->response !== $x->response) return false;
      if (isset($this->exception) !== isset($x->exception)) return false;
      if (isset($this->exception) && $this->exception !== $x->exception) return false;
      if (isset($this->application_error) !== isset($x->application_error)) return false;
      if (isset($this->application_error) && !$this->application_error->equals($x->application_error)) return false;
      if (isset($this->java_exception) !== isset($x->java_exception)) return false;
      if (isset($this->java_exception) && $this->java_exception !== $x->java_exception) return false;
      return true;
    }
    public function shortDebugString($prefix = "") {
      $res = '';
      if (isset($this->response)) {
        $res .= $prefix . "response: " . $this->debugFormatString($this->response) . "\n";
      }
      if (isset($this->exception)) {
        $res .= $prefix . "exception: " . $this->debugFormatString($this->exception) . "\n";
      }
      if (isset($this->application_error)) {
        $res .= $prefix . "application_error <\n" . $this->application_error->shortDebugString($prefix . "  ") . $prefix . ">\n";
      }
      if (isset($this->java_exception)) {
        $res .= $prefix . "java_exception: " . $this->debugFormatString($this->java_exception) . "\n";
      }
      return $res;
    }
  }
}
namespace google\appengine\ext\remote_api\TransactionRequest {
  class Precondition extends \google\net\ProtocolMessage {
    public function getKey() {
      if (!isset($this->key)) {
        return new \storage_onestore_v3\Reference();
      }
      return $this->key;
    }
    public function mutableKey() {
      if (!isset($this->key)) {
        $res = new \storage_onestore_v3\Reference();
        $this->key = $res;
        return $res;
      }
      return $this->key;
    }
    public function clearKey() {
      if (isset($this->key)) {
        unset($this->key);
      }
    }
    public function hasKey() {
      return isset($this->key);
    }
    public function getHash() {
      if (!isset($this->hash)) {
        return '';
      }
      return $this->hash;
    }
    public function setHash($val) {
      $this->hash = $val;
      return $this;
    }
    public function clearHash() {
      unset($this->hash);
      return $this;
    }
    public function hasHash() {
      return isset($this->hash);
    }
    public function clear() {
      $this->clearKey();
      $this->clearHash();
    }
    public function byteSizePartial() {
      $res = 0;
      if (isset($this->key)) {
        $res += 1;
        $res += $this->lengthString($this->key->byteSizePartial());
      }
      if (isset($this->hash)) {
        $res += 1;
        $res += $this->lengthString(strlen($this->hash));
      }
      return $res;
    }
    public function outputPartial($out) {
      if (isset($this->key)) {
        $out->putVarInt32(18);
        $out->putVarInt32($this->key->byteSizePartial());
        $this->key->outputPartial($out);
      }
      if (isset($this->hash)) {
        $out->putVarInt32(26);
        $out->putPrefixedString($this->hash);
      }
    }
    public function tryMerge($d) {
      while($d->avail() > 0) {
        $tt = $d->getVarInt32();
        switch ($tt) {
          case 12: return;
          case 18:
            $length = $d->getVarInt32();
            $tmp = new \google\net\Decoder($d->buffer(), $d->pos(), $d->pos() + $length);
            $d->skip($length);
            $this->mutableKey()->tryMerge($tmp);
            break;
          case 26:
            $length = $d->getVarInt32();
            $this->setHash(substr($d->buffer(), $d->pos(), $length));
            $d->skip($length);
            break;
          case 0:
            throw new \google\net\ProtocolBufferDecodeError();
            break;
          default:
            $d->skipData($tt);
        }
      };
    }
    public function checkInitialized() {
      if ((!isset($this->key)) || (!$this->key->isInitialized())) return 'key';
      return null;
    }
    public function mergeFrom($x) {
      if ($x === $this) { throw new \IllegalArgumentException('Cannot copy message to itself'); }
      if ($x->hasKey()) {
        $this->mutableKey()->mergeFrom($x->getKey());
      }
      if ($x->hasHash()) {
        $this->setHash($x->getHash());
      }
    }
    public function equals($x) {
      if ($x === $this) { return true; }
      if (isset($this->key) !== isset($x->key)) return false;
      if (isset($this->key) && !$this->key->equals($x->key)) return false;
      if (isset($this->hash) !== isset($x->hash)) return false;
      if (isset($this->hash) && $this->hash !== $x->hash) return false;
      return true;
    }
    public function shortDebugString($prefix = "") {
      $res = '';
      if (isset($this->key)) {
        $res .= $prefix . "key <\n" . $this->key->shortDebugString($prefix . "  ") . $prefix . ">\n";
      }
      if (isset($this->hash)) {
        $res .= $prefix . "hash: " . $this->debugFormatString($this->hash) . "\n";
      }
      return $res;
    }
  }
}
namespace google\appengine\ext\remote_api {
  class TransactionRequest extends \google\net\ProtocolMessage {
    private $precondition = array();
    public function getPreconditionSize() {
      return sizeof($this->precondition);
    }
    public function getPreconditionList() {
      return $this->precondition;
    }
    public function mutablePrecondition($idx) {
      if (!isset($this->precondition[$idx])) {
        $val = new \google\appengine\ext\remote_api\TransactionRequest\Precondition();
        $this->precondition[$idx] = $val;
        return $val;
      }
      return $this->precondition[$idx];
    }
    public function getPrecondition($idx) {
      if (isset($this->precondition[$idx])) {
        return $this->precondition[$idx];
      }
      if ($idx >= end(array_keys($this->precondition))) {
        throw new \OutOfRangeException('index out of range: ' + $idx);
      }
      return new \google\appengine\ext\remote_api\TransactionRequest\Precondition();
    }
    public function addPrecondition() {
      $val = new \google\appengine\ext\remote_api\TransactionRequest\Precondition();
      $this->precondition[] = $val;
      return $val;
    }
    public function clearPrecondition() {
      $this->precondition = array();
    }
    public function getPuts() {
      if (!isset($this->puts)) {
        return new \google\appengine_datastore_v3\PutRequest();
      }
      return $this->puts;
    }
    public function mutablePuts() {
      if (!isset($this->puts)) {
        $res = new \google\appengine_datastore_v3\PutRequest();
        $this->puts = $res;
        return $res;
      }
      return $this->puts;
    }
    public function clearPuts() {
      if (isset($this->puts)) {
        unset($this->puts);
      }
    }
    public function hasPuts() {
      return isset($this->puts);
    }
    public function getDeletes() {
      if (!isset($this->deletes)) {
        return new \google\appengine_datastore_v3\DeleteRequest();
      }
      return $this->deletes;
    }
    public function mutableDeletes() {
      if (!isset($this->deletes)) {
        $res = new \google\appengine_datastore_v3\DeleteRequest();
        $this->deletes = $res;
        return $res;
      }
      return $this->deletes;
    }
    public function clearDeletes() {
      if (isset($this->deletes)) {
        unset($this->deletes);
      }
    }
    public function hasDeletes() {
      return isset($this->deletes);
    }
    public function getAllowMultipleEg() {
      if (!isset($this->allow_multiple_eg)) {
        return false;
      }
      return $this->allow_multiple_eg;
    }
    public function setAllowMultipleEg($val) {
      $this->allow_multiple_eg = $val;
      return $this;
    }
    public function clearAllowMultipleEg() {
      unset($this->allow_multiple_eg);
      return $this;
    }
    public function hasAllowMultipleEg() {
      return isset($this->allow_multiple_eg);
    }
    public function clear() {
      $this->clearPrecondition();
      $this->clearPuts();
      $this->clearDeletes();
      $this->clearAllowMultipleEg();
    }
    public function byteSizePartial() {
      $res = 0;
      $this->checkProtoArray($this->precondition);
      $res += 2 * sizeof($this->precondition);
      foreach ($this->precondition as $value) {
        $res += $value->byteSizePartial();
      }
      if (isset($this->puts)) {
        $res += 1;
        $res += $this->lengthString($this->puts->byteSizePartial());
      }
      if (isset($this->deletes)) {
        $res += 1;
        $res += $this->lengthString($this->deletes->byteSizePartial());
      }
      if (isset($this->allow_multiple_eg)) {
        $res += 2;
      }
      return $res;
    }
    public function outputPartial($out) {
      $this->checkProtoArray($this->precondition);
      foreach ($this->precondition as $value) {
        $out->putVarInt32(11);
        $value->outputPartial($out);
        $out->putVarInt32(12);
      }
      if (isset($this->puts)) {
        $out->putVarInt32(34);
        $out->putVarInt32($this->puts->byteSizePartial());
        $this->puts->outputPartial($out);
      }
      if (isset($this->deletes)) {
        $out->putVarInt32(42);
        $out->putVarInt32($this->deletes->byteSizePartial());
        $this->deletes->outputPartial($out);
      }
      if (isset($this->allow_multiple_eg)) {
        $out->putVarInt32(48);
        $out->putBoolean($this->allow_multiple_eg);
      }
    }
    public function tryMerge($d) {
      while($d->avail() > 0) {
        $tt = $d->getVarInt32();
        switch ($tt) {
          case 11:
            $this->addPrecondition()->tryMerge($d);
            break;
          case 34:
            $length = $d->getVarInt32();
            $tmp = new \google\net\Decoder($d->buffer(), $d->pos(), $d->pos() + $length);
            $d->skip($length);
            $this->mutablePuts()->tryMerge($tmp);
            break;
          case 42:
            $length = $d->getVarInt32();
            $tmp = new \google\net\Decoder($d->buffer(), $d->pos(), $d->pos() + $length);
            $d->skip($length);
            $this->mutableDeletes()->tryMerge($tmp);
            break;
          case 48:
            $this->setAllowMultipleEg($d->getBoolean());
            break;
          case 0:
            throw new \google\net\ProtocolBufferDecodeError();
            break;
          default:
            $d->skipData($tt);
        }
      };
    }
    public function checkInitialized() {
      foreach ($this->precondition as $value) {
        if (!$value->isInitialized()) return 'precondition';
      }
      if (isset($this->puts) && (!$this->puts->isInitialized())) return 'puts';
      if (isset($this->deletes) && (!$this->deletes->isInitialized())) return 'deletes';
      return null;
    }
    public function mergeFrom($x) {
      if ($x === $this) { throw new \IllegalArgumentException('Cannot copy message to itself'); }
      foreach ($x->getPreconditionList() as $v) {
        $this->addPrecondition()->copyFrom($v);
      }
      if ($x->hasPuts()) {
        $this->mutablePuts()->mergeFrom($x->getPuts());
      }
      if ($x->hasDeletes()) {
        $this->mutableDeletes()->mergeFrom($x->getDeletes());
      }
      if ($x->hasAllowMultipleEg()) {
        $this->setAllowMultipleEg($x->getAllowMultipleEg());
      }
    }
    public function equals($x) {
      if ($x === $this) { return true; }
      if (sizeof($this->precondition) !== sizeof($x->precondition)) return false;
      foreach (array_map(null, $this->precondition, $x->precondition) as $v) {
        if (!$v[0]->equals($v[1])) return false;
      }
      if (isset($this->puts) !== isset($x->puts)) return false;
      if (isset($this->puts) && !$this->puts->equals($x->puts)) return false;
      if (isset($this->deletes) !== isset($x->deletes)) return false;
      if (isset($this->deletes) && !$this->deletes->equals($x->deletes)) return false;
      if (isset($this->allow_multiple_eg) !== isset($x->allow_multiple_eg)) return false;
      if (isset($this->allow_multiple_eg) && $this->allow_multiple_eg !== $x->allow_multiple_eg) return false;
      return true;
    }
    public function shortDebugString($prefix = "") {
      $res = '';
      foreach ($this->precondition as $value) {
        $res .= $prefix . "Precondition {\n" . $value->shortDebugString($prefix . "  ") . $prefix . "}\n";
      }
      if (isset($this->puts)) {
        $res .= $prefix . "puts <\n" . $this->puts->shortDebugString($prefix . "  ") . $prefix . ">\n";
      }
      if (isset($this->deletes)) {
        $res .= $prefix . "deletes <\n" . $this->deletes->shortDebugString($prefix . "  ") . $prefix . ">\n";
      }
      if (isset($this->allow_multiple_eg)) {
        $res .= $prefix . "allow_multiple_eg: " . $this->debugFormatBool($this->allow_multiple_eg) . "\n";
      }
      return $res;
    }
  }
}
namespace google\appengine\ext\remote_api {
  class TransactionQueryResult extends \google\net\ProtocolMessage {
    public function getResult() {
      if (!isset($this->result)) {
        return new \google\appengine_datastore_v3\QueryResult();
      }
      return $this->result;
    }
    public function mutableResult() {
      if (!isset($this->result)) {
        $res = new \google\appengine_datastore_v3\QueryResult();
        $this->result = $res;
        return $res;
      }
      return $this->result;
    }
    public function clearResult() {
      if (isset($this->result)) {
        unset($this->result);
      }
    }
    public function hasResult() {
      return isset($this->result);
    }
    public function getEntityGroupKey() {
      if (!isset($this->entity_group_key)) {
        return new \storage_onestore_v3\Reference();
      }
      return $this->entity_group_key;
    }
    public function mutableEntityGroupKey() {
      if (!isset($this->entity_group_key)) {
        $res = new \storage_onestore_v3\Reference();
        $this->entity_group_key = $res;
        return $res;
      }
      return $this->entity_group_key;
    }
    public function clearEntityGroupKey() {
      if (isset($this->entity_group_key)) {
        unset($this->entity_group_key);
      }
    }
    public function hasEntityGroupKey() {
      return isset($this->entity_group_key);
    }
    public function getEntityGroup() {
      if (!isset($this->entity_group)) {
        return new \storage_onestore_v3\EntityProto();
      }
      return $this->entity_group;
    }
    public function mutableEntityGroup() {
      if (!isset($this->entity_group)) {
        $res = new \storage_onestore_v3\EntityProto();
        $this->entity_group = $res;
        return $res;
      }
      return $this->entity_group;
    }
    public function clearEntityGroup() {
      if (isset($this->entity_group)) {
        unset($this->entity_group);
      }
    }
    public function hasEntityGroup() {
      return isset($this->entity_group);
    }
    public function clear() {
      $this->clearResult();
      $this->clearEntityGroupKey();
      $this->clearEntityGroup();
    }
    public function byteSizePartial() {
      $res = 0;
      if (isset($this->result)) {
        $res += 1;
        $res += $this->lengthString($this->result->byteSizePartial());
      }
      if (isset($this->entity_group_key)) {
        $res += 1;
        $res += $this->lengthString($this->entity_group_key->byteSizePartial());
      }
      if (isset($this->entity_group)) {
        $res += 1;
        $res += $this->lengthString($this->entity_group->byteSizePartial());
      }
      return $res;
    }
    public function outputPartial($out) {
      if (isset($this->result)) {
        $out->putVarInt32(10);
        $out->putVarInt32($this->result->byteSizePartial());
        $this->result->outputPartial($out);
      }
      if (isset($this->entity_group_key)) {
        $out->putVarInt32(18);
        $out->putVarInt32($this->entity_group_key->byteSizePartial());
        $this->entity_group_key->outputPartial($out);
      }
      if (isset($this->entity_group)) {
        $out->putVarInt32(26);
        $out->putVarInt32($this->entity_group->byteSizePartial());
        $this->entity_group->outputPartial($out);
      }
    }
    public function tryMerge($d) {
      while($d->avail() > 0) {
        $tt = $d->getVarInt32();
        switch ($tt) {
          case 10:
            $length = $d->getVarInt32();
            $tmp = new \google\net\Decoder($d->buffer(), $d->pos(), $d->pos() + $length);
            $d->skip($length);
            $this->mutableResult()->tryMerge($tmp);
            break;
          case 18:
            $length = $d->getVarInt32();
            $tmp = new \google\net\Decoder($d->buffer(), $d->pos(), $d->pos() + $length);
            $d->skip($length);
            $this->mutableEntityGroupKey()->tryMerge($tmp);
            break;
          case 26:
            $length = $d->getVarInt32();
            $tmp = new \google\net\Decoder($d->buffer(), $d->pos(), $d->pos() + $length);
            $d->skip($length);
            $this->mutableEntityGroup()->tryMerge($tmp);
            break;
          case 0:
            throw new \google\net\ProtocolBufferDecodeError();
            break;
          default:
            $d->skipData($tt);
        }
      };
    }
    public function checkInitialized() {
      if ((!isset($this->result)) || (!$this->result->isInitialized())) return 'result';
      if ((!isset($this->entity_group_key)) || (!$this->entity_group_key->isInitialized())) return 'entity_group_key';
      if (isset($this->entity_group) && (!$this->entity_group->isInitialized())) return 'entity_group';
      return null;
    }
    public function mergeFrom($x) {
      if ($x === $this) { throw new \IllegalArgumentException('Cannot copy message to itself'); }
      if ($x->hasResult()) {
        $this->mutableResult()->mergeFrom($x->getResult());
      }
      if ($x->hasEntityGroupKey()) {
        $this->mutableEntityGroupKey()->mergeFrom($x->getEntityGroupKey());
      }
      if ($x->hasEntityGroup()) {
        $this->mutableEntityGroup()->mergeFrom($x->getEntityGroup());
      }
    }
    public function equals($x) {
      if ($x === $this) { return true; }
      if (isset($this->result) !== isset($x->result)) return false;
      if (isset($this->result) && !$this->result->equals($x->result)) return false;
      if (isset($this->entity_group_key) !== isset($x->entity_group_key)) return false;
      if (isset($this->entity_group_key) && !$this->entity_group_key->equals($x->entity_group_key)) return false;
      if (isset($this->entity_group) !== isset($x->entity_group)) return false;
      if (isset($this->entity_group) && !$this->entity_group->equals($x->entity_group)) return false;
      return true;
    }
    public function shortDebugString($prefix = "") {
      $res = '';
      if (isset($this->result)) {
        $res .= $prefix . "result <\n" . $this->result->shortDebugString($prefix . "  ") . $prefix . ">\n";
      }
      if (isset($this->entity_group_key)) {
        $res .= $prefix . "entity_group_key <\n" . $this->entity_group_key->shortDebugString($prefix . "  ") . $prefix . ">\n";
      }
      if (isset($this->entity_group)) {
        $res .= $prefix . "entity_group <\n" . $this->entity_group->shortDebugString($prefix . "  ") . $prefix . ">\n";
      }
      return $res;
    }
  }
}
