/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.typeresolution;

import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sourceforge.pmd.typeresolution.visitors.PMDASMVisitor;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassWriter;

public class PMDASMClassLoader
extends ClassLoader {
    private Map importedClasses = new HashMap();
    private Set dontBother = new HashSet();

    public synchronized Class loadClass(String name) throws ClassNotFoundException {
        return this.defineClass(name);
    }

    public Map getImportedClasses(String className) {
        Map ret = (Map)this.importedClasses.get(className);
        return ret == null ? new HashMap() : ret;
    }

    private Class defineClass(String name) throws ClassNotFoundException {
        if (this.dontBother.contains(name)) {
            throw new ClassNotFoundException(name);
        }
        try {
            if (name.startsWith("java.")) {
                return Class.forName(name);
            }
            if (this.importedClasses.containsKey(name) && super.findLoadedClass(name) != null) {
                return super.findLoadedClass(name);
            }
            ClassReader reader = new ClassReader(this.getResourceAsStream(name.replace('.', '/') + ".class"));
            PMDASMVisitor asmVisitor = new PMDASMVisitor();
            reader.accept(asmVisitor, 0);
            List inner = asmVisitor.getInnerClasses();
            if (inner != null && !inner.isEmpty()) {
                for (int ix = 0; ix < inner.size(); ++ix) {
                    String str = (String)inner.get(ix);
                    ClassReader innerReader = new ClassReader(this.getResourceAsStream(str.replace('.', '/') + ".class"));
                    innerReader.accept(asmVisitor, 0);
                }
            }
            this.importedClasses.put(name, asmVisitor.getPackages());
            ClassWriter writer = new ClassWriter(1);
            reader.accept(writer, 0);
            byte[] byteCode = writer.toByteArray();
            return this.defineClass(name, byteCode, 0, byteCode.length);
        }
        catch (ClassNotFoundException e) {
            this.dontBother.add(name);
            throw e;
        }
        catch (IOException e) {
            this.dontBother.add(name);
            throw new ClassNotFoundException(name, e);
        }
    }
}

