/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.rules.strictexception;

import java.util.Iterator;
import java.util.List;
import net.sourceforge.pmd.AbstractRule;
import net.sourceforge.pmd.ast.ASTCompilationUnit;
import net.sourceforge.pmd.ast.ASTConstructorDeclaration;
import net.sourceforge.pmd.ast.ASTImportDeclaration;
import net.sourceforge.pmd.ast.ASTMethodDeclaration;
import net.sourceforge.pmd.ast.ASTName;
import net.sourceforge.pmd.ast.Node;

public class ExceptionSignatureDeclaration
extends AbstractRule {
    private boolean junitImported;

    public Object visit(ASTCompilationUnit node, Object o) {
        this.junitImported = false;
        return super.visit(node, o);
    }

    public Object visit(ASTImportDeclaration node, Object o) {
        if (node.getImportedName().indexOf("junit") != -1) {
            this.junitImported = true;
        }
        return super.visit(node, o);
    }

    public Object visit(ASTMethodDeclaration methodDeclaration, Object o) {
        if ((methodDeclaration.getMethodName().equals("setUp") || methodDeclaration.getMethodName().equals("tearDown")) && this.junitImported) {
            return super.visit(methodDeclaration, o);
        }
        if (methodDeclaration.getMethodName().startsWith("test")) {
            return super.visit(methodDeclaration, o);
        }
        List exceptionList = methodDeclaration.findChildrenOfType(ASTName.class);
        if (!exceptionList.isEmpty()) {
            this.evaluateExceptions(exceptionList, o);
        }
        return super.visit(methodDeclaration, o);
    }

    public Object visit(ASTConstructorDeclaration constructorDeclaration, Object o) {
        List exceptionList = constructorDeclaration.findChildrenOfType(ASTName.class);
        if (!exceptionList.isEmpty()) {
            this.evaluateExceptions(exceptionList, o);
        }
        return super.visit(constructorDeclaration, o);
    }

    private void evaluateExceptions(List exceptionList, Object context) {
        Iterator iter = exceptionList.iterator();
        while (iter.hasNext()) {
            ASTName exception = (ASTName)iter.next();
            if (!this.hasDeclaredExceptionInSignature(exception)) continue;
            this.addViolation(context, exception);
        }
    }

    private boolean hasDeclaredExceptionInSignature(ASTName exception) {
        return exception.hasImageEqualTo("Exception") && this.isParentSignatureDeclaration(exception);
    }

    private boolean isParentSignatureDeclaration(ASTName exception) {
        Node parent = exception.jjtGetParent().jjtGetParent();
        return parent instanceof ASTMethodDeclaration || parent instanceof ASTConstructorDeclaration;
    }
}

