/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.rules.codesize;

import java.util.Iterator;
import java.util.Set;
import net.sourceforge.pmd.RuleContext;
import net.sourceforge.pmd.ast.ASTClassOrInterfaceDeclaration;
import net.sourceforge.pmd.ast.ASTConstructorDeclaration;
import net.sourceforge.pmd.ast.ASTEnumDeclaration;
import net.sourceforge.pmd.ast.ASTExplicitConstructorInvocation;
import net.sourceforge.pmd.ast.ASTFieldDeclaration;
import net.sourceforge.pmd.ast.ASTInitializer;
import net.sourceforge.pmd.ast.ASTMethodDeclaration;
import net.sourceforge.pmd.ast.ASTTypeDeclaration;
import net.sourceforge.pmd.rules.codesize.AbstractNcssCount;
import net.sourceforge.pmd.stat.DataPoint;
import net.sourceforge.pmd.util.NumericConstants;

public class NcssTypeCount
extends AbstractNcssCount {
    public NcssTypeCount() {
        super(ASTTypeDeclaration.class);
    }

    public Object visit(ASTClassOrInterfaceDeclaration node, Object data) {
        if (!node.isNested()) {
            return super.visit(node, data);
        }
        return this.countNodeChildren(node, data);
    }

    public Object visit(ASTConstructorDeclaration node, Object data) {
        return this.countNodeChildren(node, data);
    }

    public Object visit(ASTExplicitConstructorInvocation node, Object data) {
        return NumericConstants.ONE;
    }

    public Object visit(ASTEnumDeclaration node, Object data) {
        if (node.jjtGetParent() instanceof ASTTypeDeclaration) {
            Integer nodeCount = this.countNodeChildren(node, data);
            int count = nodeCount - 1;
            return new Integer(count);
        }
        return this.countNodeChildren(node, data);
    }

    public Object visit(ASTMethodDeclaration node, Object data) {
        return this.countNodeChildren(node, data);
    }

    public Object visit(ASTInitializer node, Object data) {
        return this.countNodeChildren(node, data);
    }

    public Object visit(ASTFieldDeclaration node, Object data) {
        return NumericConstants.ONE;
    }

    protected void makeViolations(RuleContext ctx, Set p) {
        Iterator points = p.iterator();
        while (points.hasNext()) {
            DataPoint point = (DataPoint)points.next();
            this.addViolation((Object)ctx, point.getNode(), String.valueOf((int)point.getScore()));
        }
    }
}

