/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.rules;

import java.util.ArrayList;
import net.sourceforge.pmd.AbstractRule;
import net.sourceforge.pmd.ast.ASTAssignmentOperator;
import net.sourceforge.pmd.ast.ASTClassOrInterfaceDeclaration;
import net.sourceforge.pmd.ast.ASTIfStatement;
import net.sourceforge.pmd.ast.ASTLiteral;
import net.sourceforge.pmd.ast.ASTMethodDeclaration;
import net.sourceforge.pmd.ast.ASTName;
import net.sourceforge.pmd.ast.ASTNullLiteral;
import net.sourceforge.pmd.ast.ASTPrimaryExpression;
import net.sourceforge.pmd.ast.ASTPrimaryPrefix;
import net.sourceforge.pmd.ast.ASTReferenceType;
import net.sourceforge.pmd.ast.ASTReturnStatement;
import net.sourceforge.pmd.ast.ASTStatementExpression;
import net.sourceforge.pmd.ast.ASTSynchronizedStatement;
import net.sourceforge.pmd.ast.ASTType;
import net.sourceforge.pmd.ast.Node;

public class DoubleCheckedLocking
extends AbstractRule {
    public Object visit(ASTClassOrInterfaceDeclaration node, Object data) {
        if (node.isInterface()) {
            return data;
        }
        return super.visit(node, data);
    }

    public Object visit(ASTMethodDeclaration node, Object data) {
        ASTIfStatement is;
        if (node.getResultType().isVoid()) {
            return super.visit(node, data);
        }
        ASTType typeNode = (ASTType)node.getResultType().jjtGetChild(0);
        if (typeNode.jjtGetNumChildren() == 0 || !(typeNode.jjtGetChild(0) instanceof ASTReferenceType)) {
            return super.visit(node, data);
        }
        ArrayList finder = new ArrayList();
        node.findChildrenOfType(ASTReturnStatement.class, finder, true);
        if (finder.size() != 1) {
            return super.visit(node, data);
        }
        ASTReturnStatement rs = (ASTReturnStatement)finder.get(0);
        finder.clear();
        rs.findChildrenOfType(ASTPrimaryExpression.class, finder, true);
        ASTPrimaryExpression ape = (ASTPrimaryExpression)finder.get(0);
        Node lastChild = ape.jjtGetChild(ape.jjtGetNumChildren() - 1);
        String returnVariableName = null;
        if (lastChild instanceof ASTPrimaryPrefix) {
            returnVariableName = this.getNameFromPrimaryPrefix((ASTPrimaryPrefix)lastChild);
        }
        if (returnVariableName == null) {
            return super.visit(node, data);
        }
        finder.clear();
        node.findChildrenOfType(ASTIfStatement.class, finder, true);
        if (finder.size() == 2 && this.ifVerify(is = (ASTIfStatement)finder.get(0), returnVariableName)) {
            finder.clear();
            is.findChildrenOfType(ASTSynchronizedStatement.class, finder, true);
            if (finder.size() == 1) {
                ASTIfStatement is2;
                ASTSynchronizedStatement ss = (ASTSynchronizedStatement)finder.get(0);
                finder.clear();
                ss.findChildrenOfType(ASTIfStatement.class, finder, true);
                if (finder.size() == 1 && this.ifVerify(is2 = (ASTIfStatement)finder.get(0), returnVariableName)) {
                    ASTPrimaryExpression pe;
                    ASTStatementExpression se;
                    finder.clear();
                    is2.findChildrenOfType(ASTStatementExpression.class, finder, true);
                    if (finder.size() == 1 && (se = (ASTStatementExpression)finder.get(0)).jjtGetNumChildren() == 3 && se.jjtGetChild(0) instanceof ASTPrimaryExpression && this.matchName(pe = (ASTPrimaryExpression)se.jjtGetChild(0), returnVariableName) && se.jjtGetChild(1) instanceof ASTAssignmentOperator) {
                        this.addViolation(data, node);
                    }
                }
            }
        }
        return super.visit(node, data);
    }

    private boolean ifVerify(ASTIfStatement is, String varname) {
        ASTLiteral lit;
        ASTPrimaryPrefix pp2;
        ASTPrimaryExpression apeRight;
        ASTPrimaryExpression apeLeft;
        ArrayList finder = new ArrayList();
        is.findChildrenOfType(ASTPrimaryExpression.class, finder, true);
        return finder.size() > 1 && this.matchName(apeLeft = (ASTPrimaryExpression)finder.get(0), varname) && (apeRight = (ASTPrimaryExpression)finder.get(1)).jjtGetNumChildren() == 1 && apeRight.jjtGetChild(0) instanceof ASTPrimaryPrefix && (pp2 = (ASTPrimaryPrefix)apeRight.jjtGetChild(0)).jjtGetNumChildren() == 1 && pp2.jjtGetChild(0) instanceof ASTLiteral && (lit = (ASTLiteral)pp2.jjtGetChild(0)).jjtGetNumChildren() == 1 && lit.jjtGetChild(0) instanceof ASTNullLiteral;
    }

    private boolean matchName(ASTPrimaryExpression ape, String name) {
        ASTPrimaryPrefix pp;
        String name2;
        return ape.jjtGetNumChildren() == 1 && ape.jjtGetChild(0) instanceof ASTPrimaryPrefix && (name2 = this.getNameFromPrimaryPrefix(pp = (ASTPrimaryPrefix)ape.jjtGetChild(0))) != null && name2.equals(name);
    }

    private String getNameFromPrimaryPrefix(ASTPrimaryPrefix pp) {
        if (pp.jjtGetNumChildren() == 1 && pp.jjtGetChild(0) instanceof ASTName) {
            return ((ASTName)pp.jjtGetChild(0)).getImage();
        }
        return null;
    }
}

