/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.properties;

import java.lang.reflect.Method;
import net.sourceforge.pmd.properties.AbstractPMDProperty;

public class MethodProperty
extends AbstractPMDProperty {
    public MethodProperty(String theName, String theDescription, Object theDefault, float theUIOrder) {
        super(theName, theDescription, theDefault, theUIOrder);
    }

    public Class type() {
        return Method.class;
    }

    public Object valueFrom(String propertyString) throws IllegalArgumentException {
        Class cls = this.classIn(propertyString);
        String methodName = this.methodNameIn(propertyString);
        Class[] parameterTypes = this.parameterTypesIn(propertyString);
        try {
            return cls.getMethod(methodName, parameterTypes);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("invalid method: " + propertyString);
        }
    }

    private Class classIn(String propertyString) throws IllegalArgumentException {
        int dotPos = propertyString.lastIndexOf(46);
        String className = propertyString.substring(0, dotPos);
        try {
            return Class.forName(className);
        }
        catch (Exception ex) {
            throw new IllegalArgumentException("class not found: " + className);
        }
    }

    private String methodNameIn(String propertyString) throws IllegalArgumentException {
        int dotPos = propertyString.lastIndexOf(46);
        return propertyString.substring(dotPos);
    }

    private Class[] parameterTypesIn(String propertyString) {
        return null;
    }
}

