/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.dfa;

import java.util.LinkedList;
import java.util.List;
import java.util.Stack;
import net.sourceforge.pmd.ast.SimpleNode;
import net.sourceforge.pmd.dfa.DataFlowNode;
import net.sourceforge.pmd.dfa.IDataFlowNode;
import net.sourceforge.pmd.dfa.StackObject;
import net.sourceforge.pmd.dfa.StartOrEndDataFlowNode;

public class Structure {
    private LinkedList dataFlow = new LinkedList();
    private Stack braceStack = new Stack();
    private Stack continueBreakReturnStack = new Stack();

    public IDataFlowNode createNewNode(SimpleNode node) {
        return new DataFlowNode(node, this.dataFlow);
    }

    public IDataFlowNode createStartNode(int line) {
        return new StartOrEndDataFlowNode(this.dataFlow, line, true);
    }

    public IDataFlowNode createEndNode(int line) {
        return new StartOrEndDataFlowNode(this.dataFlow, line, false);
    }

    public IDataFlowNode getLast() {
        return (IDataFlowNode)this.dataFlow.getLast();
    }

    public IDataFlowNode getFirst() {
        return (IDataFlowNode)this.dataFlow.getFirst();
    }

    protected void pushOnStack(int type, IDataFlowNode node) {
        StackObject obj = new StackObject(type, node);
        if (type == 50 || type == 51 || type == 52) {
            this.continueBreakReturnStack.push(obj);
        } else {
            this.braceStack.push(obj);
        }
        ((DataFlowNode)node).setType(type);
    }

    public List getBraceStack() {
        return this.braceStack;
    }

    public List getContinueBreakReturnStack() {
        return this.continueBreakReturnStack;
    }
}

