/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.vf;

import apex.jorje.semantic.symbol.type.BasicType;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;

public enum DataType {
    AutoNumber(false),
    Checkbox(false, "Boolean"),
    Currency(false, "Currency"),
    Date(false, "Date"),
    DateTime(false, "Datetime"),
    Email(false),
    EncryptedText(true),
    ExternalLookup(true),
    File(false),
    Hierarchy(false),
    Html(false),
    IndirectLookup(false),
    Location(false),
    LongTextArea(true),
    Lookup(false, "ID"),
    MasterDetail(false),
    MetadataRelationship(false),
    MultiselectPicklist(true),
    Note(true),
    Number(false, "Decimal", "Double", "Integer", "Long"),
    Percent(false),
    Phone(false),
    Picklist(true),
    Summary(false),
    Text(true, "String"),
    TextArea(true),
    Time(false, "Time"),
    Url(false),
    Unknown(true);

    private static final Logger LOGGER;
    public final boolean requiresEscaping;
    private final Set<String> basicTypeNames;
    private static final Map<String, DataType> CASE_NORMALIZED_MAP;
    private static final Map<String, DataType> BASIC_TYPE_MAP;

    public static DataType fromString(String value) {
        DataType dataType = CASE_NORMALIZED_MAP.get((value = value != null ? value : "").toLowerCase(Locale.ROOT));
        if (dataType == null) {
            dataType = Unknown;
            LOGGER.fine("Unable to determine DataType of " + value);
        }
        return dataType;
    }

    @Deprecated
    public static DataType fromBasicType(BasicType value) {
        if (value != null) {
            switch (value) {
                case BOOLEAN: {
                    return Checkbox;
                }
                case CURRENCY: {
                    return Currency;
                }
                case DATE: {
                    return Date;
                }
                case DATE_TIME: {
                    return DateTime;
                }
                case ID: {
                    return Lookup;
                }
                case DECIMAL: 
                case DOUBLE: 
                case INTEGER: 
                case LONG: {
                    return Number;
                }
                case STRING: {
                    return Text;
                }
                case TIME: {
                    return Time;
                }
            }
        }
        LOGGER.fine("Unable to determine DataType of " + value);
        return Unknown;
    }

    public static DataType fromTypeName(String value) {
        DataType dataType = BASIC_TYPE_MAP.get((value = value != null ? value : "").toLowerCase(Locale.ROOT));
        if (dataType == null) {
            dataType = Unknown;
            LOGGER.fine("Unable to determine DataType of " + value);
        }
        return dataType;
    }

    private DataType(boolean requiresEscaping) {
        this(requiresEscaping, null);
    }

    private DataType(boolean requiresEscaping, String ... basicTypeNames) {
        this.requiresEscaping = requiresEscaping;
        this.basicTypeNames = new HashSet<String>();
        if (basicTypeNames != null) {
            this.basicTypeNames.addAll(Arrays.asList(basicTypeNames));
        }
    }

    static {
        LOGGER = Logger.getLogger(DataType.class.getName());
        CASE_NORMALIZED_MAP = new HashMap<String, DataType>();
        BASIC_TYPE_MAP = new HashMap<String, DataType>();
        for (DataType dataType : DataType.values()) {
            CASE_NORMALIZED_MAP.put(dataType.name().toLowerCase(Locale.ROOT), dataType);
            for (String typeName : dataType.basicTypeNames) {
                BASIC_TYPE_MAP.put(typeName.toLowerCase(Locale.ROOT), dataType);
            }
        }
    }
}

