/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.lsp.impl.utils;

import apex.jorje.semantic.symbol.type.TypeInfo;
import com.google.common.collect.MoreMaps;
import java.util.Map;

public class TypeInfoCache {
    private static final Map<String, TypeInfo> builtInTypes = MoreMaps.newCaseInsensitiveMap();
    private static final Map<String, TypeInfo> userDefinedTypes = MoreMaps.newCaseInsensitiveMap();

    public static void addBuiltInTypeInfo(TypeInfo typeInfo) {
        builtInTypes.put(typeInfo.getApexName().toLowerCase(), typeInfo);
    }

    public static void addTypeInfo(TypeInfo typeInfo) {
        userDefinedTypes.put(typeInfo.getApexName().toLowerCase(), typeInfo);
    }

    public static TypeInfo getTypeInfo(String apexName) {
        TypeInfo builtInType = builtInTypes.get(apexName);
        return builtInType != null ? builtInType : userDefinedTypes.get(apexName);
    }

    public static void invalidateAll() {
        userDefinedTypes.clear();
    }

    public static void invalidate(String apexName) {
        userDefinedTypes.clear();
    }

    public static Map<String, TypeInfo> getBuiltInTypes() {
        return MoreMaps.toImmutableMap(builtInTypes);
    }

    public static Map<String, TypeInfo> getUserDefinedTypes() {
        return MoreMaps.toImmutableMap(userDefinedTypes);
    }
}

