/*
 * Decompiled with CFR 0.152.
 */
package apex.common.collect;

import java.util.List;

public final class Comparables {
    private Comparables() {
    }

    public static <T extends Comparable<? super T>> int compare(T left, T right) {
        if (left == null && right == null) {
            return 0;
        }
        if (left == null) {
            return -1;
        }
        if (right == null) {
            return 1;
        }
        return left.compareTo(right);
    }

    public static <T extends Comparable<? super T>> boolean isLessThan(T left, T right) {
        return Comparables.compare(left, right) < 0;
    }

    public static <T extends Comparable<? super T>> boolean isGreaterThan(T left, T right) {
        return Comparables.compare(left, right) > 0;
    }

    public static <T extends Comparable<? super T>> boolean isEqualTo(T left, T right) {
        return Comparables.compare(left, right) == 0;
    }

    public static <T extends Comparable<? super T>> int compare(List<T> left, List<T> right) {
        if (left == null && right == null) {
            return 0;
        }
        if (left == null) {
            return -1;
        }
        if (right == null) {
            return 1;
        }
        if (left.size() != right.size()) {
            return right.size() - left.size();
        }
        for (int i = 0; i < left.size(); ++i) {
            int retVal = Comparables.compare((Comparable)left.get(i), (Comparable)right.get(i));
            if (retVal == 0) continue;
            return retVal;
        }
        return 0;
    }

    public static <T extends Comparable<? super T>> int compare(T[] left, T[] right) {
        if (left == null && right == null) {
            return 0;
        }
        if (left == null) {
            return -1;
        }
        if (right == null) {
            return 1;
        }
        if (left.length != right.length) {
            return right.length - left.length;
        }
        for (int i = 0; i < left.length; ++i) {
            int retVal = Comparables.compare(left[i], right[i]);
            if (retVal == 0) continue;
            return retVal;
        }
        return 0;
    }
}

