/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.ast;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sourceforge.pmd.PMD;
import net.sourceforge.pmd.lang.ast.AbstractNode;
import net.sourceforge.pmd.lang.java.ast.Token;
import org.apache.commons.lang3.StringUtils;

public abstract class Comment
extends AbstractNode {
    private static final Pattern COMMENT_LINE_COMBINED = Pattern.compile("^(?://|/\\*\\*?|\\*)?(.*?)(?:\\*/|/)?$");
    static final Pattern NEWLINES_PATTERN = Pattern.compile("\\u000D\\u000A|[\\u000A\\u000B\\u000C\\u000D\\u0085\\u2028\\u2029]");

    protected Comment(Token t) {
        super(-1, t.beginLine, t.endLine, t.beginColumn, t.endColumn);
        this.setImage(t.image);
    }

    public String toString() {
        return this.getImage();
    }

    public String getFilteredComment() {
        List<String> lines = this.multiLinesIn();
        lines = Comment.trim(lines);
        return StringUtils.join(lines, (String)PMD.EOL);
    }

    private List<String> multiLinesIn() {
        String[] lines = NEWLINES_PATTERN.split(this.getImage());
        ArrayList<String> filteredLines = new ArrayList<String>(lines.length);
        for (String rawLine : lines) {
            String line = rawLine.trim();
            Matcher allMatcher = COMMENT_LINE_COMBINED.matcher(line);
            if (!allMatcher.matches()) continue;
            filteredLines.add(allMatcher.group(1).trim());
        }
        return filteredLines;
    }

    static List<String> trim(List<String> lines) {
        if (lines == null) {
            return Collections.emptyList();
        }
        ArrayList<String> result = new ArrayList<String>(lines.size());
        ArrayList<String> tempList = new ArrayList<String>();
        boolean foundFirstNonEmptyLine = false;
        for (String line : lines) {
            if (StringUtils.isNotBlank((CharSequence)line)) {
                result.addAll(tempList);
                tempList.clear();
                result.add(line);
                foundFirstNonEmptyLine = true;
                continue;
            }
            if (!foundFirstNonEmptyLine) continue;
            tempList.add(line);
        }
        return result;
    }
}

