/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.renderers.internal.sarif;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import net.sourceforge.pmd.PMDVersion;
import net.sourceforge.pmd.Report;
import net.sourceforge.pmd.RuleViolation;
import net.sourceforge.pmd.renderers.internal.sarif.SarifLog;

public class SarifLogBuilder {
    private final Map<SarifLog.ReportingDescriptor, List<SarifLog.Location>> locationsByRule = new HashMap<SarifLog.ReportingDescriptor, List<SarifLog.Location>>();
    private final List<SarifLog.ToolConfigurationNotification> toolConfigurationNotifications = new ArrayList<SarifLog.ToolConfigurationNotification>();
    private final List<SarifLog.ToolExecutionNotification> toolExecutionNotifications = new ArrayList<SarifLog.ToolExecutionNotification>();

    public static SarifLogBuilder sarifLogBuilder() {
        return new SarifLogBuilder();
    }

    public SarifLogBuilder add(RuleViolation violation) {
        SarifLog.ReportingDescriptor ruleDescriptor = this.getReportingDescriptor(violation);
        SarifLog.Location location = this.getRuleViolationLocation(violation);
        ArrayList<SarifLog.Location> ruleLocation = this.locationsByRule.containsKey(ruleDescriptor) ? this.locationsByRule.get(ruleDescriptor) : new ArrayList<SarifLog.Location>();
        ruleLocation.add(location);
        this.locationsByRule.put(ruleDescriptor, ruleLocation);
        return this;
    }

    public SarifLogBuilder addRunTimeError(Report.ProcessingError error) {
        SarifLog.ArtifactLocation artifactLocation = SarifLog.ArtifactLocation.builder().uri(error.getFile()).build();
        SarifLog.PhysicalLocation physicalLocation = SarifLog.PhysicalLocation.builder().artifactLocation(artifactLocation).build();
        SarifLog.Location location = SarifLog.Location.builder().physicalLocation(physicalLocation).build();
        SarifLog.Message message = SarifLog.Message.builder().text(error.getMsg()).build();
        SarifLog.Exception exception = SarifLog.Exception.builder().message(error.getDetail()).build();
        SarifLog.ToolExecutionNotification toolExecutionNotification = SarifLog.ToolExecutionNotification.builder().locations(Collections.singletonList(location)).message(message).exception(exception).build();
        this.toolExecutionNotifications.add(toolExecutionNotification);
        return this;
    }

    public SarifLogBuilder addConfigurationError(Report.ConfigurationError error) {
        SarifLog.AssociatedRule associatedRule = SarifLog.AssociatedRule.builder().id(error.rule().getName()).build();
        SarifLog.Message message = SarifLog.Message.builder().text(error.issue()).build();
        SarifLog.ToolConfigurationNotification toolConfigurationNotification = SarifLog.ToolConfigurationNotification.builder().associatedRule(associatedRule).message(message).build();
        this.toolConfigurationNotifications.add(toolConfigurationNotification);
        return this;
    }

    public SarifLog build() {
        ArrayList<SarifLog.ReportingDescriptor> rules = new ArrayList<SarifLog.ReportingDescriptor>(this.locationsByRule.keySet());
        ArrayList<SarifLog.Result> results = new ArrayList<SarifLog.Result>();
        int size = rules.size();
        for (int i = 0; i < size; ++i) {
            SarifLog.ReportingDescriptor rule = (SarifLog.ReportingDescriptor)rules.get(i);
            List<SarifLog.Location> locations = this.locationsByRule.get(rule);
            results.add(this.resultFrom(rule, i, locations));
        }
        SarifLog.Component driver = this.getDriverComponent().toBuilder().rules(rules).build();
        SarifLog.Tool tool = SarifLog.Tool.builder().driver(driver).build();
        SarifLog.Invocation invocation = SarifLog.Invocation.builder().toolExecutionNotifications(this.toolExecutionNotifications).toolConfigurationNotifications(this.toolConfigurationNotifications).executionSuccessful(this.isExecutionSuccessful()).build();
        SarifLog.Run run = SarifLog.Run.builder().tool(tool).results(results).invocations(Collections.singletonList(invocation)).build();
        List<SarifLog.Run> runs = Collections.singletonList(run);
        return SarifLog.builder().runs(runs).build();
    }

    private boolean isExecutionSuccessful() {
        return this.toolExecutionNotifications.isEmpty() && this.toolConfigurationNotifications.isEmpty();
    }

    private SarifLog.Result resultFrom(SarifLog.ReportingDescriptor rule, Integer ruleIndex, List<SarifLog.Location> locations) {
        SarifLog.Result result = SarifLog.Result.builder().ruleId(rule.getId()).ruleIndex(ruleIndex).build();
        SarifLog.Message message = SarifLog.Message.builder().text(rule.getShortDescription().getText()).build();
        result.setMessage(message);
        result.setLocations(locations);
        return result;
    }

    private SarifLog.Location getRuleViolationLocation(RuleViolation rv) {
        SarifLog.ArtifactLocation artifactLocation = SarifLog.ArtifactLocation.builder().uri(rv.getFilename()).build();
        SarifLog.Region region = SarifLog.Region.builder().startLine(rv.getBeginLine()).endLine(rv.getEndLine()).startColumn(rv.getBeginColumn()).endColumn(rv.getEndColumn()).build();
        SarifLog.PhysicalLocation physicalLocation = SarifLog.PhysicalLocation.builder().artifactLocation(artifactLocation).region(region).build();
        return SarifLog.Location.builder().physicalLocation(physicalLocation).build();
    }

    private SarifLog.ReportingDescriptor getReportingDescriptor(RuleViolation rv) {
        return SarifLog.ReportingDescriptor.builder().id(rv.getRule().getName()).shortDescription(new SarifLog.MultiformatMessage(rv.getDescription())).fullDescription(new SarifLog.MultiformatMessage(rv.getRule().getDescription())).helpUri(rv.getRule().getExternalInfoUrl()).help(new SarifLog.MultiformatMessage(rv.getRule().getDescription())).properties(this.getRuleProperties(rv)).build();
    }

    private SarifLog.PropertyBag getRuleProperties(RuleViolation rv) {
        return SarifLog.PropertyBag.builder().ruleset(rv.getRule().getRuleSetName()).priority(rv.getRule().getPriority().getPriority()).tags(new HashSet<String>(Arrays.asList(rv.getRule().getRuleSetName()))).build();
    }

    private SarifLog.Component getDriverComponent() {
        return SarifLog.Component.builder().name("PMD").version(PMDVersion.VERSION).informationUri("https://pmd.github.io/pmd/").build();
    }
}

