/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.compiler;

import apex.jorje.semantic.common.SfdcCalled;
import apex.jorje.semantic.compiler.CodeUnit;
import apex.jorje.semantic.exception.DependentTypeException;
import apex.jorje.semantic.symbol.type.TypeInfo;
import apex.jorje.services.exception.CompilationException;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.Map;

public class ErrorPropagator {
    private static final ErrorPropagator INSTANCE = new ErrorPropagator();

    private ErrorPropagator() {
    }

    @SfdcCalled
    public static ErrorPropagator get() {
        return INSTANCE;
    }

    private static boolean isValid(CodeUnit unit) {
        return unit.getErrors().isEmpty();
    }

    @SfdcCalled
    public void propagateErrors(Collection<CodeUnit> units) {
        if (units.stream().allMatch(ErrorPropagator::isValid)) {
            return;
        }
        ImmutableMap.Builder<TypeInfo, CodeUnit> builder = new ImmutableMap.Builder<TypeInfo, CodeUnit>();
        ArrayListMultimap<TypeInfo, TypeInfo> referringMap = ArrayListMultimap.create();
        for (CodeUnit unit : units) {
            TypeInfo type = unit.getType();
            for (TypeInfo referenceType : unit.getReferencesForErrorPropagation()) {
                referringMap.put(referenceType, type);
            }
            builder.put(type, unit);
        }
        ImmutableMap<TypeInfo, CodeUnit> sourcesMap = builder.build();
        for (CodeUnit unit : units) {
            this.propagateErrors(referringMap, sourcesMap, unit);
        }
    }

    private void propagateErrors(Multimap<TypeInfo, TypeInfo> referringMap, Map<TypeInfo, CodeUnit> sourcesMap, CodeUnit unit) {
        if (unit.getErrors().isEmpty()) {
            return;
        }
        CompilationException firstError = unit.getErrors().getFirst();
        DependentTypeException dependentError = DependentTypeException.createDependentTypeException(firstError, unit.getType().getApexName());
        for (TypeInfo referringTypes : referringMap.get(unit.getType())) {
            CodeUnit referringUnit = sourcesMap.get(referringTypes);
            if (!referringUnit.getErrors().isEmpty()) continue;
            referringUnit.getErrors().markInvalid(dependentError);
            this.propagateErrors(referringMap, sourcesMap, referringUnit);
        }
    }
}

