/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.ast.expression;

import apex.jorje.data.Identifier;
import apex.jorje.data.Location;
import apex.jorje.data.ast.Expr;
import apex.jorje.semantic.ast.AstNode;
import apex.jorje.semantic.ast.context.Emitter;
import apex.jorje.semantic.ast.expression.Expression;
import apex.jorje.semantic.ast.visitor.AstVisitor;
import apex.jorje.semantic.ast.visitor.Scope;
import apex.jorje.semantic.ast.visitor.ValidationScope;
import apex.jorje.semantic.bcl.AsmMethod;
import apex.jorje.semantic.symbol.resolver.SymbolResolver;
import apex.jorje.semantic.symbol.type.TypeInfo;
import apex.jorje.semantic.symbol.type.TypeInfos;
import apex.jorje.semantic.symbol.type.common.JavaTypeInfoUtil;
import apex.jorje.services.I18nSupport;
import apex.jorje.services.printers.PrintContexts;
import apex.jorje.services.printers.PrinterUtil;
import com.google.common.collect.Iterables;
import com.google.common.collect.MoreLists;
import java.lang.reflect.Field;
import java.util.List;

public class JavaVariableExpression
extends Expression {
    private final Location loc;
    private final List<Identifier> names;
    private Field field;

    public JavaVariableExpression(AstNode definingNode, Expr.JavaVariableExpr expr) {
        super(definingNode);
        this.loc = expr.loc;
        this.names = expr.names;
    }

    @Override
    public <T extends Scope> void traverse(AstVisitor<T> visitor, T scope) {
        visitor.visit(this, scope);
        visitor.visitEnd(this, scope);
    }

    @Override
    public void validate(SymbolResolver symbols, ValidationScope scope) {
        if (!this.getDefiningType().getCodeUnitDetails().isTrusted()) {
            scope.getErrors().markInvalid((AstNode)this, I18nSupport.getLabel("illegal.java.expression"));
            return;
        }
        if (this.names.size() <= 1) {
            scope.getErrors().markInvalid((AstNode)this, I18nSupport.getLabel("invalid.java.expression"));
            return;
        }
        String className = PrinterUtil.get().getFactory().dottedIdentifier().print(MoreLists.removeLast(this.names), PrintContexts.empty());
        String fieldName = PrinterUtil.get().getFactory().identifierPrinter().print(Iterables.getLast(this.names), PrintContexts.empty());
        Class clazz = JavaTypeInfoUtil.get().lookupClass(className);
        if (clazz == null) {
            scope.getErrors().markInvalid((AstNode)this, I18nSupport.getLabel("invalid.java.expression.class.not.found", className));
            return;
        }
        try {
            this.field = clazz.getDeclaredField(fieldName);
        }
        catch (NoSuchFieldException x) {
            scope.getErrors().markInvalid((AstNode)this, I18nSupport.getLabel("invalid.java.expression.field.not.found", fieldName, className));
            return;
        }
        this.setType(JavaTypeInfoUtil.get().getOrCreate(this.field.getType()));
    }

    @Override
    public void emit(Emitter emitter) {
        TypeInfo definingType = JavaTypeInfoUtil.get().getOrCreate(this.field.getDeclaringClass());
        emitter.push(this.loc, this.field.getName());
        AsmMethod asmMethod = AsmMethod.builder().setDefiningTypeAsBytecodeName(definingType).setSignature((TypeInfo)TypeInfos.OBJECT, (TypeInfo)TypeInfos.STRING).setFunction("__sfdc_getStaticField").invokeStatic().build();
        emitter.emit(this.loc, asmMethod);
    }

    @Override
    public Location getLoc() {
        return this.loc;
    }

    public List<Identifier> getNames() {
        return this.names;
    }
}

