/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.lsp.impl.tests;

import apex.jorje.lsp.api.tests.TestService;
import apex.jorje.lsp.impl.index.ApexIndex;
import apex.jorje.lsp.impl.tests.TestMethod;
import apex.jorje.lsp.impl.utils.Locations;
import com.google.common.collect.Lists;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.eclipse.jdt.internal.core.nd.IReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class StandardTestService
implements TestService {
    private static final Logger logger = LoggerFactory.getLogger(StandardTestService.class);
    private final Provider<ApexIndex> apexIndexProvider;

    @Inject
    public StandardTestService(Provider<ApexIndex> apexIndexProvider) {
        this.apexIndexProvider = apexIndexProvider;
    }

    @Override
    public CompletableFuture<List<TestMethod>> getTestMethods() {
        ApexIndex apexIndex = (ApexIndex)this.apexIndexProvider.get();
        ArrayList result = Lists.newArrayList();
        try (IReader ignore = apexIndex.getNd().acquireReadLock();){
            result.addAll(apexIndex.getTestMethods().stream().map(m -> {
                URI uri = URI.create(m.getDefiningType().getFile().getFilename().getString());
                return new TestMethod(m.getMethodName().getString(), m.getDefiningType().getTypeId().getApexName().getString(), Locations.from(uri, m.getLocation()));
            }).collect(Collectors.toList()));
        }
        catch (Exception e) {
            logger.error("Error trying to get test method info", (Throwable)e);
        }
        return CompletableFuture.completedFuture(result);
    }
}

