/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.lsp.impl.completions.soql;

import apex.jorje.lsp.api.completions.CompletionStrategy;
import apex.jorje.lsp.api.document.Document;
import apex.jorje.lsp.api.workspace.ApexDocumentService;
import apex.jorje.lsp.impl.completions.CompletionItemTransformer;
import apex.jorje.lsp.impl.completions.soql.SoqlCompletionUtils;
import apex.jorje.lsp.impl.completions.soql.SoqlSnippetCompletionStrategy;
import apex.jorje.lsp.impl.document.BadLocationException;
import apex.jorje.lsp.impl.index.ApexIndex;
import apex.jorje.lsp.impl.utils.Locations;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.eclipse.lsp4j.CompletionItem;
import org.eclipse.lsp4j.TextDocumentPositionParams;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import soql.completion.SoqlCompletionProvider;

public class SoqlCompletionStrategy
implements CompletionStrategy {
    private static final Logger logger = LoggerFactory.getLogger(SoqlCompletionStrategy.class);
    private final ApexDocumentService documentService;
    private final Provider<ApexIndex> apexIndexProvider;

    @Inject
    public SoqlCompletionStrategy(ApexDocumentService documentService, Provider<ApexIndex> apexIndexProvider) {
        this.documentService = documentService;
        this.apexIndexProvider = apexIndexProvider;
    }

    @Override
    public List<CompletionItem> provideCompletions(TextDocumentPositionParams params) {
        Optional<Document> optDoc = this.documentService.retrieve(URI.create(params.getTextDocument().getUri()));
        ArrayList<CompletionItem> items = Lists.newArrayList();
        optDoc.ifPresent(doc -> {
            try {
                SoqlCompletionProvider service = new SoqlCompletionProvider(doc.getSource(), Locations.getOffset(doc, params.getPosition()), SoqlCompletionUtils.getSObjectTypeNames(this.apexIndexProvider));
                ImmutableList fieldNames = service.getSObjectName().isPresent() ? SoqlCompletionUtils.getSObjectFieldNames(this.apexIndexProvider, (String)service.getSObjectName().get()) : ImmutableList.of();
                items.addAll(CompletionItemTransformer.transform(service.provideCompletions(fieldNames)));
            }
            catch (BadLocationException exception) {
                logger.error("Encountered a bad location while providing soql completion", (Throwable)exception);
            }
        });
        items.add(SoqlSnippetCompletionStrategy.getSoqlSnippet(this.apexIndexProvider));
        return items;
    }
}

