/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.data.errors;

import apex.jorje.data.Location;
import java.util.Set;

public abstract class LexicalError {
    private LexicalError() {
    }

    public static final LexicalError _UnexpectedLexicalError(Location loc, String message) {
        return new UnexpectedLexicalError(loc, message);
    }

    public static final LexicalError _UnrecognizedSymbol(Location loc, String symbol) {
        return new UnrecognizedSymbol(loc, symbol);
    }

    public static final LexicalError _UnexpectedSymbol(Location loc, String found, String expected) {
        return new UnexpectedSymbol(loc, found, expected);
    }

    public static final LexicalError _SymbolNotInExpectedSet(Location loc, String found, Set<String> expected) {
        return new SymbolNotInExpectedSet(loc, found, expected);
    }

    public static final LexicalError _SymbolInUnexpectedSet(Location loc, String found, Set<String> unexpected) {
        return new SymbolInUnexpectedSet(loc, found, unexpected);
    }

    public static final LexicalError _SymbolNotInRange(Location loc, String found, String begin, String end) {
        return new SymbolNotInRange(loc, found, begin, end);
    }

    public static final LexicalError _UnterminatedString(Location loc, String quote) {
        return new UnterminatedString(loc, quote);
    }

    public static final LexicalError _UnterminatedComment(Location loc, String closeComment) {
        return new UnterminatedComment(loc, closeComment);
    }

    public static final LexicalError _InvalidIdentifier(Location loc, String identifier) {
        return new InvalidIdentifier(loc, identifier);
    }

    public static final LexicalError _InvalidControlChar(Location loc, char character) {
        return new InvalidControlChar(loc, character);
    }

    public static final LexicalError _InvalidSymbol(Location loc, char symbol) {
        return new InvalidSymbol(loc, symbol);
    }

    public static final LexicalError _InvalidTime(Location loc, String time) {
        return new InvalidTime(loc, time);
    }

    public static final LexicalError _InvalidDate(Location loc, String date) {
        return new InvalidDate(loc, date);
    }

    public static final LexicalError _InvalidDateTime(Location loc, String dateTime) {
        return new InvalidDateTime(loc, dateTime);
    }

    public abstract <ResultType> ResultType match(MatchBlock<ResultType> var1);

    public abstract void _switch(SwitchBlock var1);

    public static final class InvalidDateTime
    extends LexicalError {
        public Location loc;
        public String dateTime;

        public InvalidDateTime(Location loc, String dateTime) {
            this.loc = loc;
            this.dateTime = dateTime;
        }

        @Override
        public <ResultType> ResultType match(MatchBlock<ResultType> matchBlock) {
            return matchBlock._case(this);
        }

        @Override
        public void _switch(SwitchBlock switchBlock) {
            switchBlock._case(this);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.loc == null ? 0 : this.loc.hashCode());
            result = 31 * result + (this.dateTime == null ? 0 : this.dateTime.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            InvalidDateTime other = (InvalidDateTime)obj;
            if (this.loc == null ? other.loc != null : !this.loc.equals(other.loc)) {
                return false;
            }
            return !(this.dateTime == null ? other.dateTime != null : !this.dateTime.equals(other.dateTime));
        }

        public String toString() {
            return "InvalidDateTime(loc = " + this.loc + ", dateTime = " + this.dateTime + ")";
        }
    }

    public static final class InvalidDate
    extends LexicalError {
        public Location loc;
        public String date;

        public InvalidDate(Location loc, String date) {
            this.loc = loc;
            this.date = date;
        }

        @Override
        public <ResultType> ResultType match(MatchBlock<ResultType> matchBlock) {
            return matchBlock._case(this);
        }

        @Override
        public void _switch(SwitchBlock switchBlock) {
            switchBlock._case(this);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.loc == null ? 0 : this.loc.hashCode());
            result = 31 * result + (this.date == null ? 0 : this.date.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            InvalidDate other = (InvalidDate)obj;
            if (this.loc == null ? other.loc != null : !this.loc.equals(other.loc)) {
                return false;
            }
            return !(this.date == null ? other.date != null : !this.date.equals(other.date));
        }

        public String toString() {
            return "InvalidDate(loc = " + this.loc + ", date = " + this.date + ")";
        }
    }

    public static final class InvalidTime
    extends LexicalError {
        public Location loc;
        public String time;

        public InvalidTime(Location loc, String time) {
            this.loc = loc;
            this.time = time;
        }

        @Override
        public <ResultType> ResultType match(MatchBlock<ResultType> matchBlock) {
            return matchBlock._case(this);
        }

        @Override
        public void _switch(SwitchBlock switchBlock) {
            switchBlock._case(this);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.loc == null ? 0 : this.loc.hashCode());
            result = 31 * result + (this.time == null ? 0 : this.time.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            InvalidTime other = (InvalidTime)obj;
            if (this.loc == null ? other.loc != null : !this.loc.equals(other.loc)) {
                return false;
            }
            return !(this.time == null ? other.time != null : !this.time.equals(other.time));
        }

        public String toString() {
            return "InvalidTime(loc = " + this.loc + ", time = " + this.time + ")";
        }
    }

    public static final class InvalidSymbol
    extends LexicalError {
        public Location loc;
        public char symbol;

        public InvalidSymbol(Location loc, char symbol) {
            this.loc = loc;
            this.symbol = symbol;
        }

        @Override
        public <ResultType> ResultType match(MatchBlock<ResultType> matchBlock) {
            return matchBlock._case(this);
        }

        @Override
        public void _switch(SwitchBlock switchBlock) {
            switchBlock._case(this);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.loc == null ? 0 : this.loc.hashCode());
            result = 31 * result + this.symbol;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            InvalidSymbol other = (InvalidSymbol)obj;
            if (this.loc == null ? other.loc != null : !this.loc.equals(other.loc)) {
                return false;
            }
            return this.symbol == other.symbol;
        }

        public String toString() {
            return "InvalidSymbol(loc = " + this.loc + ", symbol = " + this.symbol + ")";
        }
    }

    public static final class InvalidControlChar
    extends LexicalError {
        public Location loc;
        public char character;

        public InvalidControlChar(Location loc, char character) {
            this.loc = loc;
            this.character = character;
        }

        @Override
        public <ResultType> ResultType match(MatchBlock<ResultType> matchBlock) {
            return matchBlock._case(this);
        }

        @Override
        public void _switch(SwitchBlock switchBlock) {
            switchBlock._case(this);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.loc == null ? 0 : this.loc.hashCode());
            result = 31 * result + this.character;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            InvalidControlChar other = (InvalidControlChar)obj;
            if (this.loc == null ? other.loc != null : !this.loc.equals(other.loc)) {
                return false;
            }
            return this.character == other.character;
        }

        public String toString() {
            return "InvalidControlChar(loc = " + this.loc + ", character = " + this.character + ")";
        }
    }

    public static final class InvalidIdentifier
    extends LexicalError {
        public Location loc;
        public String identifier;

        public InvalidIdentifier(Location loc, String identifier) {
            this.loc = loc;
            this.identifier = identifier;
        }

        @Override
        public <ResultType> ResultType match(MatchBlock<ResultType> matchBlock) {
            return matchBlock._case(this);
        }

        @Override
        public void _switch(SwitchBlock switchBlock) {
            switchBlock._case(this);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.loc == null ? 0 : this.loc.hashCode());
            result = 31 * result + (this.identifier == null ? 0 : this.identifier.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            InvalidIdentifier other = (InvalidIdentifier)obj;
            if (this.loc == null ? other.loc != null : !this.loc.equals(other.loc)) {
                return false;
            }
            return !(this.identifier == null ? other.identifier != null : !this.identifier.equals(other.identifier));
        }

        public String toString() {
            return "InvalidIdentifier(loc = " + this.loc + ", identifier = " + this.identifier + ")";
        }
    }

    public static final class UnterminatedComment
    extends LexicalError {
        public Location loc;
        public String closeComment;

        public UnterminatedComment(Location loc, String closeComment) {
            this.loc = loc;
            this.closeComment = closeComment;
        }

        @Override
        public <ResultType> ResultType match(MatchBlock<ResultType> matchBlock) {
            return matchBlock._case(this);
        }

        @Override
        public void _switch(SwitchBlock switchBlock) {
            switchBlock._case(this);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.loc == null ? 0 : this.loc.hashCode());
            result = 31 * result + (this.closeComment == null ? 0 : this.closeComment.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            UnterminatedComment other = (UnterminatedComment)obj;
            if (this.loc == null ? other.loc != null : !this.loc.equals(other.loc)) {
                return false;
            }
            return !(this.closeComment == null ? other.closeComment != null : !this.closeComment.equals(other.closeComment));
        }

        public String toString() {
            return "UnterminatedComment(loc = " + this.loc + ", closeComment = " + this.closeComment + ")";
        }
    }

    public static final class UnterminatedString
    extends LexicalError {
        public Location loc;
        public String quote;

        public UnterminatedString(Location loc, String quote) {
            this.loc = loc;
            this.quote = quote;
        }

        @Override
        public <ResultType> ResultType match(MatchBlock<ResultType> matchBlock) {
            return matchBlock._case(this);
        }

        @Override
        public void _switch(SwitchBlock switchBlock) {
            switchBlock._case(this);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.loc == null ? 0 : this.loc.hashCode());
            result = 31 * result + (this.quote == null ? 0 : this.quote.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            UnterminatedString other = (UnterminatedString)obj;
            if (this.loc == null ? other.loc != null : !this.loc.equals(other.loc)) {
                return false;
            }
            return !(this.quote == null ? other.quote != null : !this.quote.equals(other.quote));
        }

        public String toString() {
            return "UnterminatedString(loc = " + this.loc + ", quote = " + this.quote + ")";
        }
    }

    public static final class SymbolNotInRange
    extends LexicalError {
        public Location loc;
        public String found;
        public String begin;
        public String end;

        public SymbolNotInRange(Location loc, String found, String begin, String end) {
            this.loc = loc;
            this.found = found;
            this.begin = begin;
            this.end = end;
        }

        @Override
        public <ResultType> ResultType match(MatchBlock<ResultType> matchBlock) {
            return matchBlock._case(this);
        }

        @Override
        public void _switch(SwitchBlock switchBlock) {
            switchBlock._case(this);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.loc == null ? 0 : this.loc.hashCode());
            result = 31 * result + (this.found == null ? 0 : this.found.hashCode());
            result = 31 * result + (this.begin == null ? 0 : this.begin.hashCode());
            result = 31 * result + (this.end == null ? 0 : this.end.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            SymbolNotInRange other = (SymbolNotInRange)obj;
            if (this.loc == null ? other.loc != null : !this.loc.equals(other.loc)) {
                return false;
            }
            if (this.found == null ? other.found != null : !this.found.equals(other.found)) {
                return false;
            }
            if (this.begin == null ? other.begin != null : !this.begin.equals(other.begin)) {
                return false;
            }
            return !(this.end == null ? other.end != null : !this.end.equals(other.end));
        }

        public String toString() {
            return "SymbolNotInRange(loc = " + this.loc + ", found = " + this.found + ", begin = " + this.begin + ", end = " + this.end + ")";
        }
    }

    public static final class SymbolInUnexpectedSet
    extends LexicalError {
        public Location loc;
        public String found;
        public Set<String> unexpected;

        public SymbolInUnexpectedSet(Location loc, String found, Set<String> unexpected) {
            this.loc = loc;
            this.found = found;
            this.unexpected = unexpected;
        }

        @Override
        public <ResultType> ResultType match(MatchBlock<ResultType> matchBlock) {
            return matchBlock._case(this);
        }

        @Override
        public void _switch(SwitchBlock switchBlock) {
            switchBlock._case(this);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.loc == null ? 0 : this.loc.hashCode());
            result = 31 * result + (this.found == null ? 0 : this.found.hashCode());
            result = 31 * result + (this.unexpected == null ? 0 : this.unexpected.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            SymbolInUnexpectedSet other = (SymbolInUnexpectedSet)obj;
            if (this.loc == null ? other.loc != null : !this.loc.equals(other.loc)) {
                return false;
            }
            if (this.found == null ? other.found != null : !this.found.equals(other.found)) {
                return false;
            }
            return !(this.unexpected == null ? other.unexpected != null : !this.unexpected.equals(other.unexpected));
        }

        public String toString() {
            return "SymbolInUnexpectedSet(loc = " + this.loc + ", found = " + this.found + ", unexpected = " + this.unexpected + ")";
        }
    }

    public static final class SymbolNotInExpectedSet
    extends LexicalError {
        public Location loc;
        public String found;
        public Set<String> expected;

        public SymbolNotInExpectedSet(Location loc, String found, Set<String> expected) {
            this.loc = loc;
            this.found = found;
            this.expected = expected;
        }

        @Override
        public <ResultType> ResultType match(MatchBlock<ResultType> matchBlock) {
            return matchBlock._case(this);
        }

        @Override
        public void _switch(SwitchBlock switchBlock) {
            switchBlock._case(this);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.loc == null ? 0 : this.loc.hashCode());
            result = 31 * result + (this.found == null ? 0 : this.found.hashCode());
            result = 31 * result + (this.expected == null ? 0 : this.expected.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            SymbolNotInExpectedSet other = (SymbolNotInExpectedSet)obj;
            if (this.loc == null ? other.loc != null : !this.loc.equals(other.loc)) {
                return false;
            }
            if (this.found == null ? other.found != null : !this.found.equals(other.found)) {
                return false;
            }
            return !(this.expected == null ? other.expected != null : !this.expected.equals(other.expected));
        }

        public String toString() {
            return "SymbolNotInExpectedSet(loc = " + this.loc + ", found = " + this.found + ", expected = " + this.expected + ")";
        }
    }

    public static final class UnexpectedSymbol
    extends LexicalError {
        public Location loc;
        public String found;
        public String expected;

        public UnexpectedSymbol(Location loc, String found, String expected) {
            this.loc = loc;
            this.found = found;
            this.expected = expected;
        }

        @Override
        public <ResultType> ResultType match(MatchBlock<ResultType> matchBlock) {
            return matchBlock._case(this);
        }

        @Override
        public void _switch(SwitchBlock switchBlock) {
            switchBlock._case(this);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.loc == null ? 0 : this.loc.hashCode());
            result = 31 * result + (this.found == null ? 0 : this.found.hashCode());
            result = 31 * result + (this.expected == null ? 0 : this.expected.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            UnexpectedSymbol other = (UnexpectedSymbol)obj;
            if (this.loc == null ? other.loc != null : !this.loc.equals(other.loc)) {
                return false;
            }
            if (this.found == null ? other.found != null : !this.found.equals(other.found)) {
                return false;
            }
            return !(this.expected == null ? other.expected != null : !this.expected.equals(other.expected));
        }

        public String toString() {
            return "UnexpectedSymbol(loc = " + this.loc + ", found = " + this.found + ", expected = " + this.expected + ")";
        }
    }

    public static final class UnrecognizedSymbol
    extends LexicalError {
        public Location loc;
        public String symbol;

        public UnrecognizedSymbol(Location loc, String symbol) {
            this.loc = loc;
            this.symbol = symbol;
        }

        @Override
        public <ResultType> ResultType match(MatchBlock<ResultType> matchBlock) {
            return matchBlock._case(this);
        }

        @Override
        public void _switch(SwitchBlock switchBlock) {
            switchBlock._case(this);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.loc == null ? 0 : this.loc.hashCode());
            result = 31 * result + (this.symbol == null ? 0 : this.symbol.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            UnrecognizedSymbol other = (UnrecognizedSymbol)obj;
            if (this.loc == null ? other.loc != null : !this.loc.equals(other.loc)) {
                return false;
            }
            return !(this.symbol == null ? other.symbol != null : !this.symbol.equals(other.symbol));
        }

        public String toString() {
            return "UnrecognizedSymbol(loc = " + this.loc + ", symbol = " + this.symbol + ")";
        }
    }

    public static final class UnexpectedLexicalError
    extends LexicalError {
        public Location loc;
        public String message;

        public UnexpectedLexicalError(Location loc, String message) {
            this.loc = loc;
            this.message = message;
        }

        @Override
        public <ResultType> ResultType match(MatchBlock<ResultType> matchBlock) {
            return matchBlock._case(this);
        }

        @Override
        public void _switch(SwitchBlock switchBlock) {
            switchBlock._case(this);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.loc == null ? 0 : this.loc.hashCode());
            result = 31 * result + (this.message == null ? 0 : this.message.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            UnexpectedLexicalError other = (UnexpectedLexicalError)obj;
            if (this.loc == null ? other.loc != null : !this.loc.equals(other.loc)) {
                return false;
            }
            return !(this.message == null ? other.message != null : !this.message.equals(other.message));
        }

        public String toString() {
            return "UnexpectedLexicalError(loc = " + this.loc + ", message = " + this.message + ")";
        }
    }

    public static abstract class SwitchBlockWithDefault
    implements SwitchBlock {
        @Override
        public void _case(UnexpectedLexicalError x) {
            this._default(x);
        }

        @Override
        public void _case(UnrecognizedSymbol x) {
            this._default(x);
        }

        @Override
        public void _case(UnexpectedSymbol x) {
            this._default(x);
        }

        @Override
        public void _case(SymbolNotInExpectedSet x) {
            this._default(x);
        }

        @Override
        public void _case(SymbolInUnexpectedSet x) {
            this._default(x);
        }

        @Override
        public void _case(SymbolNotInRange x) {
            this._default(x);
        }

        @Override
        public void _case(UnterminatedString x) {
            this._default(x);
        }

        @Override
        public void _case(UnterminatedComment x) {
            this._default(x);
        }

        @Override
        public void _case(InvalidIdentifier x) {
            this._default(x);
        }

        @Override
        public void _case(InvalidControlChar x) {
            this._default(x);
        }

        @Override
        public void _case(InvalidSymbol x) {
            this._default(x);
        }

        @Override
        public void _case(InvalidTime x) {
            this._default(x);
        }

        @Override
        public void _case(InvalidDate x) {
            this._default(x);
        }

        @Override
        public void _case(InvalidDateTime x) {
            this._default(x);
        }

        protected abstract void _default(LexicalError var1);
    }

    public static interface SwitchBlock {
        public void _case(UnexpectedLexicalError var1);

        public void _case(UnrecognizedSymbol var1);

        public void _case(UnexpectedSymbol var1);

        public void _case(SymbolNotInExpectedSet var1);

        public void _case(SymbolInUnexpectedSet var1);

        public void _case(SymbolNotInRange var1);

        public void _case(UnterminatedString var1);

        public void _case(UnterminatedComment var1);

        public void _case(InvalidIdentifier var1);

        public void _case(InvalidControlChar var1);

        public void _case(InvalidSymbol var1);

        public void _case(InvalidTime var1);

        public void _case(InvalidDate var1);

        public void _case(InvalidDateTime var1);
    }

    public static abstract class MatchBlockWithDefault<ResultType>
    implements MatchBlock<ResultType> {
        @Override
        public ResultType _case(UnexpectedLexicalError x) {
            return this._default(x);
        }

        @Override
        public ResultType _case(UnrecognizedSymbol x) {
            return this._default(x);
        }

        @Override
        public ResultType _case(UnexpectedSymbol x) {
            return this._default(x);
        }

        @Override
        public ResultType _case(SymbolNotInExpectedSet x) {
            return this._default(x);
        }

        @Override
        public ResultType _case(SymbolInUnexpectedSet x) {
            return this._default(x);
        }

        @Override
        public ResultType _case(SymbolNotInRange x) {
            return this._default(x);
        }

        @Override
        public ResultType _case(UnterminatedString x) {
            return this._default(x);
        }

        @Override
        public ResultType _case(UnterminatedComment x) {
            return this._default(x);
        }

        @Override
        public ResultType _case(InvalidIdentifier x) {
            return this._default(x);
        }

        @Override
        public ResultType _case(InvalidControlChar x) {
            return this._default(x);
        }

        @Override
        public ResultType _case(InvalidSymbol x) {
            return this._default(x);
        }

        @Override
        public ResultType _case(InvalidTime x) {
            return this._default(x);
        }

        @Override
        public ResultType _case(InvalidDate x) {
            return this._default(x);
        }

        @Override
        public ResultType _case(InvalidDateTime x) {
            return this._default(x);
        }

        protected abstract ResultType _default(LexicalError var1);
    }

    public static interface MatchBlock<ResultType> {
        public ResultType _case(UnexpectedLexicalError var1);

        public ResultType _case(UnrecognizedSymbol var1);

        public ResultType _case(UnexpectedSymbol var1);

        public ResultType _case(SymbolNotInExpectedSet var1);

        public ResultType _case(SymbolInUnexpectedSet var1);

        public ResultType _case(SymbolNotInRange var1);

        public ResultType _case(UnterminatedString var1);

        public ResultType _case(UnterminatedComment var1);

        public ResultType _case(InvalidIdentifier var1);

        public ResultType _case(InvalidControlChar var1);

        public ResultType _case(InvalidSymbol var1);

        public ResultType _case(InvalidTime var1);

        public ResultType _case(InvalidDate var1);

        public ResultType _case(InvalidDateTime var1);
    }
}

