/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.matchers;

import apex.common.tuple.BooleanHolder;
import apex.jorje.semantic.ast.visitor.reference.ExternalDependency;
import apex.jorje.semantic.bcl.DmlOperation;
import apex.jorje.semantic.matchers.IsTypeWithApexName;
import apex.jorje.semantic.symbol.member.variable.Variable;
import apex.jorje.semantic.symbol.type.TypeInfo;
import java.util.Optional;
import org.hamcrest.Description;
import org.hamcrest.FeatureMatcher;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.TypeSafeDiagnosingMatcher;
import org.hamcrest.core.Is;

public class IsExternalDependency
extends TypeSafeDiagnosingMatcher<ExternalDependency> {
    private final Optional<Matcher<TypeInfo>> typeInfoMatcher;
    private final Optional<Matcher<Variable>> variableMatcher;
    private final Optional<Matcher<DmlOperation>> dmlOperationMatcher;
    private final Optional<Matcher<Boolean>> foreignKeyReferencedMatcher;
    private final Optional<Matcher<Boolean>> isLastMatcher;

    private IsExternalDependency(Builder builder) {
        this.typeInfoMatcher = builder.typeInfoMatcher;
        this.variableMatcher = builder.variableMatcher;
        this.dmlOperationMatcher = builder.dmlOperationMatcher;
        this.foreignKeyReferencedMatcher = builder.foreignKeyReferencedMatcher;
        this.isLastMatcher = builder.isLastMatcher;
    }

    public static Builder matching() {
        return new Builder();
    }

    private static FeatureMatcher<Variable, String> hasBytecodeName(Matcher<String> matcher) {
        return new FeatureMatcher<Variable, String>(matcher, "name", "name"){

            protected String featureValueOf(Variable actual) {
                return actual.getName();
            }
        };
    }

    public void describeTo(Description description) {
        this.typeInfoMatcher.ifPresent(matcher -> {
            description.appendText("type info: ");
            matcher.describeTo(description);
        });
        this.variableMatcher.ifPresent(matcher -> {
            description.appendText("\nvariable name: ");
            matcher.describeTo(description);
        });
        this.dmlOperationMatcher.ifPresent(matcher -> {
            description.appendText("\ndml op: ");
            matcher.describeTo(description);
        });
        this.foreignKeyReferencedMatcher.ifPresent(matcher -> {
            description.appendText("\nisReferencedViaForeignKey: ");
            matcher.describeTo(description);
        });
        this.isLastMatcher.ifPresent(matcher -> {
            description.appendText("\nisLast: ");
            matcher.describeTo(description);
        });
    }

    protected boolean matchesSafely(ExternalDependency externalDependency, Description description) {
        BooleanHolder matches = new BooleanHolder(true);
        this.typeInfoMatcher.ifPresent(matcher -> {
            if (!matcher.matches((Object)externalDependency.getTypeInfo())) {
                description.appendText("type info: ");
                matcher.describeMismatch((Object)externalDependency.getTypeInfo(), description);
                matches.value = false;
            }
        });
        this.variableMatcher.ifPresent(matcher -> {
            if (!matcher.matches((Object)externalDependency.getReferenceInfo().getVariable())) {
                description.appendText("\nvariable name: ");
                matcher.describeMismatch((Object)externalDependency.getReferenceInfo().getVariable(), description);
                matches.value = false;
            }
        });
        this.dmlOperationMatcher.ifPresent(matcher -> {
            if (!matcher.matches((Object)externalDependency.getReferenceInfo().getDmlOperation())) {
                description.appendText("\ndml op: ");
                matcher.describeMismatch((Object)externalDependency.getReferenceInfo().getDmlOperation(), description);
                matches.value = false;
            }
        });
        this.foreignKeyReferencedMatcher.ifPresent(matcher -> {
            if (!matcher.matches((Object)externalDependency.getReferenceInfo().isReferencedViaForeignKey())) {
                description.appendText("\nisReferencedViaForeignKey: ");
                matcher.describeMismatch((Object)externalDependency.getReferenceInfo().isReferencedViaForeignKey(), description);
                matches.value = false;
            }
        });
        this.isLastMatcher.ifPresent(matcher -> {
            if (!matcher.matches((Object)externalDependency.getReferenceInfo().isLast())) {
                description.appendText("\nisLast: ");
                matcher.describeMismatch((Object)externalDependency.getReferenceInfo().isLast(), description);
                matches.value = false;
            }
        });
        return matches.value;
    }

    public static class Builder {
        private Optional<Matcher<TypeInfo>> typeInfoMatcher = Optional.empty();
        private Optional<Matcher<Variable>> variableMatcher = Optional.empty();
        private Optional<Matcher<DmlOperation>> dmlOperationMatcher = Optional.empty();
        private Optional<Matcher<Boolean>> foreignKeyReferencedMatcher = Optional.empty();
        private Optional<Matcher<Boolean>> isLastMatcher = Optional.empty();

        private Builder() {
        }

        public Builder withTypeName(String apexName) {
            this.typeInfoMatcher = Optional.of(IsTypeWithApexName.hasApexName(apexName));
            return this;
        }

        public Builder withDmlOperation(DmlOperation dmlOperation) {
            this.dmlOperationMatcher = Optional.of(Is.is((Object)((Object)dmlOperation)));
            return this;
        }

        public Builder withFieldName(String variableName) {
            this.variableMatcher = Optional.of(IsExternalDependency.hasBytecodeName((Matcher<String>)Matchers.equalTo((Object)variableName)));
            return this;
        }

        public Builder withReferenceViaForeignKey() {
            this.foreignKeyReferencedMatcher = Optional.of(Is.is((Object)true));
            return this;
        }

        public Builder withNonReferenceViaForeignKey() {
            this.foreignKeyReferencedMatcher = Optional.of(Is.is((Object)false));
            return this;
        }

        public Builder withIsLast() {
            this.isLastMatcher = Optional.of(Is.is((Object)true));
            return this;
        }

        public Builder withNotLast() {
            this.isLastMatcher = Optional.of(Is.is((Object)false));
            return this;
        }

        public IsExternalDependency build() {
            return new IsExternalDependency(this);
        }
    }
}

