/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.rule.codestyle;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.ast.ASTAllocationExpression;
import net.sourceforge.pmd.lang.java.ast.ASTAnyTypeDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTClassOrInterfaceDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTEnumConstant;
import net.sourceforge.pmd.lang.java.ast.ASTMethodDeclaration;
import net.sourceforge.pmd.lang.java.ast.TypeNode;
import net.sourceforge.pmd.lang.java.rule.codestyle.AbstractNamingConventionRule;
import net.sourceforge.pmd.lang.java.types.TypeTestUtil;
import net.sourceforge.pmd.properties.BooleanProperty;
import net.sourceforge.pmd.properties.PropertyBuilder;
import net.sourceforge.pmd.properties.PropertyDescriptor;

public class MethodNamingConventionsRule
extends AbstractNamingConventionRule<ASTMethodDeclaration> {
    private final Map<String, String> descriptorToDisplayName = new HashMap<String, String>();
    @Deprecated
    private static final BooleanProperty CHECK_NATIVE_METHODS_DESCRIPTOR = new BooleanProperty("checkNativeMethods", "deprecated! Check native methods", true, 1.0f);
    private final PropertyDescriptor<Pattern> instanceRegex = this.defaultProp("", "instance").build();
    private final PropertyDescriptor<Pattern> staticRegex = this.defaultProp("static").build();
    private final PropertyDescriptor<Pattern> nativeRegex = this.defaultProp("native").build();
    private final PropertyDescriptor<Pattern> junit3Regex = this.defaultProp("JUnit 3 test").defaultValue("test[A-Z0-9][a-zA-Z0-9]*").build();
    private final PropertyDescriptor<Pattern> junit4Regex = this.defaultProp("JUnit 4 test").build();
    private final PropertyDescriptor<Pattern> junit5Regex = this.defaultProp("JUnit 5 test").build();

    public MethodNamingConventionsRule() {
        this.definePropertyDescriptor((PropertyDescriptor)CHECK_NATIVE_METHODS_DESCRIPTOR);
        this.definePropertyDescriptor(this.instanceRegex);
        this.definePropertyDescriptor(this.staticRegex);
        this.definePropertyDescriptor(this.nativeRegex);
        this.definePropertyDescriptor(this.junit3Regex);
        this.definePropertyDescriptor(this.junit4Regex);
        this.definePropertyDescriptor(this.junit5Regex);
    }

    private boolean isJunit5Test(ASTMethodDeclaration node) {
        return node.isAnnotationPresent("org.junit.jupiter.api.Test");
    }

    private boolean isJunit4Test(ASTMethodDeclaration node) {
        return node.isAnnotationPresent("org.junit.Test");
    }

    private boolean isJunit3Test(ASTMethodDeclaration node) {
        if (!node.getName().startsWith("test")) {
            return false;
        }
        Node parent = (Node)node.getFirstParentOfAnyType(new Class[]{ASTEnumConstant.class, ASTAllocationExpression.class, ASTAnyTypeDeclaration.class});
        if (!(parent instanceof ASTClassOrInterfaceDeclaration) || ((ASTClassOrInterfaceDeclaration)parent).isInterface()) {
            return false;
        }
        return TypeTestUtil.isA("junit.framework.TestCase", (TypeNode)((ASTClassOrInterfaceDeclaration)parent));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Object visit(ASTMethodDeclaration node, Object data) {
        if (node.isAnnotationPresent("java.lang.Override")) {
            return super.visit(node, data);
        }
        if (node.isNative()) {
            if (!((Boolean)this.getProperty((PropertyDescriptor)CHECK_NATIVE_METHODS_DESCRIPTOR)).booleanValue()) return super.visit(node, data);
            this.checkMatches(node, this.nativeRegex, data);
            return super.visit(node, data);
        } else if (node.isStatic()) {
            this.checkMatches(node, this.staticRegex, data);
            return super.visit(node, data);
        } else if (this.isJunit5Test(node)) {
            this.checkMatches(node, this.junit5Regex, data);
            return super.visit(node, data);
        } else if (this.isJunit4Test(node)) {
            this.checkMatches(node, this.junit4Regex, data);
            return super.visit(node, data);
        } else if (this.isJunit3Test(node)) {
            this.checkMatches(node, this.junit3Regex, data);
            return super.visit(node, data);
        } else {
            this.checkMatches(node, this.instanceRegex, data);
        }
        return super.visit(node, data);
    }

    @Override
    String defaultConvention() {
        return "[a-z][a-zA-Z0-9]*";
    }

    @Override
    String nameExtractor(ASTMethodDeclaration node) {
        return node.getName();
    }

    @Override
    PropertyBuilder.RegexPropertyBuilder defaultProp(String name, String displayName) {
        String display = (displayName + " method").trim();
        PropertyBuilder.RegexPropertyBuilder prop = super.defaultProp(name.isEmpty() ? "method" : name, display);
        this.descriptorToDisplayName.put(prop.getName(), display);
        return prop;
    }

    @Override
    String kindDisplayName(ASTMethodDeclaration node, PropertyDescriptor<Pattern> descriptor) {
        return this.descriptorToDisplayName.get(descriptor.name());
    }
}

