/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.data;

import apex.common.base.ObjectHash;
import apex.jorje.data.Identifier;
import apex.jorje.data.Location;
import apex.jorje.data.Locations;
import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public final class Identifiers {
    private Identifiers() {
    }

    public static Identifier newIdentifier(Location loc, String value) {
        if (loc == Locations.NONE) {
            return Identifiers.newIdentifier(value);
        }
        return new LocationIdentifier(loc, value);
    }

    public static Identifier newIdentifier(String value) {
        return new SyntheticIdentifier(value);
    }

    public static List<Identifier> newIdentifiers(String value) {
        return ImmutableList.of(Identifiers.newIdentifier(value));
    }

    public static List<Identifier> newIdentifiers(String ... values) {
        return Arrays.stream(values).map(Identifiers::newIdentifier).collect(Collectors.toList());
    }

    private static class SyntheticIdentifier
    implements Identifier {
        private final String value;

        private SyntheticIdentifier(String value) {
            this.value = value;
        }

        @Override
        public String getValue() {
            return this.value;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Identifier)) {
                return false;
            }
            Identifier that = (Identifier)o;
            return Objects.equals(this.getLoc(), that.getLoc()) && Objects.equals(this.value, that.getValue());
        }

        public int hashCode() {
            return Objects.hashCode(this.value);
        }

        public String toString() {
            return this.value;
        }
    }

    private static class LocationIdentifier
    implements Identifier {
        private final Location loc;
        private final String value;

        private LocationIdentifier(Location loc, String value) {
            this.loc = loc;
            this.value = value;
        }

        @Override
        public Location getLoc() {
            return this.loc;
        }

        @Override
        public String getValue() {
            return this.value;
        }

        public int hashCode() {
            return ObjectHash.hash(this.getLoc(), this.value);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Identifier)) {
                return false;
            }
            Identifier that = (Identifier)o;
            return Objects.equals(this.loc, that.getLoc()) && Objects.equals(this.value, that.getValue());
        }

        public String toString() {
            return this.value;
        }
    }
}

