/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.project.core;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import net.sourceforge.plantuml.klimt.creole.Display;
import net.sourceforge.plantuml.project.Load;
import net.sourceforge.plantuml.project.LoadPlanable;
import net.sourceforge.plantuml.project.PlanUtils;
import net.sourceforge.plantuml.project.core.AbstractTask;
import net.sourceforge.plantuml.project.core.Resource;
import net.sourceforge.plantuml.project.core.Task;
import net.sourceforge.plantuml.project.core.TaskAttribute;
import net.sourceforge.plantuml.project.core.TaskCode;
import net.sourceforge.plantuml.project.lang.CenterBorderColor;
import net.sourceforge.plantuml.project.solver.Solver;
import net.sourceforge.plantuml.project.solver.SolverImpl;
import net.sourceforge.plantuml.project.time.Day;
import net.sourceforge.plantuml.project.time.DayOfWeek;
import net.sourceforge.plantuml.style.StyleBuilder;
import net.sourceforge.plantuml.url.Url;

public class TaskImpl
extends AbstractTask
implements Task,
LoadPlanable {
    private final SortedSet<Day> pausedDay = new TreeSet<Day>();
    private final Set<DayOfWeek> pausedDayOfWeek = new HashSet<DayOfWeek>();
    private final Solver solver;
    private final Map<Resource, Integer> resources = new LinkedHashMap<Resource, Integer>();
    private final LoadPlanable defaultPlan;
    private boolean diamond;
    private int completion;
    private Display note;
    private Url url;
    private CenterBorderColor[] colors;

    @Override
    public void setUrl(Url url) {
        this.url = url;
    }

    public TaskImpl(StyleBuilder styleBuilder, TaskCode code, LoadPlanable plan, Day startingDay, int completion) {
        super(styleBuilder, code);
        this.completion = completion;
        this.defaultPlan = plan;
        this.solver = new SolverImpl(this);
        if (startingDay == null) {
            this.setStart(Day.create(0L));
        } else {
            this.setStart(startingDay);
        }
        this.setLoad(Load.inWinks(1));
    }

    @Override
    public int getLoadAt(Day instant) {
        if (this.isPaused(instant)) {
            return 0;
        }
        LoadPlanable result = this.defaultPlan;
        if (this.resources.size() > 0) {
            result = PlanUtils.multiply(this.defaultPlan, this.getResourcePlan());
        }
        return result.getLoadAt(instant);
    }

    private boolean isPaused(Day instant) {
        if (this.pausedDay.contains(instant)) {
            return true;
        }
        return this.pausedDayOfWeek(instant);
    }

    private boolean pausedDayOfWeek(Day instant) {
        for (DayOfWeek dayOfWeek : this.pausedDayOfWeek) {
            if (instant.getDayOfWeek() != dayOfWeek) continue;
            return true;
        }
        return false;
    }

    public int loadForResource(Resource res, Day instant) {
        if (this.resources.keySet().contains(res) && instant.compareTo(this.getStart()) >= 0 && instant.compareTo(this.getEnd()) <= 0) {
            if (this.isPaused(instant)) {
                return 0;
            }
            if (res.isClosedAt(instant)) {
                return 0;
            }
            return this.resources.get(res);
        }
        return 0;
    }

    @Override
    public void addPause(Day pause) {
        this.pausedDay.add(pause);
    }

    @Override
    public void addPause(DayOfWeek pause) {
        this.pausedDayOfWeek.add(pause);
    }

    private LoadPlanable getResourcePlan() {
        if (this.resources.size() == 0) {
            throw new IllegalStateException();
        }
        return new LoadPlanable(){

            @Override
            public int getLoadAt(Day instant) {
                int result = 0;
                for (Map.Entry ent : TaskImpl.this.resources.entrySet()) {
                    Resource res = (Resource)ent.getKey();
                    if (res.isClosedAt(instant)) continue;
                    int percentage = (Integer)ent.getValue();
                    result += percentage;
                }
                return result;
            }

            @Override
            public Day getLastDayIfAny() {
                return TaskImpl.this.getLastDayIfAny();
            }
        };
    }

    @Override
    public Day getLastDayIfAny() {
        Day result = null;
        for (Resource res : this.resources.keySet()) {
            if (res.getLastDayIfAny() == null) {
                return null;
            }
            if (result != null && result.compareTo(res.getLastDayIfAny()) >= 0) continue;
            result = res.getLastDayIfAny();
        }
        return result;
    }

    public String getPrettyDisplay() {
        if (this.resources.size() > 0) {
            StringBuilder result = new StringBuilder(this.getCode().getSimpleDisplay());
            result.append(" ");
            Iterator<Map.Entry<Resource, Integer>> it = this.resources.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<Resource, Integer> ent = it.next();
                result.append("{");
                result.append(ent.getKey().getName());
                int percentage = ent.getValue();
                if (percentage != 100) {
                    result.append(":" + percentage + "%");
                }
                result.append("}");
                if (!it.hasNext()) continue;
                result.append(" ");
            }
            return result.toString();
        }
        return this.getCode().getSimpleDisplay();
    }

    public String toString() {
        return this.getCode().toString();
    }

    public String debug() {
        return "" + this.getStart() + " ---> " + this.getEnd() + "   [" + this.getLoad() + "]";
    }

    @Override
    public Day getStart() {
        Day result = (Day)this.solver.getData(TaskAttribute.START);
        if (!this.diamond) {
            while (this.getLoadAt(result) == 0) {
                result = result.increment();
            }
        }
        return result;
    }

    @Override
    public Day getEnd() {
        return (Day)this.solver.getData(TaskAttribute.END);
    }

    @Override
    public Load getLoad() {
        return (Load)this.solver.getData(TaskAttribute.LOAD);
    }

    @Override
    public void setLoad(Load load) {
        this.solver.setData(TaskAttribute.LOAD, load);
    }

    @Override
    public void setStart(Day start) {
        this.solver.setData(TaskAttribute.START, start);
    }

    @Override
    public void setEnd(Day end) {
        this.solver.setData(TaskAttribute.END, end);
    }

    @Override
    public void setColors(CenterBorderColor ... colors) {
        this.colors = colors;
    }

    @Override
    public void addResource(Resource resource, int percentage) {
        this.resources.put(resource, percentage);
    }

    @Override
    public void setDiamond(boolean diamond) {
        this.diamond = diamond;
    }

    @Override
    public boolean isDiamond() {
        return this.diamond;
    }

    @Override
    public void setCompletion(int completion) {
        this.completion = completion;
    }

    public final Url getUrl() {
        return this.url;
    }

    public final CenterBorderColor getColors() {
        if (this.colors == null) {
            return null;
        }
        if (this.colors.length == 1) {
            return this.colors[0];
        }
        return this.colors[0].unlinearTo(this.colors[1], this.completion);
    }

    public final int getCompletion() {
        return this.completion;
    }

    public final Collection<Day> getAllPaused() {
        TreeSet<Day> result = new TreeSet<Day>(this.pausedDay);
        for (DayOfWeek dayOfWeek : this.pausedDayOfWeek) {
            this.addAll(result, dayOfWeek);
        }
        return Collections.unmodifiableCollection(result);
    }

    private void addAll(SortedSet<Day> result, DayOfWeek dayOfWeek) {
        Day start = this.getStart();
        Day end = this.getEnd();
        Day current = start;
        while (current.compareTo(end) <= 0) {
            if (current.getDayOfWeek() == dayOfWeek) {
                result.add(current);
            }
            current = current.increment();
        }
    }

    @Override
    public void setNote(Display note) {
        this.note = note;
    }

    public Display getNote() {
        return this.note;
    }

    public LoadPlanable getDefaultPlan() {
        return this.defaultPlan;
    }

    @Override
    public boolean isAssignedTo(Resource res) {
        return this.resources.containsKey(res);
    }
}

