/*****************************************************************************
 * Copyright (c) 2014-2020 OpenRCT2 developers
 *
 * For a complete list of all authors, please refer to contributors.md
 * Interested in contributing? Visit https://github.com/OpenRCT2/OpenRCT2
 *
 * OpenRCT2 is licensed under the GNU General Public License version 3.
 *****************************************************************************/

#pragma once

#include "GameAction.h"

DEFINE_GAME_ACTION(ParkMarketingAction, GameCommand::StartMarketingCampaign, GameActions::Result)
{
private:
    int32_t _type{};
    int32_t _item{};
    int32_t _numWeeks{};

public:
    ParkMarketingAction() = default;
    ParkMarketingAction(int32_t type, int32_t item, int32_t numWeeks);

    uint16_t GetActionFlags() const override;

    void Serialise(DataSerialiser & stream) override;
    GameActions::Result::Ptr Query() const override;
    GameActions::Result::Ptr Execute() const override;

private:
    GameActions::Result::Ptr CreateResult() const;
    money32 CalculatePrice() const;
};
