/*
 * Decompiled with CFR 0.152.
 */
package gnu.bytecode;

import gnu.bytecode.AttrContainer;
import gnu.bytecode.Attribute;
import gnu.bytecode.ClassType;
import gnu.bytecode.CodeAttr;
import gnu.bytecode.ConstantPool;
import gnu.bytecode.ConstantValueAttr;
import gnu.bytecode.CpoolClass;
import gnu.bytecode.CpoolUtf8;
import gnu.bytecode.Field;
import gnu.bytecode.InnerClassesAttr;
import gnu.bytecode.LineNumbersAttr;
import gnu.bytecode.LocalVarsAttr;
import gnu.bytecode.Method;
import gnu.bytecode.MiscAttr;
import gnu.bytecode.Scope;
import gnu.bytecode.SourceFileAttr;
import gnu.bytecode.Type;
import gnu.bytecode.Variable;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;

public class ClassFileInput
extends DataInputStream {
    ClassType ctype;
    InputStream str;

    public ClassFileInput(InputStream str) throws IOException {
        super(str);
    }

    public ClassFileInput(ClassType ctype, InputStream str) throws IOException, ClassFormatError {
        super(str);
        this.ctype = ctype;
        if (!this.readHeader()) {
            throw new ClassFormatError("invalid magic number");
        }
        ctype.constants = this.readConstants();
        this.readClassInfo();
        this.readFields();
        this.readMethods();
        this.readAttributes(ctype);
    }

    public static ClassType readClassType(InputStream str) throws IOException, ClassFormatError {
        ClassType ctype = new ClassType();
        ClassFileInput reader = new ClassFileInput(ctype, str);
        return ctype;
    }

    public static ClassType readClassType(String name, InputStream str) throws IOException, ClassFormatError {
        ClassType ctype = ClassType.make(name);
        if (ctype.constants != null) {
            ctype = new ClassType(name);
            Type.registerTypeForName(name, ctype);
            ctype.collectable = true;
        }
        new ClassFileInput(ctype, str);
        return ctype;
    }

    public boolean readHeader() throws IOException {
        int magic = this.readInt();
        if (magic != -889275714) {
            return false;
        }
        short minor_version = this.readShort();
        short major_version = this.readShort();
        return true;
    }

    public ConstantPool readConstants() throws IOException {
        return new ConstantPool(this);
    }

    public void readClassInfo() throws IOException {
        this.ctype.access_flags = this.readUnsignedShort();
        this.ctype.thisClassIndex = this.readUnsignedShort();
        CpoolClass clas = (CpoolClass)this.ctype.constants.getForced(this.ctype.thisClassIndex, 7);
        String name = clas.name.string;
        this.ctype.this_name = name.replace('/', '.');
        this.ctype.setSignature("L" + name + ";");
        this.ctype.superClassIndex = this.readUnsignedShort();
        if (this.ctype.superClassIndex == 0) {
            this.ctype.setSuper((ClassType)null);
        } else {
            clas = (CpoolClass)this.ctype.constants.getForced(this.ctype.superClassIndex, 7);
            name = clas.name.string;
            this.ctype.setSuper(name.replace('/', '.'));
        }
        int nInterfaces = this.readUnsignedShort();
        if (nInterfaces > 0) {
            this.ctype.interfaces = new ClassType[nInterfaces];
            this.ctype.interfaceIndexes = new int[nInterfaces];
            for (int i = 0; i < nInterfaces; ++i) {
                int index;
                this.ctype.interfaceIndexes[i] = index = this.readUnsignedShort();
                clas = (CpoolClass)this.ctype.constants.getForced(index, 7);
                name = clas.name.string.replace('/', '.');
                this.ctype.interfaces[i] = ClassType.make(name);
            }
        }
    }

    public int readAttributes(AttrContainer container) throws IOException {
        int count = this.readUnsignedShort();
        Attribute last = container.getAttributes();
        for (int i = 0; i < count; ++i) {
            if (last != null) {
                Attribute next;
                while ((next = last.getNext()) != null) {
                    last = next;
                }
            }
            int index = this.readUnsignedShort();
            CpoolUtf8 nameConstant = (CpoolUtf8)this.ctype.constants.getForced(index, 1);
            int length = this.readInt();
            nameConstant.intern();
            Attribute attr = this.readAttribute(nameConstant.string, length, container);
            if (attr == null) continue;
            attr.setContainer(container);
            if (attr.getNameIndex() == 0) {
                attr.setNameIndex(index);
            }
            if (last == null) {
                container.setAttributes(attr);
            } else {
                if (container.getAttributes() == attr) {
                    container.setAttributes(attr.getNext());
                    attr.setNext(null);
                }
                last.setNext(attr);
            }
            last = attr;
        }
        return count;
    }

    public final void skipAttribute(int length) throws IOException {
        int skipped;
        for (int read2 = 0; read2 < length; read2 += skipped) {
            skipped = (int)this.skip(length - read2);
            if (skipped != 0) continue;
            if (this.read() < 0) {
                throw new EOFException("EOF while reading class files attributes");
            }
            skipped = 1;
        }
    }

    public Attribute readAttribute(String name, int length, AttrContainer container) throws IOException {
        if (name == "SourceFile" && container instanceof ClassType) {
            return new SourceFileAttr(this.readUnsignedShort(), (ClassType)container);
        }
        if (name == "Code" && container instanceof Method) {
            CodeAttr code = new CodeAttr((Method)container);
            code.setMaxStack(this.readUnsignedShort());
            code.setMaxLocals(this.readUnsignedShort());
            int code_len = this.readInt();
            byte[] insns = new byte[code_len];
            this.readFully(insns);
            code.setCode(insns);
            int exception_table_length = this.readUnsignedShort();
            for (int i = 0; i < exception_table_length; ++i) {
                int start_pc = this.readUnsignedShort();
                int end_pc = this.readUnsignedShort();
                int handler_pc = this.readUnsignedShort();
                int catch_type = this.readUnsignedShort();
                code.addHandler(start_pc, end_pc, handler_pc, catch_type);
            }
            this.readAttributes(code);
            return code;
        }
        if (name == "LineNumberTable" && container instanceof CodeAttr) {
            int count = 2 * this.readUnsignedShort();
            short[] numbers = new short[count];
            for (int i = 0; i < count; ++i) {
                numbers[i] = this.readShort();
            }
            return new LineNumbersAttr(numbers, (CodeAttr)container);
        }
        if (name == "LocalVariableTable" && container instanceof CodeAttr) {
            LocalVarsAttr attr = new LocalVarsAttr((CodeAttr)container);
            Method method = attr.getMethod();
            if (attr.parameter_scope == null) {
                attr.parameter_scope = method.pushScope();
            }
            Scope scope = attr.parameter_scope;
            ConstantPool constants = method.getConstants();
            int count = this.readUnsignedShort();
            for (int i = 0; i < count; ++i) {
                Variable var = new Variable();
                scope.addVariable(var);
                var.start_pc = this.readUnsignedShort();
                var.end_pc = var.start_pc + this.readUnsignedShort();
                var.setName(this.readUnsignedShort(), constants);
                var.setSignature(this.readUnsignedShort(), constants);
                var.offset = this.readUnsignedShort();
            }
            return attr;
        }
        if (name == "ConstantValue" && container instanceof Field) {
            return new ConstantValueAttr(this.readUnsignedShort());
        }
        if (name == "InnerClasses" && container instanceof ClassType) {
            int count = 4 * this.readUnsignedShort();
            short[] data = new short[count];
            for (int i = 0; i < count; ++i) {
                data[i] = this.readShort();
            }
            return new InnerClassesAttr(data, (ClassType)container);
        }
        if (name == "Exceptions" && container instanceof Method) {
            Method meth = (Method)container;
            int count = this.readUnsignedShort();
            short[] exn_indices = new short[count];
            for (int i = 0; i < count; ++i) {
                exn_indices[i] = this.readShort();
            }
            meth.setExceptions(exn_indices);
            return meth.getExceptionAttr();
        }
        byte[] data = new byte[length];
        this.readFully(data, 0, length);
        return new MiscAttr(name, data);
    }

    public void readFields() throws IOException {
        if ((this.ctype.flags & 1) != 0) {
            return;
        }
        this.ctype.flags |= 1;
        int nFields = this.readUnsignedShort();
        ConstantPool constants = this.ctype.constants;
        for (int i = 0; i < nFields; ++i) {
            int flags = this.readUnsignedShort();
            int nameIndex = this.readUnsignedShort();
            int descriptorIndex = this.readUnsignedShort();
            Field fld = this.ctype.addField();
            fld.setName(nameIndex, constants);
            fld.setSignature(descriptorIndex, constants);
            fld.flags = flags;
            this.readAttributes(fld);
        }
    }

    public void readMethods() throws IOException {
        if ((this.ctype.flags & 2) != 0) {
            return;
        }
        this.ctype.flags |= 2;
        int nMethods = this.readUnsignedShort();
        ConstantPool constants = this.ctype.constants;
        for (int i = 0; i < nMethods; ++i) {
            int flags = this.readUnsignedShort();
            int nameIndex = this.readUnsignedShort();
            int descriptorIndex = this.readUnsignedShort();
            Method meth = this.ctype.addMethod(null, flags);
            meth.setName(nameIndex);
            meth.setSignature(descriptorIndex);
            this.readAttributes(meth);
        }
    }
}

