/*
 * Decompiled with CFR 0.152.
 */
package gnu.expr;

import gnu.bytecode.ClassType;
import gnu.bytecode.CodeAttr;
import gnu.bytecode.Label;
import gnu.bytecode.Method;
import gnu.bytecode.Type;
import gnu.expr.Compilation;
import gnu.expr.LambdaExp;
import gnu.expr.StackTarget;
import gnu.expr.Target;

public class CheckedTarget
extends StackTarget {
    LambdaExp proc;
    String procname;
    int argno;
    static ClassType typeClassCastException;
    static ClassType typeWrongType;
    static Method makeWrongTypeStringMethod;
    static Method makeWrongTypeProcMethod;

    public CheckedTarget(Type type, LambdaExp proc, int argno) {
        super(type);
        this.proc = proc;
        this.procname = proc.getName();
        this.argno = argno;
    }

    public CheckedTarget(Type type, String procname, int argno) {
        super(type);
        this.procname = procname;
        this.argno = argno;
    }

    public static Target getInstance(Type type, String procname, int argno) {
        return type == Type.pointer_type ? Target.pushObject : new CheckedTarget(type, procname, argno);
    }

    public static Target getInstance(Type type, LambdaExp proc, int argno) {
        return type == Type.pointer_type ? Target.pushObject : new CheckedTarget(type, proc, argno);
    }

    private static void initWrongType() {
        if (typeClassCastException == null) {
            typeClassCastException = ClassType.make("java.lang.ClassCastException");
        }
        if (typeWrongType == null) {
            typeWrongType = ClassType.make("gnu.mapping.WrongType");
            Type[] args = new Type[]{typeClassCastException, Compilation.javaStringType, Type.int_type};
            makeWrongTypeStringMethod = typeWrongType.addMethod("make", args, typeWrongType, 9);
            args = new Type[]{typeClassCastException, Compilation.typeProcedure, Type.int_type};
            makeWrongTypeProcMethod = typeWrongType.addMethod("make", args, typeWrongType, 9);
        }
    }

    public void compileFromStack(Compilation comp, Type stackType) {
        if (!this.compileFromStack0(comp, stackType)) {
            CheckedTarget.emitCheckedCoerce(comp, this.proc, this.procname, this.argno, this.type);
        }
    }

    public static void emitCheckedCoerce(Compilation comp, String procname, int argno, Type type) {
        CheckedTarget.emitCheckedCoerce(comp, null, procname, argno, type);
    }

    public static void emitCheckedCoerce(Compilation comp, LambdaExp proc, int argno, Type type) {
        CheckedTarget.emitCheckedCoerce(comp, proc, proc.getName(), argno, type);
    }

    static void emitCheckedCoerce(Compilation comp, LambdaExp proc, String procname, int argno, Type type) {
        int line;
        CodeAttr code = comp.getCode();
        boolean isInTry = code.isInTry();
        CheckedTarget.initWrongType();
        int startPC = code.getPC();
        type.emitCoerceFromObject(code);
        int endPC = code.getPC();
        if (endPC == startPC) {
            return;
        }
        if (type == Type.tostring_type) {
            return;
        }
        Label endLabel = null;
        if (isInTry) {
            endLabel = new Label(code);
            code.emitGoto(endLabel);
            endPC = code.getPC();
        }
        code.addHandler(startPC, endPC, isInTry ? endPC : -1, typeClassCastException, code.getConstants());
        if (!isInTry) {
            code.beginFragment(true);
        }
        code.pushType(typeClassCastException);
        boolean thisIsProc = false;
        if (proc != null && proc.isClassGenerated() && !comp.method.getStaticFlag() && comp.method.getDeclaringClass() == proc.getCompiledClassType(comp)) {
            thisIsProc = true;
        }
        if ((line = comp.position >> 12) > 0) {
            code.putLineNumber(comp.filename, line);
        }
        if (thisIsProc) {
            code.emitPushThis();
        } else {
            code.emitPushString(procname == null ? "lambda" : procname);
        }
        code.emitPushInt(argno);
        code.emitInvokeStatic(thisIsProc ? makeWrongTypeProcMethod : makeWrongTypeStringMethod);
        code.emitThrow();
        if (isInTry) {
            endLabel.define(code);
        } else {
            code.endFragment();
        }
    }
}

