/*
 * Decompiled with CFR 0.152.
 */
package gnu.bytecode;

import gnu.bytecode.Attribute;
import gnu.bytecode.ClassType;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;

class SourceMap
extends Attribute {
    private StringBuffer buffer;
    private StringBuffer lines = new StringBuffer("*L\n");
    private static final String trailer = "*E\n";
    private String currentFile = null;
    private int lastFileNumber = 0;
    private int firstLine = -1;
    private int lastLine = -1;
    private int outputBase = 1;
    private Map fileMap;

    SourceMap(ClassType classfile) {
        super("SourceDebugExtension");
        this.buffer = new StringBuffer("SMAP\n");
        this.buffer.append(classfile.getName()).append('\n');
        this.buffer.append("Default\n*S Default\n*F\n");
        this.fileMap = new HashMap();
    }

    public int getLength() {
        return this.getBytes().length;
    }

    private byte[] getBytes() {
        this.writeCurrent();
        this.currentFile = null;
        try {
            String value = this.buffer.toString() + this.lines.toString() + trailer;
            return value.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new Error(e.toString());
        }
    }

    public void write(DataOutputStream out) throws IOException {
        byte[] bytes = this.getBytes();
        out.write(bytes, 0, bytes.length);
    }

    int translate(String file, int line) {
        if (file == null) {
            return -1;
        }
        if (this.buffer.length() + this.lines.length() > 65000) {
            return -1;
        }
        if (!file.equals(this.currentFile) || line < this.firstLine) {
            this.writeCurrent();
            this.currentFile = file;
            this.firstLine = line;
        }
        this.lastLine = line;
        return this.outputBase + line - this.firstLine;
    }

    private void writeCurrent() {
        if (this.currentFile != null) {
            int fileNumber = this.writeFile(this.currentFile);
            int len = this.lastLine - this.firstLine + 1;
            this.lines.append("" + this.firstLine + '#' + fileNumber + ',' + len + ':' + this.outputBase).append('\n');
            this.outputBase += len;
        }
    }

    private int writeFile(String file) {
        Integer fileNumber = (Integer)this.fileMap.get(file);
        if (fileNumber == null) {
            ++this.lastFileNumber;
            fileNumber = new Integer(this.lastFileNumber);
            this.fileMap.put(file, fileNumber);
            this.buffer.append(this.lastFileNumber).append(' ').append(file).append('\n');
        }
        return fileNumber;
    }
}

