///////////////////////////////////////////////////////////////////////////
// mathex 0.2 (beta) - Copyright (C) 2000-2003, by Sadao Massago         //
// file: tabletest.cpp (function table making)                           //
// requires: mathex.h, mathex.cpp                                        //
// project web page: http://sourceforge.net/projects/sscilib/            //
// ----------------------------------------------------------------------//
// The mathex library and related files is licenced under the term of    //
// GNU LGPL (Lesser General Public License) version 2.1 or latter        //
// with exceptions that allow for static linking.                        //
// See license.txt for detail.                                           //
// For GNU LGPL, see lesser.txt.                                         //
// For information over GNU or GNU compatible license, visit the site    //
// http://www.gnu.org.                                                   //
///////////////////////////////////////////////////////////////////////////

#include <iostream>
#include <iomanip>
#include <string>

// #define _DEBUG_

#include "mathex.h"

using namespace std;

int main()
{
   // for variable sharing/setting example
      double x, y;  // x, y are used to table example too
      string s;
   // for table example
      int i, m;
      double a, b, h;
      smlib::mathex expr;
      bool status;
     
   // sharing with internal variables ...
   // table making example
      cout << "function table example\n";
      // expr.delvar();
   // sharing with internal variables ... 
      if(!expr.addvar("x", &x)) {
         cout << "Error adding internal variable x as name \"x\"n";
         return 1;
      }
      do {
      
         cout << "Enter expression of x: ";
      
         do { 
			   s.erase();
            getline(cin, s); // getline delete '\n'character?
         } while(s.empty());
      
         cout << "now parsing the expression " << s << endl;
         try {
            expr.expression(s); // setting expression string
            expr.parse(); // parse
            status = true; // parse sucessfull
         }
             catch(smlib::mathex::error e) { // mathex exception
               status = false; // parse failure
               cout << e.what() << endl; // erroer message
					// show expression and error position
               cout << s << endl;
               cout << setw(expr.stopposition()) << "^" << endl;
            }
             catch(exception e) { // unknow exception
				   status = false; // parse failure
               cout << e.what() << endl; // erroer message
            }
      } while(!status);
   
	   // get the interval
      cout << "a= "; cin >> a;
      cout << "b= "; cin >> b;
      cout << "m= "; cin >> m;
      // calculate h
      h = (b-a)/m;
      x = a;
      cout << "x        y\n";
      for(i=0; i<=m; i++) {
         try {
            y = expr.eval();
         }
             catch(smlib::mathex::error e) { // mathex exception
               cout << e.what() << endl;
               y = 0;
            }	 
             catch(exception e) { // unknow exception
               cout << e.what() << endl;
               y = 0;
            }	 
         cout << x << "    " << y << endl;
         x = x + h;
      } // for
      
      return 0;
   } // main()

// end of tabletest.cpp
