/*
 * Decompiled with CFR 0.152.
 */
package net.sf.log4jdbc;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.StringTokenizer;
import net.sf.log4jdbc.ConnectionSpy;
import net.sf.log4jdbc.RdbmsSpecifics;
import net.sf.log4jdbc.ResultSetSpy;
import net.sf.log4jdbc.Spy;
import net.sf.log4jdbc.SpyLogDelegator;
import net.sf.log4jdbc.SpyLogFactory;
import net.sf.log4jdbc.StatementSpy;

public class PreparedStatementSpy
extends StatementSpy
implements PreparedStatement {
    private final SpyLogDelegator log;
    protected final List argTrace = new ArrayList();
    private static final boolean showTypeHelp = false;
    private String sql;
    protected PreparedStatement realPreparedStatement;
    protected RdbmsSpecifics rdbmsSpecifics;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void argTraceSet(int i, String typeHelper, Object arg) {
        --i;
        List list = this.argTrace;
        synchronized (list) {
            while (i >= this.argTrace.size()) {
                this.argTrace.add(this.argTrace.size(), null);
            }
            typeHelper = "";
            if (arg != null) {
                this.argTrace.set(i, typeHelper + arg.toString());
            } else {
                this.argTrace.set(i, typeHelper + "null");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String dumpedSql() {
        StringBuffer dumpSql = new StringBuffer();
        int lastPos = 0;
        int Qpos = this.sql.indexOf(63, lastPos);
        int argIdx = 0;
        while (Qpos != -1) {
            String arg;
            List list = this.argTrace;
            synchronized (list) {
                try {
                    arg = (String)this.argTrace.get(argIdx);
                }
                catch (IndexOutOfBoundsException e) {
                    arg = "?";
                }
            }
            if (arg == null) {
                arg = "?";
            }
            ++argIdx;
            dumpSql.append(this.sql.substring(lastPos, Qpos));
            lastPos = Qpos + 1;
            Qpos = this.sql.indexOf(63, lastPos);
            dumpSql.append(arg);
        }
        if (lastPos < this.sql.length()) {
            dumpSql.append(this.sql.substring(lastPos, this.sql.length()));
        }
        StringBuffer output = new StringBuffer();
        StringTokenizer st = new StringTokenizer(dumpSql.toString());
        int linelength = 0;
        while (st.hasMoreElements()) {
            String token = (String)st.nextElement();
            output.append(token);
            linelength += token.length();
            output.append(" ");
            if (++linelength <= 90) continue;
            output.append("\n");
            linelength = 0;
        }
        return output.toString();
    }

    @Override
    protected void reportAllReturns(String methodCall, String msg) {
        this.log.methodReturned(this, methodCall, msg);
    }

    public PreparedStatementSpy(String sql, ConnectionSpy connectionSpy, PreparedStatement realPreparedStatement) {
        super(connectionSpy, realPreparedStatement);
        this.sql = sql;
        this.realPreparedStatement = realPreparedStatement;
        this.log = SpyLogFactory.getSpyLogDelegator();
        this.rdbmsSpecifics = connectionSpy.getRdbmsSpecifics();
    }

    @Override
    public String getClassType() {
        return "PreparedStatement";
    }

    @Override
    public void setTime(int parameterIndex, Time x) throws SQLException {
        String methodCall = "setTime(" + parameterIndex + ", " + x + ")";
        this.argTraceSet(parameterIndex, "(Time)", x);
        try {
            this.realPreparedStatement.setTime(parameterIndex, x);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    @Override
    public void setTime(int parameterIndex, Time x, Calendar cal) throws SQLException {
        String methodCall = "setTime(" + parameterIndex + ", " + x + ", " + cal + ")";
        this.argTraceSet(parameterIndex, "(Time)", x);
        try {
            this.realPreparedStatement.setTime(parameterIndex, x, cal);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader, int length) throws SQLException {
        String methodCall = "setCharacterStream(" + parameterIndex + ", " + reader + ", " + length + ")";
        this.argTraceSet(parameterIndex, "(Reader)", "<Reader of length " + length + ">");
        try {
            this.realPreparedStatement.setCharacterStream(parameterIndex, reader, length);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    @Override
    public void setNull(int parameterIndex, int sqlType) throws SQLException {
        String methodCall = "setNull(" + parameterIndex + ", " + sqlType + ")";
        this.argTraceSet(parameterIndex, null, "null");
        try {
            this.realPreparedStatement.setNull(parameterIndex, sqlType);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    @Override
    public void setNull(int paramIndex, int sqlType, String typeName) throws SQLException {
        String methodCall = "setNull(" + paramIndex + ", " + sqlType + ", " + typeName + ")";
        this.argTraceSet(paramIndex, null, "null");
        try {
            this.realPreparedStatement.setNull(paramIndex, sqlType, typeName);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    @Override
    public void setRef(int i, Ref x) throws SQLException {
        String methodCall = "setRef(" + i + ", " + x + ")";
        this.argTraceSet(i, "(Ref)", x);
        try {
            this.realPreparedStatement.setRef(i, x);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    @Override
    public void setBoolean(int parameterIndex, boolean x) throws SQLException {
        String methodCall = "setBoolean(" + parameterIndex + ", " + x + ")";
        this.argTraceSet(parameterIndex, "(boolean)", Boolean.toString(x));
        try {
            this.realPreparedStatement.setBoolean(parameterIndex, x);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    @Override
    public void setBlob(int i, Blob x) throws SQLException {
        String methodCall = "setBlob(" + i + ", " + x + ")";
        this.argTraceSet(i, "(Blob)", "<Blob of size " + x.length() + ">");
        try {
            this.realPreparedStatement.setBlob(i, x);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    @Override
    public void setClob(int i, Clob x) throws SQLException {
        String methodCall = "setClob(" + i + ", " + x + ")";
        this.argTraceSet(i, "(Clob)", "<Clob of size " + x.length() + ">");
        try {
            this.realPreparedStatement.setClob(i, x);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    @Override
    public void setArray(int i, Array x) throws SQLException {
        String methodCall = "setArray(" + i + ", " + x + ")";
        this.argTraceSet(i, "(Array)", "<Array>");
        try {
            this.realPreparedStatement.setArray(i, x);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    @Override
    public void setByte(int parameterIndex, byte x) throws SQLException {
        String methodCall = "setByte(" + parameterIndex + ", " + x + ")";
        this.argTraceSet(parameterIndex, "(byte)", Byte.toString(x));
        try {
            this.realPreparedStatement.setByte(parameterIndex, x);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    @Override
    public void setUnicodeStream(int parameterIndex, InputStream x, int length) throws SQLException {
        String methodCall = "setUnicodeStream(" + parameterIndex + ", " + x + ", " + length + ")";
        this.argTraceSet(parameterIndex, "(Unicode InputStream)", "<Unicode InputStream of length " + length + ">");
        try {
            this.realPreparedStatement.setUnicodeStream(parameterIndex, x, length);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    @Override
    public void setShort(int parameterIndex, short x) throws SQLException {
        String methodCall = "setShort(" + parameterIndex + ", " + x + ")";
        this.argTraceSet(parameterIndex, "(short)", Short.toString(x));
        try {
            this.realPreparedStatement.setShort(parameterIndex, x);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    @Override
    public boolean execute() throws SQLException {
        String methodCall = "execute()";
        String dumpedSql = this.dumpedSql();
        this.reportSql(dumpedSql, methodCall);
        long tstart = System.currentTimeMillis();
        try {
            boolean result = this.realPreparedStatement.execute();
            this.reportSqlTiming(System.currentTimeMillis() - tstart, dumpedSql, methodCall);
            return this.reportReturn(methodCall, result);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s, dumpedSql, System.currentTimeMillis() - tstart);
            throw s;
        }
    }

    @Override
    public void setInt(int parameterIndex, int x) throws SQLException {
        String methodCall = "setInt(" + parameterIndex + ", " + x + ")";
        this.argTraceSet(parameterIndex, "(int)", Integer.toString(x));
        try {
            this.realPreparedStatement.setInt(parameterIndex, x);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    @Override
    public void setLong(int parameterIndex, long x) throws SQLException {
        String methodCall = "setLong(" + parameterIndex + ", " + x + ")";
        this.argTraceSet(parameterIndex, "(long)", Long.toString(x));
        try {
            this.realPreparedStatement.setLong(parameterIndex, x);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    @Override
    public void setFloat(int parameterIndex, float x) throws SQLException {
        String methodCall = "setFloat(" + parameterIndex + ", " + x + ")";
        this.argTraceSet(parameterIndex, "(float)", Float.toString(x));
        try {
            this.realPreparedStatement.setFloat(parameterIndex, x);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    @Override
    public void setDouble(int parameterIndex, double x) throws SQLException {
        String methodCall = "setDouble(" + parameterIndex + ", " + x + ")";
        this.argTraceSet(parameterIndex, "(double)", Double.toString(x));
        try {
            this.realPreparedStatement.setDouble(parameterIndex, x);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    @Override
    public void setBigDecimal(int parameterIndex, BigDecimal x) throws SQLException {
        String methodCall = "setBigDecimal(" + parameterIndex + ", " + x + ")";
        this.argTraceSet(parameterIndex, "(BigDecimal)", x);
        try {
            this.realPreparedStatement.setBigDecimal(parameterIndex, x);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    @Override
    public void setURL(int parameterIndex, URL x) throws SQLException {
        String methodCall = "setURL(" + parameterIndex + ", " + x + ")";
        this.argTraceSet(parameterIndex, "(URL)", x);
        try {
            this.realPreparedStatement.setURL(parameterIndex, x);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    @Override
    public void setString(int parameterIndex, String x) throws SQLException {
        String methodCall = "setString(" + parameterIndex + ", \"" + x + "\")";
        this.argTraceSet(parameterIndex, "(String)", this.rdbmsSpecifics.formatParameterObject(x));
        try {
            this.realPreparedStatement.setString(parameterIndex, x);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    @Override
    public void setBytes(int parameterIndex, byte[] x) throws SQLException {
        String methodCall = "setBytes(" + parameterIndex + ", " + x + ")";
        this.argTraceSet(parameterIndex, "(byte[])", "<byte[]>");
        try {
            this.realPreparedStatement.setBytes(parameterIndex, x);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    @Override
    public void setDate(int parameterIndex, Date x) throws SQLException {
        String methodCall = "setDate(" + parameterIndex + ", " + x + ")";
        this.argTraceSet(parameterIndex, "(Date)", this.rdbmsSpecifics.formatParameterObject(x));
        try {
            this.realPreparedStatement.setDate(parameterIndex, x);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    @Override
    public ParameterMetaData getParameterMetaData() throws SQLException {
        String methodCall = "getParameterMetaData()";
        try {
            return (ParameterMetaData)this.reportReturn(methodCall, this.realPreparedStatement.getParameterMetaData());
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    @Override
    public void setRowId(int parameterIndex, RowId x) throws SQLException {
        String methodCall = "setRowId(" + parameterIndex + ", " + x + ")";
        this.argTraceSet(parameterIndex, "(RowId)", this.rdbmsSpecifics.formatParameterObject(x));
        try {
            this.realPreparedStatement.setRowId(parameterIndex, x);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    @Override
    public void setNString(int parameterIndex, String value) throws SQLException {
        String methodCall = "setNString(" + parameterIndex + ", " + value + ")";
        this.argTraceSet(parameterIndex, "(String)", this.rdbmsSpecifics.formatParameterObject(value));
        try {
            this.realPreparedStatement.setNString(parameterIndex, value);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader value, long length) throws SQLException {
        String methodCall = "setNCharacterStream(" + parameterIndex + ", " + value + ", " + length + ")";
        this.argTraceSet(parameterIndex, "(Reader)", "<Reader of length " + length + ">");
        try {
            this.realPreparedStatement.setNCharacterStream(parameterIndex, value, length);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    @Override
    public void setNClob(int parameterIndex, NClob value) throws SQLException {
        String methodCall = "setNClob(" + parameterIndex + ", " + value + ")";
        this.argTraceSet(parameterIndex, "(NClob)", "<NClob>");
        try {
            this.realPreparedStatement.setNClob(parameterIndex, value);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    @Override
    public void setClob(int parameterIndex, Reader reader, long length) throws SQLException {
        String methodCall = "setClob(" + parameterIndex + ", " + reader + ", " + length + ")";
        this.argTraceSet(parameterIndex, "(Reader)", "<Reader of length " + length + ">");
        try {
            this.realPreparedStatement.setClob(parameterIndex, reader, length);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream, long length) throws SQLException {
        String methodCall = "setBlob(" + parameterIndex + ", " + inputStream + ", " + length + ")";
        this.argTraceSet(parameterIndex, "(InputStream)", "<InputStream of length " + length + ">");
        try {
            this.realPreparedStatement.setBlob(parameterIndex, inputStream, length);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader, long length) throws SQLException {
        String methodCall = "setNClob(" + parameterIndex + ", " + reader + ", " + length + ")";
        this.argTraceSet(parameterIndex, "(Reader)", "<Reader of length " + length + ">");
        try {
            this.realPreparedStatement.setNClob(parameterIndex, reader, length);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    @Override
    public void setSQLXML(int parameterIndex, SQLXML xmlObject) throws SQLException {
        String methodCall = "setSQLXML(" + parameterIndex + ", " + xmlObject + ")";
        this.argTraceSet(parameterIndex, "(SQLXML)", this.rdbmsSpecifics.formatParameterObject(xmlObject));
        try {
            this.realPreparedStatement.setSQLXML(parameterIndex, xmlObject);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    @Override
    public void setDate(int parameterIndex, Date x, Calendar cal) throws SQLException {
        String methodCall = "setDate(" + parameterIndex + ", " + x + ", " + cal + ")";
        this.argTraceSet(parameterIndex, "(Date)", this.rdbmsSpecifics.formatParameterObject(x));
        try {
            this.realPreparedStatement.setDate(parameterIndex, x, cal);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    @Override
    public ResultSet executeQuery() throws SQLException {
        String methodCall = "executeQuery()";
        String dumpedSql = this.dumpedSql();
        this.reportSql(dumpedSql, methodCall);
        long tstart = System.currentTimeMillis();
        try {
            ResultSet r = this.realPreparedStatement.executeQuery();
            this.reportSqlTiming(System.currentTimeMillis() - tstart, dumpedSql, methodCall);
            ResultSetSpy rsp = new ResultSetSpy(this, r);
            return (ResultSet)this.reportReturn(methodCall, rsp);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s, dumpedSql, System.currentTimeMillis() - tstart);
            throw s;
        }
    }

    private String getTypeHelp(Object x) {
        if (x == null) {
            return "(null)";
        }
        return "(" + x.getClass().getName() + ")";
    }

    @Override
    public void setObject(int parameterIndex, Object x, int targetSqlType, int scale) throws SQLException {
        String methodCall = "setObject(" + parameterIndex + ", " + x + ", " + targetSqlType + ", " + scale + ")";
        this.argTraceSet(parameterIndex, this.getTypeHelp(x), this.rdbmsSpecifics.formatParameterObject(x));
        try {
            this.realPreparedStatement.setObject(parameterIndex, x, targetSqlType, scale);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x, long length) throws SQLException {
        String methodCall = "setAsciiStream(" + parameterIndex + ", " + x + ", " + length + ")";
        this.argTraceSet(parameterIndex, "(Ascii InputStream)", "<Ascii InputStream of length " + length + ">");
        try {
            this.realPreparedStatement.setAsciiStream(parameterIndex, x, length);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x, long length) throws SQLException {
        String methodCall = "setBinaryStream(" + parameterIndex + ", " + x + ", " + length + ")";
        this.argTraceSet(parameterIndex, "(Binary InputStream)", "<Binary InputStream of length " + length + ">");
        try {
            this.realPreparedStatement.setBinaryStream(parameterIndex, x, length);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader, long length) throws SQLException {
        String methodCall = "setCharacterStream(" + parameterIndex + ", " + reader + ", " + length + ")";
        this.argTraceSet(parameterIndex, "(Reader)", "<Reader of length " + length + ">");
        try {
            this.realPreparedStatement.setCharacterStream(parameterIndex, reader, length);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x) throws SQLException {
        String methodCall = "setAsciiStream(" + parameterIndex + ", " + x + ")";
        this.argTraceSet(parameterIndex, "(Ascii InputStream)", "<Ascii InputStream>");
        try {
            this.realPreparedStatement.setAsciiStream(parameterIndex, x);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x) throws SQLException {
        String methodCall = "setBinaryStream(" + parameterIndex + ", " + x + ")";
        this.argTraceSet(parameterIndex, "(Binary InputStream)", "<Binary InputStream>");
        try {
            this.realPreparedStatement.setBinaryStream(parameterIndex, x);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader) throws SQLException {
        String methodCall = "setCharacterStream(" + parameterIndex + ", " + reader + ")";
        this.argTraceSet(parameterIndex, "(Reader)", "<Reader>");
        try {
            this.realPreparedStatement.setCharacterStream(parameterIndex, reader);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader reader) throws SQLException {
        String methodCall = "setNCharacterStream(" + parameterIndex + ", " + reader + ")";
        this.argTraceSet(parameterIndex, "(Reader)", "<Reader>");
        try {
            this.realPreparedStatement.setNCharacterStream(parameterIndex, reader);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    @Override
    public void setClob(int parameterIndex, Reader reader) throws SQLException {
        String methodCall = "setClob(" + parameterIndex + ", " + reader + ")";
        this.argTraceSet(parameterIndex, "(Reader)", "<Reader>");
        try {
            this.realPreparedStatement.setClob(parameterIndex, reader);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream) throws SQLException {
        String methodCall = "setBlob(" + parameterIndex + ", " + inputStream + ")";
        this.argTraceSet(parameterIndex, "(InputStream)", "<InputStream>");
        try {
            this.realPreparedStatement.setBlob(parameterIndex, inputStream);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader) throws SQLException {
        String methodCall = "setNClob(" + parameterIndex + ", " + reader + ")";
        this.argTraceSet(parameterIndex, "(Reader)", "<Reader>");
        try {
            this.realPreparedStatement.setNClob(parameterIndex, reader);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    @Override
    public void setObject(int parameterIndex, Object x, int targetSqlType) throws SQLException {
        String methodCall = "setObject(" + parameterIndex + ", " + x + ", " + targetSqlType + ")";
        this.argTraceSet(parameterIndex, this.getTypeHelp(x), this.rdbmsSpecifics.formatParameterObject(x));
        try {
            this.realPreparedStatement.setObject(parameterIndex, x, targetSqlType);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    @Override
    public void setObject(int parameterIndex, Object x) throws SQLException {
        String methodCall = "setObject(" + parameterIndex + ", " + x + ")";
        this.argTraceSet(parameterIndex, this.getTypeHelp(x), this.rdbmsSpecifics.formatParameterObject(x));
        try {
            this.realPreparedStatement.setObject(parameterIndex, x);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x) throws SQLException {
        String methodCall = "setTimestamp(" + parameterIndex + ", " + x + ")";
        this.argTraceSet(parameterIndex, "(Date)", this.rdbmsSpecifics.formatParameterObject(x));
        try {
            this.realPreparedStatement.setTimestamp(parameterIndex, x);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x, Calendar cal) throws SQLException {
        String methodCall = "setTimestamp(" + parameterIndex + ", " + x + ", " + cal + ")";
        this.argTraceSet(parameterIndex, "(Timestamp)", this.rdbmsSpecifics.formatParameterObject(x));
        try {
            this.realPreparedStatement.setTimestamp(parameterIndex, x, cal);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    @Override
    public int executeUpdate() throws SQLException {
        String methodCall = "executeUpdate()";
        String dumpedSql = this.dumpedSql();
        this.reportSql(dumpedSql, methodCall);
        long tstart = System.currentTimeMillis();
        try {
            int result = this.realPreparedStatement.executeUpdate();
            this.reportSqlTiming(System.currentTimeMillis() - tstart, dumpedSql, methodCall);
            return this.reportReturn(methodCall, result);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s, dumpedSql, System.currentTimeMillis() - tstart);
            throw s;
        }
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x, int length) throws SQLException {
        String methodCall = "setAsciiStream(" + parameterIndex + ", " + x + ", " + length + ")";
        this.argTraceSet(parameterIndex, "(Ascii InputStream)", "<Ascii InputStream of length " + length + ">");
        try {
            this.realPreparedStatement.setAsciiStream(parameterIndex, x, length);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x, int length) throws SQLException {
        String methodCall = "setBinaryStream(" + parameterIndex + ", " + x + ", " + length + ")";
        this.argTraceSet(parameterIndex, "(Binary InputStream)", "<Binary InputStream of length " + length + ">");
        try {
            this.realPreparedStatement.setBinaryStream(parameterIndex, x, length);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearParameters() throws SQLException {
        String methodCall = "clearParameters()";
        List list = this.argTrace;
        synchronized (list) {
            this.argTrace.clear();
        }
        try {
            this.realPreparedStatement.clearParameters();
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        String methodCall = "getMetaData()";
        try {
            return (ResultSetMetaData)this.reportReturn(methodCall, this.realPreparedStatement.getMetaData());
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    @Override
    public void addBatch() throws SQLException {
        String methodCall = "addBatch()";
        this.currentBatch.add(this.dumpedSql());
        try {
            this.realPreparedStatement.addBatch();
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        String methodCall = "unwrap(" + (iface == null ? "null" : iface.getName()) + ")";
        try {
            return (T)this.reportReturn(methodCall, iface != null && (iface == PreparedStatement.class || iface == Statement.class || iface == Spy.class) ? this : this.realPreparedStatement.unwrap(iface));
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        String methodCall = "isWrapperFor(" + (iface == null ? "null" : iface.getName()) + ")";
        try {
            return this.reportReturn(methodCall, iface != null && (iface == PreparedStatement.class || iface == Statement.class || iface == Spy.class) || this.realPreparedStatement.isWrapperFor(iface));
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }
}

