/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen.intrinsics;

import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.codegen.AsmUtil;
import org.jetbrains.kotlin.codegen.BaseExpressionCodegenKt;
import org.jetbrains.kotlin.codegen.ExpressionCodegen;
import org.jetbrains.kotlin.codegen.StackValue;
import org.jetbrains.kotlin.codegen.inline.ReifiedTypeInliner;
import org.jetbrains.kotlin.codegen.intrinsics.IntrinsicPropertyGetter;
import org.jetbrains.kotlin.psi.KtClassLiteralExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.jvm.AsmTypes;
import org.jetbrains.kotlin.resolve.scopes.receivers.ExpressionReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.expressions.DoubleColonLHS;
import org.jetbrains.org.objectweb.asm.Type;
import org.jetbrains.org.objectweb.asm.commons.InstructionAdapter;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J0\u0010\u0004\u001a\u0004\u0018\u00010\u00052\f\u0010\u0006\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0005H\u0016\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/codegen/intrinsics/KClassJavaObjectTypeProperty;", "Lorg/jetbrains/kotlin/codegen/intrinsics/IntrinsicPropertyGetter;", "<init>", "()V", "generate", "Lorg/jetbrains/kotlin/codegen/StackValue;", "resolvedCall", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "codegen", "Lorg/jetbrains/kotlin/codegen/ExpressionCodegen;", "returnType", "Lorg/jetbrains/org/objectweb/asm/Type;", "receiver", "backend"})
public final class KClassJavaObjectTypeProperty
extends IntrinsicPropertyGetter {
    @Override
    @Nullable
    public StackValue generate(@Nullable ResolvedCall<?> resolvedCall2, @NotNull ExpressionCodegen codegen2, @NotNull Type returnType, @NotNull StackValue receiver) {
        Intrinsics.checkNotNullParameter(codegen2, "codegen");
        Intrinsics.checkNotNullParameter(returnType, "returnType");
        Intrinsics.checkNotNullParameter(receiver, "receiver");
        ResolvedCall<?> resolvedCall3 = resolvedCall2;
        Intrinsics.checkNotNull(resolvedCall3);
        ReceiverValue receiverValue = resolvedCall3.getExtensionReceiver();
        ExpressionReceiver expressionReceiver = receiverValue instanceof ExpressionReceiver ? (ExpressionReceiver)receiverValue : null;
        if (expressionReceiver == null) {
            return null;
        }
        ExpressionReceiver receiverValue2 = expressionReceiver;
        KtExpression ktExpression = receiverValue2.getExpression();
        KtClassLiteralExpression ktClassLiteralExpression = ktExpression instanceof KtClassLiteralExpression ? (KtClassLiteralExpression)ktExpression : null;
        if (ktClassLiteralExpression == null) {
            return null;
        }
        KtClassLiteralExpression classLiteralExpression = ktClassLiteralExpression;
        KtExpression ktExpression2 = classLiteralExpression.getReceiverExpression();
        if (ktExpression2 == null) {
            return null;
        }
        KtExpression receiverExpression = ktExpression2;
        DoubleColonLHS doubleColonLHS = (DoubleColonLHS)codegen2.getBindingContext().get(BindingContext.DOUBLE_COLON_LHS, receiverExpression);
        if (doubleColonLHS == null) {
            return null;
        }
        DoubleColonLHS lhs = doubleColonLHS;
        return StackValue.operation(returnType, arg_0 -> KClassJavaObjectTypeProperty.generate$lambda$1(lhs, codegen2, receiverExpression, arg_0));
    }

    private static final Unit generate$lambda$1(DoubleColonLHS $lhs, ExpressionCodegen $codegen, KtExpression $receiverExpression, InstructionAdapter iv) {
        if ($lhs instanceof DoubleColonLHS.Expression && !((DoubleColonLHS.Expression)$lhs).isObjectQualifier()) {
            StackValue receiverStackValue = $codegen.gen($receiverExpression);
            Type type2 = receiverStackValue.type;
            Intrinsics.checkNotNullExpressionValue(type2, "type");
            Type extensionReceiverType = type2;
            receiverStackValue.put(extensionReceiverType, iv);
            if (Intrinsics.areEqual(extensionReceiverType, Type.VOID_TYPE)) {
                iv.aconst(AsmTypes.UNIT_TYPE);
            } else if (AsmUtil.isPrimitive(extensionReceiverType) || AsmUtil.unboxPrimitiveTypeOrNull(extensionReceiverType) != null) {
                AsmUtil.pop(iv, extensionReceiverType);
                iv.aconst(AsmUtil.boxType(extensionReceiverType));
            } else {
                iv.invokevirtual("java/lang/Object", "getClass", "()Ljava/lang/Class;", false);
            }
        } else {
            if (TypeUtils.isTypeParameter($lhs.getType())) {
                boolean bl = TypeUtils.isReifiedTypeParameter($lhs.getType());
                if (_Assertions.ENABLED && !bl) {
                    boolean bl2 = false;
                    String string2 = "Non-reified type parameter under ::class should be rejected by type checker: " + $lhs.getType();
                    throw new AssertionError((Object)string2);
                }
                BaseExpressionCodegenKt.putReifiedOperationMarkerIfTypeIsReifiedParameter($codegen, $lhs.getType(), ReifiedTypeInliner.OperationKind.JAVA_CLASS);
            }
            iv.aconst(AsmUtil.boxType($codegen.mapTypeAsDeclaration($lhs.getType())));
        }
        return Unit.INSTANCE;
    }
}

