/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.resolve.transformers;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.FirLanguageSettingsComponentKt;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.UtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirFile;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.declarations.FirResolvePhase;
import org.jetbrains.kotlin.fir.declarations.FirTypeAlias;
import org.jetbrains.kotlin.fir.declarations.SealedClassInheritorsKt;
import org.jetbrains.kotlin.fir.declarations.utils.FirDeclarationUtilKt;
import org.jetbrains.kotlin.fir.expressions.FirStatement;
import org.jetbrains.kotlin.fir.resolve.LookupTagUtilsKt;
import org.jetbrains.kotlin.fir.resolve.ScopeSession;
import org.jetbrains.kotlin.fir.resolve.providers.FirSymbolProvider;
import org.jetbrains.kotlin.fir.resolve.providers.FirSymbolProviderKt;
import org.jetbrains.kotlin.fir.resolve.transformers.FirGlobalResolveProcessor;
import org.jetbrains.kotlin.fir.symbols.ConeClassifierLookupTag;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.FirLazyDeclarationResolverKt;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassifierSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirTypeAliasSymbol;
import org.jetbrains.kotlin.fir.types.ConeLookupTagBasedType;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.TypeUtilsKt;
import org.jetbrains.kotlin.fir.visitors.FirDefaultVisitor;
import org.jetbrains.kotlin.fir.visitors.FirTransformer;
import org.jetbrains.kotlin.fir.visitors.FirTransformerUtilKt;
import org.jetbrains.kotlin.name.ClassId;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0002\r\u000eB\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0016\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0016\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/transformers/FirSealedClassInheritorsProcessor;", "Lorg/jetbrains/kotlin/fir/resolve/transformers/FirGlobalResolveProcessor;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "scopeSession", "Lorg/jetbrains/kotlin/fir/resolve/ScopeSession;", "<init>", "(Lorg/jetbrains/kotlin/fir/FirSession;Lorg/jetbrains/kotlin/fir/resolve/ScopeSession;)V", "process", "", "files", "", "Lorg/jetbrains/kotlin/fir/declarations/FirFile;", "InheritorsCollector", "InheritorsTransformer", "resolve"})
@SourceDebugExtension(value={"SMAP\nFirSealedClassInheritorsProcessor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirSealedClassInheritorsProcessor.kt\norg/jetbrains/kotlin/fir/resolve/transformers/FirSealedClassInheritorsProcessor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Utils.kt\norg/jetbrains/kotlin/fir/UtilsKt\n*L\n1#1,138:1\n1863#2:139\n1864#2:144\n1863#2:145\n1864#2:150\n160#3,4:140\n160#3,4:146\n*S KotlinDebug\n*F\n+ 1 FirSealedClassInheritorsProcessor.kt\norg/jetbrains/kotlin/fir/resolve/transformers/FirSealedClassInheritorsProcessor\n*L\n44#1:139\n44#1:144\n49#1:145\n49#1:150\n45#1:140,4\n50#1:146,4\n*E\n"})
public final class FirSealedClassInheritorsProcessor
extends FirGlobalResolveProcessor {
    public FirSealedClassInheritorsProcessor(@NotNull FirSession session2, @NotNull ScopeSession scopeSession) {
        Intrinsics.checkNotNullParameter(session2, "session");
        Intrinsics.checkNotNullParameter(scopeSession, "scopeSession");
        super(session2, scopeSession, FirResolvePhase.SEALED_CLASS_INHERITORS);
    }

    @Override
    public void process(@NotNull Collection<? extends FirFile> files2) {
        Unit unit;
        boolean $i$f$withFileAnalysisExceptionWrapping;
        FirFile it;
        Intrinsics.checkNotNullParameter(files2, "files");
        Map sealedClassInheritorsMap = new LinkedHashMap();
        InheritorsCollector inheritorsCollector = new InheritorsCollector(this.getSession());
        Iterable $this$forEach$iv = files2;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (FirFile)element$iv;
            boolean bl = false;
            $i$f$withFileAnalysisExceptionWrapping = false;
            try {
                boolean bl2 = false;
                it.accept(inheritorsCollector, sealedClassInheritorsMap);
                unit = Unit.INSTANCE;
            }
            catch (Throwable throwable$iv) {
                UtilsKt.getExceptionHandler(it.getModuleData().getSession()).handleExceptionOnFileAnalysis(it, throwable$iv);
                throw null;
            }
        }
        $this$forEach$iv = files2;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (FirFile)element$iv;
            boolean bl = false;
            $i$f$withFileAnalysisExceptionWrapping = false;
            try {
                boolean bl3 = false;
                FirTransformerUtilKt.transformSingle((FirElement)it, new InheritorsTransformer(sealedClassInheritorsMap), null);
                unit = Unit.INSTANCE;
            }
            catch (Throwable throwable$iv) {
                UtilsKt.getExceptionHandler(it.getModuleData().getSession()).handleExceptionOnFileAnalysis(it, throwable$iv);
                throw null;
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002 \u0012\u0004\u0012\u00020\u0002\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\u00030\u0001B\u000f\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ*\u0010\r\u001a\u00020\u00022\u0006\u0010\u000e\u001a\u00020\u000f2\u0018\u0010\u0010\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\u0003H\u0016J*\u0010\u0011\u001a\u00020\u00022\u0006\u0010\u0012\u001a\u00020\u00132\u0018\u0010\u0010\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\u0003H\u0016J*\u0010\u0014\u001a\u00020\u00022\u0006\u0010\u0015\u001a\u00020\u00042\u0018\u0010\u0010\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\u0003H\u0016J*\u0010\u0016\u001a\u00020\u00022\u0006\u0010\u0017\u001a\u00020\u00182\u0018\u0010\u0010\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\u0003H\u0016J\u001e\u0010\u0019\u001a\u00020\u00022\u0006\u0010\u001a\u001a\u00020\u00062\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0002J\u001a\u0010\u001c\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0002R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006!"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/transformers/FirSealedClassInheritorsProcessor$InheritorsCollector;", "Lorg/jetbrains/kotlin/fir/visitors/FirDefaultVisitor;", "", "", "Lorg/jetbrains/kotlin/fir/declarations/FirRegularClass;", "", "Lorg/jetbrains/kotlin/name/ClassId;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "<init>", "(Lorg/jetbrains/kotlin/fir/FirSession;)V", "getSession", "()Lorg/jetbrains/kotlin/fir/FirSession;", "visitElement", "element", "Lorg/jetbrains/kotlin/fir/FirElement;", "data", "visitFile", "file", "Lorg/jetbrains/kotlin/fir/declarations/FirFile;", "visitRegularClass", "regularClass", "visitTypeAlias", "typeAlias", "Lorg/jetbrains/kotlin/fir/declarations/FirTypeAlias;", "collectInheritorsOfCorrespondingExpectSealedClass", "expectClassId", "inheritors", "extractClassFromTypeRef", "symbolProvider", "Lorg/jetbrains/kotlin/fir/resolve/providers/FirSymbolProvider;", "typeRef", "Lorg/jetbrains/kotlin/fir/types/FirTypeRef;", "resolve"})
    @SourceDebugExtension(value={"SMAP\nFirSealedClassInheritorsProcessor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirSealedClassInheritorsProcessor.kt\norg/jetbrains/kotlin/fir/resolve/transformers/FirSealedClassInheritorsProcessor$InheritorsCollector\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 FirStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirStatusUtilsKt\n+ 4 addToStdlib.kt\norg/jetbrains/kotlin/utils/addToStdlib/AddToStdlibKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,138:1\n1863#2,2:139\n1863#2,2:141\n11#3:143\n11#3:146\n36#3:147\n11#3:148\n37#3:149\n62#3:150\n226#4:144\n1#5:145\n*S KotlinDebug\n*F\n+ 1 FirSealedClassInheritorsProcessor.kt\norg/jetbrains/kotlin/fir/resolve/transformers/FirSealedClassInheritorsProcessor$InheritorsCollector\n*L\n60#1:139,2\n64#1:141,2\n66#1:143\n73#1:146\n86#1:147\n88#1:148\n95#1:149\n95#1:150\n66#1:144\n*E\n"})
    public static final class InheritorsCollector
    extends FirDefaultVisitor<Unit, Map<FirRegularClass, Set<ClassId>>> {
        @NotNull
        private final FirSession session;

        public InheritorsCollector(@NotNull FirSession session2) {
            Intrinsics.checkNotNullParameter(session2, "session");
            this.session = session2;
        }

        @NotNull
        public final FirSession getSession() {
            return this.session;
        }

        @Override
        public void visitElement(@NotNull FirElement element, @NotNull Map<FirRegularClass, Set<ClassId>> data) {
            Intrinsics.checkNotNullParameter(element, "element");
            Intrinsics.checkNotNullParameter(data, "data");
        }

        @Override
        public void visitFile(@NotNull FirFile file2, @NotNull Map<FirRegularClass, Set<ClassId>> data) {
            Intrinsics.checkNotNullParameter(file2, "file");
            Intrinsics.checkNotNullParameter(data, "data");
            Iterable $this$forEach$iv = file2.getDeclarations();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                FirDeclaration it = (FirDeclaration)element$iv;
                boolean bl = false;
                it.accept(this, data);
            }
        }

        @Override
        public void visitRegularClass(@NotNull FirRegularClass regularClass, @NotNull Map<FirRegularClass, Set<ClassId>> data) {
            Set set;
            Intrinsics.checkNotNullParameter(regularClass, "regularClass");
            Intrinsics.checkNotNullParameter(data, "data");
            Iterable $this$forEach$iv = regularClass.getDeclarations();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                FirDeclaration it = (FirDeclaration)element$iv;
                boolean bl = false;
                it.accept(this, data);
            }
            FirMemberDeclaration $this$modality$iv = regularClass;
            boolean $i$f$getModality = false;
            boolean condition$iv = $this$modality$iv.getStatus().getModality() == Modality.SEALED;
            boolean $i$f$runIf = false;
            if (condition$iv) {
                boolean bl = false;
                set = data.computeIfAbsent(regularClass, arg_0 -> InheritorsCollector.visitRegularClass$lambda$4$lambda$3(InheritorsCollector::visitRegularClass$lambda$4$lambda$2, arg_0));
            } else {
                set = null;
            }
            Set sealedInheritors = set;
            FirSymbolProvider symbolProvider = FirSymbolProviderKt.getSymbolProvider(this.session);
            for (FirTypeRef typeRef : regularClass.getSuperTypeRefs()) {
                Set inheritors;
                FirRegularClass parent2;
                Modality modality;
                FirRegularClass firRegularClass;
                FirRegularClass it = firRegularClass = this.extractClassFromTypeRef(symbolProvider, typeRef);
                boolean bl = false;
                FirRegularClass firRegularClass2 = it;
                if (firRegularClass2 != null) {
                    FirMemberDeclaration $this$modality$iv2 = firRegularClass2;
                    boolean $i$f$getModality2 = false;
                    modality = $this$modality$iv2.getStatus().getModality();
                } else {
                    modality = null;
                }
                FirRegularClass firRegularClass3 = modality == Modality.SEALED ? firRegularClass : null;
                if (firRegularClass3 == null || !Intrinsics.areEqual(FirDeclarationUtilKt.getClassId(parent2 = firRegularClass3).getPackageFqName(), FirDeclarationUtilKt.getClassId(regularClass).getPackageFqName())) continue;
                Intrinsics.checkNotNullExpressionValue(data.computeIfAbsent(parent2, arg_0 -> InheritorsCollector.visitRegularClass$lambda$7(InheritorsCollector::visitRegularClass$lambda$6, arg_0)), "computeIfAbsent(...)");
                ((Collection)inheritors).add(regularClass.getSymbol().getClassId());
            }
            if (sealedInheritors != null) {
                this.collectInheritorsOfCorrespondingExpectSealedClass(FirDeclarationUtilKt.getClassId(regularClass), sealedInheritors);
            }
        }

        @Override
        public void visitTypeAlias(@NotNull FirTypeAlias typeAlias, @NotNull Map<FirRegularClass, Set<ClassId>> data) {
            Intrinsics.checkNotNullParameter(typeAlias, "typeAlias");
            Intrinsics.checkNotNullParameter(data, "data");
            FirMemberDeclaration $this$isActual$iv = typeAlias;
            boolean $i$f$isActual = false;
            if (!$this$isActual$iv.getStatus().isActual()) {
                return;
            }
            Object object = TypeUtilsKt.toRegularClassSymbol(FirTypeUtilsKt.getConeType(typeAlias.getExpandedTypeRef()), this.session);
            if (object == null || (object = (FirRegularClass)((FirBasedSymbol)object).getFir()) == null) {
                return;
            }
            Object expansionClass = object;
            FirMemberDeclaration $this$modality$iv = (FirMemberDeclaration)expansionClass;
            boolean $i$f$getModality = false;
            if ($this$modality$iv.getStatus().getModality() != Modality.SEALED) {
                return;
            }
            ClassId classId = FirDeclarationUtilKt.getClassId(typeAlias);
            Set set = data.computeIfAbsent((FirRegularClass)expansionClass, arg_0 -> InheritorsCollector.visitTypeAlias$lambda$9(InheritorsCollector::visitTypeAlias$lambda$8, arg_0));
            Intrinsics.checkNotNullExpressionValue(set, "computeIfAbsent(...)");
            this.collectInheritorsOfCorrespondingExpectSealedClass(classId, set);
        }

        private final void collectInheritorsOfCorrespondingExpectSealedClass(ClassId expectClassId, Set<ClassId> inheritors) {
            if (!FirLanguageSettingsComponentKt.getLanguageVersionSettings(this.session).supportsFeature(LanguageFeature.MultiPlatformProjects)) {
                return;
            }
            Object object = FirSymbolProviderKt.getRegularClassSymbolByClassId(FirSymbolProviderKt.getDependenciesSymbolProvider(this.session), expectClassId);
            if (object == null || (object = (FirRegularClass)((FirBasedSymbol)object).getFir()) == null) {
                return;
            }
            Object correspondingExpectClass = object;
            FirMemberDeclaration $this$isExpect$iv = (FirMemberDeclaration)correspondingExpectClass;
            boolean $i$f$isExpect = false;
            if ($this$isExpect$iv.getStatus().isExpect()) {
                Object $this$isSealed$iv = correspondingExpectClass;
                boolean $i$f$isSealed = false;
                if (((FirRegularClass)$this$isSealed$iv).getStatus().getModality() == Modality.SEALED) {
                    List<ClassId> commonInheritors = SealedClassInheritorsKt.getSealedClassInheritors((FirRegularClass)correspondingExpectClass, ((FirRegularClass)correspondingExpectClass).getModuleData().getSession());
                    inheritors.addAll((Collection<ClassId>)commonInheritors);
                }
            }
        }

        private final FirRegularClass extractClassFromTypeRef(FirSymbolProvider symbolProvider, FirTypeRef typeRef) {
            FirRegularClass firRegularClass;
            FirClassifierSymbol<?> firClassifierSymbol = FirTypeUtilsKt.getConeType(typeRef);
            Object object = firClassifierSymbol instanceof ConeLookupTagBasedType ? (ConeLookupTagBasedType)((Object)firClassifierSymbol) : null;
            if (object == null || (object = ((ConeLookupTagBasedType)object).getLookupTag()) == null) {
                return null;
            }
            Object lookupTag = object;
            FirClassifierSymbol<?> firClassifierSymbol2 = LookupTagUtilsKt.getSymbolByLookupTag(symbolProvider, (ConeClassifierLookupTag)lookupTag);
            if (firClassifierSymbol2 == null) {
                return null;
            }
            FirClassifierSymbol<?> classLikeSymbol = firClassifierSymbol2;
            firClassifierSymbol = classLikeSymbol;
            if (firClassifierSymbol instanceof FirRegularClassSymbol) {
                firRegularClass = (FirRegularClass)((FirRegularClassSymbol)classLikeSymbol).getFir();
            } else if (firClassifierSymbol instanceof FirTypeAliasSymbol) {
                FirLazyDeclarationResolverKt.lazyResolveToPhase((FirBasedSymbol)classLikeSymbol, FirResolvePhase.SUPER_TYPES);
                firRegularClass = this.extractClassFromTypeRef(symbolProvider, ((FirTypeAlias)((FirTypeAliasSymbol)classLikeSymbol).getFir()).getExpandedTypeRef());
            } else {
                firRegularClass = null;
            }
            return firRegularClass;
        }

        private static final Set visitRegularClass$lambda$4$lambda$2(FirRegularClass it) {
            Intrinsics.checkNotNullParameter(it, "it");
            return new LinkedHashSet();
        }

        private static final Set visitRegularClass$lambda$4$lambda$3(Function1 $tmp0, Object p0) {
            Intrinsics.checkNotNullParameter($tmp0, "$tmp0");
            return (Set)$tmp0.invoke(p0);
        }

        private static final Set visitRegularClass$lambda$6(FirRegularClass it) {
            Intrinsics.checkNotNullParameter(it, "it");
            return new LinkedHashSet();
        }

        private static final Set visitRegularClass$lambda$7(Function1 $tmp0, Object p0) {
            Intrinsics.checkNotNullParameter($tmp0, "$tmp0");
            return (Set)$tmp0.invoke(p0);
        }

        private static final Set visitTypeAlias$lambda$8(FirRegularClass it) {
            Intrinsics.checkNotNullParameter(it, "it");
            return new LinkedHashSet();
        }

        private static final Set visitTypeAlias$lambda$9(Function1 $tmp0, Object p0) {
            Intrinsics.checkNotNullParameter($tmp0, "$tmp0");
            return (Set)$tmp0.invoke(p0);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0001B!\u0012\u0018\u0010\u0003\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u0004\u00a2\u0006\u0004\b\b\u0010\tJ)\u0010\n\u001a\u0002H\u000b\"\b\b\u0000\u0010\u000b*\u00020\f2\u0006\u0010\r\u001a\u0002H\u000b2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0002H\u0016\u00a2\u0006\u0002\u0010\u000fJ\u001a\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00112\b\u0010\u000e\u001a\u0004\u0018\u00010\u0002H\u0016J\u001a\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00052\b\u0010\u000e\u001a\u0004\u0018\u00010\u0002H\u0016R \u0010\u0003\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/transformers/FirSealedClassInheritorsProcessor$InheritorsTransformer;", "Lorg/jetbrains/kotlin/fir/visitors/FirTransformer;", "", "inheritorsMap", "", "Lorg/jetbrains/kotlin/fir/declarations/FirRegularClass;", "", "Lorg/jetbrains/kotlin/name/ClassId;", "<init>", "(Ljava/util/Map;)V", "transformElement", "E", "Lorg/jetbrains/kotlin/fir/FirElement;", "element", "data", "(Lorg/jetbrains/kotlin/fir/FirElement;Ljava/lang/Object;)Lorg/jetbrains/kotlin/fir/FirElement;", "transformFile", "Lorg/jetbrains/kotlin/fir/declarations/FirFile;", "file", "transformRegularClass", "Lorg/jetbrains/kotlin/fir/expressions/FirStatement;", "regularClass", "resolve"})
    @SourceDebugExtension(value={"SMAP\nFirSealedClassInheritorsProcessor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirSealedClassInheritorsProcessor.kt\norg/jetbrains/kotlin/fir/resolve/transformers/FirSealedClassInheritorsProcessor$InheritorsTransformer\n+ 2 Utils.kt\norg/jetbrains/kotlin/fir/UtilsKt\n+ 3 FirStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirStatusUtilsKt\n*L\n1#1,138:1\n160#2,4:139\n11#3:143\n*S KotlinDebug\n*F\n+ 1 FirSealedClassInheritorsProcessor.kt\norg/jetbrains/kotlin/fir/resolve/transformers/FirSealedClassInheritorsProcessor$InheritorsTransformer\n*L\n121#1:139,4\n127#1:143\n*E\n"})
    public static final class InheritorsTransformer
    extends FirTransformer<Object> {
        @NotNull
        private final Map<FirRegularClass, Set<ClassId>> inheritorsMap;

        public InheritorsTransformer(@NotNull Map<FirRegularClass, Set<ClassId>> inheritorsMap) {
            Intrinsics.checkNotNullParameter(inheritorsMap, "inheritorsMap");
            this.inheritorsMap = inheritorsMap;
        }

        @Override
        @NotNull
        public <E extends FirElement> E transformElement(@NotNull E element, @Nullable Object data) {
            Intrinsics.checkNotNullParameter(element, "element");
            return element;
        }

        @Override
        @NotNull
        public FirFile transformFile(@NotNull FirFile file2, @Nullable Object data) {
            FirFile firFile;
            Intrinsics.checkNotNullParameter(file2, "file");
            boolean $i$f$withFileAnalysisExceptionWrapping = false;
            try {
                boolean bl = false;
                FirElement firElement = file2.transformChildren(this, data);
                Intrinsics.checkNotNull(firElement, "null cannot be cast to non-null type org.jetbrains.kotlin.fir.declarations.FirFile");
                firFile = (FirFile)firElement;
            }
            catch (Throwable throwable$iv) {
                UtilsKt.getExceptionHandler(file2.getModuleData().getSession()).handleExceptionOnFileAnalysis(file2, throwable$iv);
                throw null;
            }
            return firFile;
        }

        @Override
        @NotNull
        public FirStatement transformRegularClass(@NotNull FirRegularClass regularClass, @Nullable Object data) {
            Set<ClassId> inheritors;
            Intrinsics.checkNotNullParameter(regularClass, "regularClass");
            FirMemberDeclaration $this$modality$iv = regularClass;
            boolean $i$f$getModality = false;
            if ($this$modality$iv.getStatus().getModality() == Modality.SEALED && (inheritors = this.inheritorsMap.remove(regularClass)) != null) {
                SealedClassInheritorsKt.setSealedClassInheritors(regularClass, CollectionsKt.toList((Iterable)inheritors));
            }
            if (this.inheritorsMap.isEmpty()) {
                return regularClass;
            }
            FirElement firElement = regularClass.transformChildren(this, data);
            Intrinsics.checkNotNull(firElement, "null cannot be cast to non-null type org.jetbrains.kotlin.fir.declarations.FirRegularClass");
            return (FirRegularClass)firElement;
        }
    }
}

