/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.container;

import com.intellij.util.containers.ContainerUtil;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.container.CacheKt;
import org.jetbrains.kotlin.container.ClassInfo;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c2\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\t\u001a\u00020\b2\n\u0010\n\u001a\u0006\u0012\u0002\b\u00030\u0006R2\u0010\u0004\u001a&\u0012\u0014\u0012\u0012\u0012\u0002\b\u0003 \u0007*\b\u0012\u0002\b\u0003\u0018\u00010\u00060\u0006\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\b0\b0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/container/ClassTraversalCache;", "", "<init>", "()V", "cache", "Ljava/util/concurrent/ConcurrentMap;", "Ljava/lang/Class;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/kotlin/container/ClassInfo;", "getClassInfo", "c", "container"})
final class ClassTraversalCache {
    @NotNull
    public static final ClassTraversalCache INSTANCE;
    @NotNull
    private static final ConcurrentMap<Class<?>, ClassInfo> cache;

    private ClassTraversalCache() {
    }

    @NotNull
    public final ClassInfo getClassInfo(@NotNull Class<?> c) {
        Intrinsics.checkNotNullParameter(c, "c");
        ClassInfo classInfo = (ClassInfo)cache.get(c);
        if (classInfo == null) {
            ClassInfo newClassInfo = CacheKt.access$traverseClass(c);
            cache.put(c, newClassInfo);
            return newClassInfo;
        }
        return classInfo;
    }

    static {
        ConcurrentMap concurrentMap;
        INSTANCE = new ClassTraversalCache();
        if (System.getProperty("idea.system.path") != null) {
            concurrentMap = new ConcurrentHashMap();
        } else {
            ConcurrentMap concurrentMap2 = ContainerUtil.createConcurrentWeakKeySoftValueMap();
            concurrentMap = concurrentMap2;
            Intrinsics.checkNotNullExpressionValue(concurrentMap2, "createConcurrentWeakKeySoftValueMap(...)");
        }
        cache = concurrentMap;
    }
}

