/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.java.parser;

import com.intellij.core.JavaPsiBundle;
import com.intellij.lang.PsiBuilder;
import com.intellij.lang.PsiBuilderUtil;
import com.intellij.lang.WhitespacesBinders;
import com.intellij.lang.java.parser.DeclarationParser;
import com.intellij.lang.java.parser.JavaParser;
import com.intellij.lang.java.parser.JavaParserUtil;
import com.intellij.openapi.util.Pair;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.impl.source.tree.ElementType;
import com.intellij.psi.impl.source.tree.JavaElementType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.ILazyParseableElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.BitUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StatementParser {
    private static final TokenSet YIELD_STMT_INDICATOR_TOKENS = TokenSet.create(JavaTokenType.PLUS, JavaTokenType.MINUS, JavaTokenType.EXCL, JavaTokenType.SUPER_KEYWORD, JavaTokenType.THIS_KEYWORD, JavaTokenType.TRUE_KEYWORD, JavaTokenType.FALSE_KEYWORD, JavaTokenType.NULL_KEYWORD, JavaTokenType.STRING_LITERAL, JavaTokenType.INTEGER_LITERAL, JavaTokenType.DOUBLE_LITERAL, JavaTokenType.FLOAT_LITERAL, JavaTokenType.LONG_LITERAL, JavaTokenType.CHARACTER_LITERAL, JavaTokenType.IDENTIFIER, JavaTokenType.SWITCH_KEYWORD, JavaTokenType.NEW_KEYWORD, JavaTokenType.LPARENTH, JavaTokenType.RBRACE, JavaTokenType.SEMICOLON, JavaTokenType.CASE_KEYWORD);
    private static final TokenSet TRY_CLOSERS_SET = TokenSet.create(JavaTokenType.CATCH_KEYWORD, JavaTokenType.FINALLY_KEYWORD);
    private final JavaParser myParser;

    public StatementParser(@NotNull JavaParser javaParser) {
        if (javaParser == null) {
            StatementParser.$$$reportNull$$$0(0);
        }
        this.myParser = javaParser;
    }

    @Nullable
    public PsiBuilder.Marker parseCodeBlock(@NotNull PsiBuilder builder) {
        if (builder == null) {
            StatementParser.$$$reportNull$$$0(1);
        }
        return this.parseCodeBlock(builder, false);
    }

    @Nullable
    public PsiBuilder.Marker parseCodeBlock(@NotNull PsiBuilder builder, boolean isStatement) {
        if (builder == null) {
            StatementParser.$$$reportNull$$$0(2);
        }
        if (builder.getTokenType() != JavaTokenType.LBRACE) {
            return null;
        }
        if (isStatement && JavaParserUtil.isParseStatementCodeBlocksDeep(builder)) {
            return this.parseCodeBlockDeep(builder, false);
        }
        return PsiBuilderUtil.parseBlockLazy(builder, JavaTokenType.LBRACE, JavaTokenType.RBRACE, JavaElementType.CODE_BLOCK);
    }

    @Nullable
    public PsiBuilder.Marker parseCodeBlockDeep(@NotNull PsiBuilder builder, boolean parseUntilEof) {
        if (builder == null) {
            StatementParser.$$$reportNull$$$0(3);
        }
        if (builder.getTokenType() != JavaTokenType.LBRACE) {
            return null;
        }
        PsiBuilder.Marker codeBlock = builder.mark();
        builder.advanceLexer();
        this.parseStatements(builder, parseUntilEof ? BraceMode.TILL_LAST : BraceMode.TILL_FIRST);
        boolean greedyBlock = !JavaParserUtil.expectOrError(builder, JavaTokenType.RBRACE, "expected.rbrace");
        builder.getTokenType();
        JavaParserUtil.done(codeBlock, JavaElementType.CODE_BLOCK);
        if (greedyBlock) {
            codeBlock.setCustomEdgeTokenBinders(null, WhitespacesBinders.GREEDY_RIGHT_BINDER);
        }
        return codeBlock;
    }

    public void parseStatements(@NotNull PsiBuilder builder) {
        if (builder == null) {
            StatementParser.$$$reportNull$$$0(4);
        }
        this.parseStatements(builder, null);
    }

    private void parseStatements(PsiBuilder builder, @Nullable BraceMode braceMode) {
        while (builder.getTokenType() != null) {
            PsiBuilder.Marker statement = this.parseStatement(builder);
            if (statement != null) continue;
            IElementType tokenType = builder.getTokenType();
            if (tokenType == JavaTokenType.RBRACE && (braceMode == BraceMode.TILL_FIRST || braceMode == BraceMode.TILL_LAST && builder.lookAhead(1) == null)) break;
            PsiBuilder.Marker error = builder.mark();
            builder.advanceLexer();
            if (tokenType == JavaTokenType.ELSE_KEYWORD) {
                error.error(JavaPsiBundle.message("else.without.if", new Object[0]));
                continue;
            }
            if (tokenType == JavaTokenType.CATCH_KEYWORD) {
                error.error(JavaPsiBundle.message("catch.without.try", new Object[0]));
                continue;
            }
            if (tokenType == JavaTokenType.FINALLY_KEYWORD) {
                error.error(JavaPsiBundle.message("finally.without.try", new Object[0]));
                continue;
            }
            error.error(JavaPsiBundle.message("unexpected.token", new Object[0]));
        }
    }

    @Nullable
    public PsiBuilder.Marker parseStatement(@NotNull PsiBuilder builder) {
        PsiBuilder.Marker statement;
        IElementType tokenType;
        if (builder == null) {
            StatementParser.$$$reportNull$$$0(5);
        }
        if ((tokenType = builder.getTokenType()) == JavaTokenType.IF_KEYWORD) {
            return this.parseIfStatement(builder);
        }
        if (tokenType == JavaTokenType.WHILE_KEYWORD) {
            return this.parseWhileStatement(builder);
        }
        if (tokenType == JavaTokenType.FOR_KEYWORD) {
            return this.parseForStatement(builder);
        }
        if (tokenType == JavaTokenType.DO_KEYWORD) {
            return this.parseDoWhileStatement(builder);
        }
        if (tokenType == JavaTokenType.SWITCH_KEYWORD) {
            return this.parseSwitchStatement(builder);
        }
        if (tokenType == JavaTokenType.CASE_KEYWORD || tokenType == JavaTokenType.DEFAULT_KEYWORD) {
            return this.parseSwitchLabelStatement(builder);
        }
        if (tokenType == JavaTokenType.BREAK_KEYWORD) {
            return StatementParser.parseBreakStatement(builder);
        }
        if (StatementParser.isStmtYieldToken(builder, tokenType)) {
            return this.parseYieldStatement(builder);
        }
        if (tokenType == JavaTokenType.CONTINUE_KEYWORD) {
            return StatementParser.parseContinueStatement(builder);
        }
        if (tokenType == JavaTokenType.RETURN_KEYWORD) {
            return this.parseReturnStatement(builder);
        }
        if (tokenType == JavaTokenType.THROW_KEYWORD) {
            return this.parseThrowStatement(builder);
        }
        if (tokenType == JavaTokenType.SYNCHRONIZED_KEYWORD) {
            return this.parseSynchronizedStatement(builder);
        }
        if (tokenType == JavaTokenType.TRY_KEYWORD) {
            return this.parseTryStatement(builder);
        }
        if (tokenType == JavaTokenType.ASSERT_KEYWORD) {
            return this.parseAssertStatement(builder);
        }
        if (tokenType == JavaTokenType.LBRACE) {
            return this.parseBlockStatement(builder);
        }
        if (tokenType instanceof ILazyParseableElementType) {
            builder.advanceLexer();
            return null;
        }
        if (tokenType == JavaTokenType.SEMICOLON) {
            PsiBuilder.Marker empty = builder.mark();
            builder.advanceLexer();
            JavaParserUtil.done(empty, JavaElementType.EMPTY_STATEMENT);
            return empty;
        }
        if (tokenType == JavaTokenType.IDENTIFIER || tokenType == JavaTokenType.AT) {
            PsiBuilder.Marker refPos = builder.mark();
            this.myParser.getDeclarationParser().parseAnnotations(builder);
            StatementParser.skipQualifiedName(builder);
            IElementType suspectedLT = builder.getTokenType();
            IElementType next = builder.lookAhead(1);
            refPos.rollbackTo();
            if (suspectedLT == JavaTokenType.LT || suspectedLT == JavaTokenType.DOT && next == JavaTokenType.AT) {
                PsiBuilder.Marker declStatement = builder.mark();
                if (this.myParser.getDeclarationParser().parse(builder, DeclarationParser.Context.CODE_BLOCK) != null) {
                    JavaParserUtil.done(declStatement, JavaElementType.DECLARATION_STATEMENT);
                    return declStatement;
                }
                PsiBuilder.Marker type2 = this.myParser.getReferenceParser().parseType(builder, 0);
                if (type2 == null || builder.getTokenType() != JavaTokenType.DOUBLE_COLON) {
                    JavaParserUtil.error(builder, JavaPsiBundle.message("expected.identifier", new Object[0]));
                    if (type2 == null) {
                        builder.advanceLexer();
                    }
                    JavaParserUtil.done(declStatement, JavaElementType.DECLARATION_STATEMENT);
                    return declStatement;
                }
                declStatement.rollbackTo();
            }
        }
        PsiBuilder.Marker pos = builder.mark();
        PsiBuilder.Marker expr = this.myParser.getExpressionParser().parse(builder);
        if (expr != null) {
            int count = 1;
            PsiBuilder.Marker list = expr.precede();
            PsiBuilder.Marker statement2 = list.precede();
            while (builder.getTokenType() == JavaTokenType.COMMA) {
                PsiBuilder.Marker commaPos = builder.mark();
                builder.advanceLexer();
                PsiBuilder.Marker expr1 = this.myParser.getExpressionParser().parse(builder);
                if (expr1 == null) {
                    commaPos.rollbackTo();
                    break;
                }
                commaPos.drop();
                ++count;
            }
            if (count > 1) {
                pos.drop();
                JavaParserUtil.done(list, JavaElementType.EXPRESSION_LIST);
                JavaParserUtil.semicolon(builder);
                JavaParserUtil.done(statement2, JavaElementType.EXPRESSION_LIST_STATEMENT);
                return statement2;
            }
            if (JavaParserUtil.exprType(expr) != JavaElementType.REFERENCE_EXPRESSION) {
                PsiBuilderUtil.drop(list, pos);
                JavaParserUtil.semicolon(builder);
                JavaParserUtil.done(statement2, JavaElementType.EXPRESSION_STATEMENT);
                return statement2;
            }
            pos.rollbackTo();
        } else {
            pos.drop();
        }
        PsiBuilder.Marker decl = this.myParser.getDeclarationParser().parse(builder, DeclarationParser.Context.CODE_BLOCK);
        if (decl != null) {
            statement = decl.precede();
            JavaParserUtil.done(statement, JavaElementType.DECLARATION_STATEMENT);
            return statement;
        }
        if (builder.getTokenType() == JavaTokenType.IDENTIFIER && builder.lookAhead(1) == JavaTokenType.COLON) {
            statement = builder.mark();
            PsiBuilderUtil.advance(builder, 2);
            this.parseStatement(builder);
            JavaParserUtil.done(statement, JavaElementType.LABELED_STATEMENT);
            return statement;
        }
        if (expr != null) {
            statement = builder.mark();
            this.myParser.getExpressionParser().parse(builder);
            JavaParserUtil.semicolon(builder);
            JavaParserUtil.done(statement, JavaElementType.EXPRESSION_STATEMENT);
            return statement;
        }
        return null;
    }

    private static boolean isStmtYieldToken(@NotNull PsiBuilder builder, IElementType tokenType) {
        if (builder == null) {
            StatementParser.$$$reportNull$$$0(6);
        }
        if (tokenType != JavaTokenType.IDENTIFIER || !"yield".equals(builder.getTokenText()) || !JavaParserUtil.getLanguageLevel(builder).isAtLeast(LanguageLevel.JDK_14)) {
            return false;
        }
        PsiBuilder.Marker maybeYieldStmt = builder.mark();
        builder.advanceLexer();
        IElementType tokenAfterYield = builder.getTokenType();
        if (tokenAfterYield == null || YIELD_STMT_INDICATOR_TOKENS.contains(tokenAfterYield)) {
            maybeYieldStmt.rollbackTo();
            return true;
        }
        if (JavaTokenType.PLUSPLUS.equals(tokenAfterYield) || JavaTokenType.MINUSMINUS.equals(tokenAfterYield)) {
            builder.advanceLexer();
            boolean isYieldStmt = !builder.getTokenType().equals(JavaTokenType.SEMICOLON);
            maybeYieldStmt.rollbackTo();
            return isYieldStmt;
        }
        maybeYieldStmt.rollbackTo();
        return false;
    }

    private static void skipQualifiedName(PsiBuilder builder) {
        if (!PsiBuilderUtil.expect(builder, JavaTokenType.IDENTIFIER)) {
            return;
        }
        while (builder.getTokenType() == JavaTokenType.DOT && builder.lookAhead(1) == JavaTokenType.IDENTIFIER) {
            PsiBuilderUtil.advance(builder, 2);
        }
    }

    @NotNull
    private PsiBuilder.Marker parseIfStatement(PsiBuilder builder) {
        PsiBuilder.Marker statement = builder.mark();
        builder.advanceLexer();
        if (this.parseExprInParenth(builder)) {
            PsiBuilder.Marker elseStatement;
            PsiBuilder.Marker thenStatement = this.parseStatement(builder);
            if (thenStatement == null) {
                JavaParserUtil.error(builder, JavaPsiBundle.message("expected.statement", new Object[0]));
            } else if (PsiBuilderUtil.expect(builder, JavaTokenType.ELSE_KEYWORD) && (elseStatement = this.parseStatement(builder)) == null) {
                JavaParserUtil.error(builder, JavaPsiBundle.message("expected.statement", new Object[0]));
            }
        }
        JavaParserUtil.done(statement, JavaElementType.IF_STATEMENT);
        PsiBuilder.Marker marker = statement;
        if (marker == null) {
            StatementParser.$$$reportNull$$$0(7);
        }
        return marker;
    }

    @NotNull
    private PsiBuilder.Marker parseWhileStatement(PsiBuilder builder) {
        PsiBuilder.Marker marker = this.parseExprInParenthWithBlock(builder, JavaElementType.WHILE_STATEMENT, false);
        if (marker == null) {
            StatementParser.$$$reportNull$$$0(8);
        }
        return marker;
    }

    @NotNull
    private PsiBuilder.Marker parseForStatement(PsiBuilder builder) {
        PsiBuilder.Marker statement = builder.mark();
        builder.advanceLexer();
        if (!PsiBuilderUtil.expect(builder, JavaTokenType.LPARENTH)) {
            JavaParserUtil.error(builder, JavaPsiBundle.message("expected.lparen", new Object[0]));
            JavaParserUtil.done(statement, JavaElementType.FOR_STATEMENT);
            PsiBuilder.Marker marker = statement;
            if (marker == null) {
                StatementParser.$$$reportNull$$$0(9);
            }
            return marker;
        }
        PsiBuilder.Marker afterParenth = builder.mark();
        PsiBuilder.Marker param = this.myParser.getDeclarationParser().parseParameter(builder, false, false, true);
        if (param == null || JavaParserUtil.exprType(param) != JavaElementType.PARAMETER || builder.getTokenType() != JavaTokenType.COLON) {
            afterParenth.rollbackTo();
            return this.parseForLoopFromInitializer(builder, statement);
        }
        afterParenth.drop();
        return this.parseForEachFromColon(builder, statement);
    }

    @NotNull
    private PsiBuilder.Marker parseForLoopFromInitializer(PsiBuilder builder, PsiBuilder.Marker statement) {
        PsiBuilder.Marker bodyStatement;
        if (this.parseStatement(builder) == null) {
            JavaParserUtil.error(builder, JavaPsiBundle.message("expected.statement", new Object[0]));
            if (!PsiBuilderUtil.expect(builder, JavaTokenType.RPARENTH)) {
                JavaParserUtil.done(statement, JavaElementType.FOR_STATEMENT);
                PsiBuilder.Marker marker = statement;
                if (marker == null) {
                    StatementParser.$$$reportNull$$$0(10);
                }
                return marker;
            }
        } else {
            PsiBuilder.Marker expr;
            boolean missingSemicolon = false;
            if (StatementParser.getLastToken(builder) != JavaTokenType.SEMICOLON) {
                missingSemicolon = !JavaParserUtil.expectOrError(builder, JavaTokenType.SEMICOLON, "expected.semicolon");
            }
            missingSemicolon &= (expr = this.myParser.getExpressionParser().parse(builder)) == null;
            if (!PsiBuilderUtil.expect(builder, JavaTokenType.SEMICOLON)) {
                if (!missingSemicolon) {
                    JavaParserUtil.error(builder, JavaPsiBundle.message("expected.semicolon", new Object[0]));
                }
                if (!PsiBuilderUtil.expect(builder, JavaTokenType.RPARENTH)) {
                    JavaParserUtil.done(statement, JavaElementType.FOR_STATEMENT);
                    PsiBuilder.Marker marker = statement;
                    if (marker == null) {
                        StatementParser.$$$reportNull$$$0(11);
                    }
                    return marker;
                }
            } else {
                this.parseForUpdateExpressions(builder);
                if (!PsiBuilderUtil.expect(builder, JavaTokenType.RPARENTH)) {
                    JavaParserUtil.error(builder, JavaPsiBundle.message("expected.rparen", new Object[0]));
                    JavaParserUtil.done(statement, JavaElementType.FOR_STATEMENT);
                    PsiBuilder.Marker marker = statement;
                    if (marker == null) {
                        StatementParser.$$$reportNull$$$0(12);
                    }
                    return marker;
                }
            }
        }
        if ((bodyStatement = this.parseStatement(builder)) == null) {
            JavaParserUtil.error(builder, JavaPsiBundle.message("expected.statement", new Object[0]));
        }
        JavaParserUtil.done(statement, JavaElementType.FOR_STATEMENT);
        PsiBuilder.Marker marker = statement;
        if (marker == null) {
            StatementParser.$$$reportNull$$$0(13);
        }
        return marker;
    }

    private static IElementType getLastToken(PsiBuilder builder) {
        IElementType token;
        int offset2 = -1;
        while (ElementType.JAVA_COMMENT_OR_WHITESPACE_BIT_SET.contains(token = builder.rawLookup(offset2))) {
            --offset2;
        }
        return token;
    }

    private void parseForUpdateExpressions(PsiBuilder builder) {
        PsiBuilder.Marker expressionStatement;
        PsiBuilder.Marker expr = this.myParser.getExpressionParser().parse(builder);
        if (expr == null) {
            return;
        }
        if (builder.getTokenType() != JavaTokenType.COMMA) {
            expressionStatement = expr.precede();
            JavaParserUtil.done(expressionStatement, JavaElementType.EXPRESSION_STATEMENT);
        } else {
            PsiBuilder.Marker expressionList = expr.precede();
            expressionStatement = expressionList.precede();
            do {
                builder.advanceLexer();
                PsiBuilder.Marker nextExpression = this.myParser.getExpressionParser().parse(builder);
                if (nextExpression != null) continue;
                JavaParserUtil.error(builder, JavaPsiBundle.message("expected.expression", new Object[0]));
            } while (builder.getTokenType() == JavaTokenType.COMMA);
            JavaParserUtil.done(expressionList, JavaElementType.EXPRESSION_LIST);
            JavaParserUtil.done(expressionStatement, JavaElementType.EXPRESSION_LIST_STATEMENT);
        }
        expressionStatement.setCustomEdgeTokenBinders(null, WhitespacesBinders.DEFAULT_RIGHT_BINDER);
    }

    @NotNull
    private PsiBuilder.Marker parseForEachFromColon(PsiBuilder builder, PsiBuilder.Marker statement) {
        builder.advanceLexer();
        if (this.myParser.getExpressionParser().parse(builder) == null) {
            JavaParserUtil.error(builder, JavaPsiBundle.message("expected.expression", new Object[0]));
        }
        if (JavaParserUtil.expectOrError(builder, JavaTokenType.RPARENTH, "expected.rparen") && this.parseStatement(builder) == null) {
            JavaParserUtil.error(builder, JavaPsiBundle.message("expected.statement", new Object[0]));
        }
        JavaParserUtil.done(statement, JavaElementType.FOREACH_STATEMENT);
        PsiBuilder.Marker marker = statement;
        if (marker == null) {
            StatementParser.$$$reportNull$$$0(14);
        }
        return marker;
    }

    @NotNull
    private PsiBuilder.Marker parseDoWhileStatement(PsiBuilder builder) {
        PsiBuilder.Marker statement = builder.mark();
        builder.advanceLexer();
        PsiBuilder.Marker body2 = this.parseStatement(builder);
        if (body2 == null) {
            JavaParserUtil.error(builder, JavaPsiBundle.message("expected.statement", new Object[0]));
        } else if (!PsiBuilderUtil.expect(builder, JavaTokenType.WHILE_KEYWORD)) {
            JavaParserUtil.error(builder, JavaPsiBundle.message("expected.while", new Object[0]));
        } else if (this.parseExprInParenth(builder)) {
            JavaParserUtil.semicolon(builder);
        }
        JavaParserUtil.done(statement, JavaElementType.DO_WHILE_STATEMENT);
        PsiBuilder.Marker marker = statement;
        if (marker == null) {
            StatementParser.$$$reportNull$$$0(15);
        }
        return marker;
    }

    @NotNull
    private PsiBuilder.Marker parseSwitchStatement(PsiBuilder builder) {
        PsiBuilder.Marker marker = this.parseExprInParenthWithBlock(builder, JavaElementType.SWITCH_STATEMENT, true);
        if (marker == null) {
            StatementParser.$$$reportNull$$$0(16);
        }
        return marker;
    }

    @NotNull Pair<@Nullable PsiBuilder.Marker, Boolean> parseCaseLabel(PsiBuilder builder) {
        if (builder.getTokenType() == JavaTokenType.DEFAULT_KEYWORD) {
            PsiBuilder.Marker defaultElement = builder.mark();
            builder.advanceLexer();
            JavaParserUtil.done(defaultElement, JavaElementType.DEFAULT_CASE_LABEL_ELEMENT);
            Pair<PsiBuilder.Marker, Boolean> pair = Pair.create(defaultElement, false);
            if (pair == null) {
                StatementParser.$$$reportNull$$$0(17);
            }
            return pair;
        }
        if (this.myParser.getPatternParser().isPattern(builder)) {
            Pair<PsiBuilder.Marker, Boolean> pair = Pair.create(this.myParser.getPatternParser().parsePattern(builder), false);
            if (pair == null) {
                StatementParser.$$$reportNull$$$0(18);
            }
            return pair;
        }
        Pair<PsiBuilder.Marker, Boolean> pair = Pair.create(this.myParser.getExpressionParser().parseAssignment(builder, BitUtil.set(0, 1, true)), true);
        if (pair == null) {
            StatementParser.$$$reportNull$$$0(19);
        }
        return pair;
    }

    private PsiBuilder.Marker parseSwitchLabelStatement(PsiBuilder builder) {
        PsiBuilder.Marker statement = builder.mark();
        boolean isCase = builder.getTokenType() == JavaTokenType.CASE_KEYWORD;
        builder.advanceLexer();
        if (isCase) {
            boolean patternsAllowed = JavaParserUtil.getLanguageLevel(builder).isAtLeast(LanguageLevel.JDK_17);
            PsiBuilder.Marker list = builder.mark();
            do {
                Pair<PsiBuilder.Marker, Boolean> markerAndIsExpression = this.parseCaseLabel(builder);
                PsiBuilder.Marker caseLabel = (PsiBuilder.Marker)markerAndIsExpression.first;
                if (caseLabel != null) continue;
                JavaParserUtil.error(builder, JavaPsiBundle.message(patternsAllowed ? "expected.case.label.element" : "expected.expression", new Object[0]));
            } while (PsiBuilderUtil.expect(builder, JavaTokenType.COMMA));
            JavaParserUtil.done(list, JavaElementType.CASE_LABEL_ELEMENT_LIST);
        }
        if (PsiBuilderUtil.expect(builder, JavaTokenType.ARROW)) {
            PsiBuilder.Marker body2;
            if (builder.getTokenType() == JavaTokenType.LBRACE) {
                body2 = builder.mark();
                this.parseCodeBlock(builder, true);
                body2.done(JavaElementType.BLOCK_STATEMENT);
                if (builder.getTokenType() == JavaTokenType.SEMICOLON) {
                    PsiBuilder.Marker mark = builder.mark();
                    while (builder.getTokenType() == JavaTokenType.SEMICOLON) {
                        builder.advanceLexer();
                    }
                    mark.error(JavaPsiBundle.message("expected.switch.label", new Object[0]));
                }
            } else if (builder.getTokenType() == JavaTokenType.THROW_KEYWORD) {
                this.parseThrowStatement(builder);
            } else {
                PsiBuilder.Marker expr = this.myParser.getExpressionParser().parse(builder);
                if (expr != null) {
                    body2 = expr.precede();
                    JavaParserUtil.semicolon(builder);
                    body2.done(JavaElementType.EXPRESSION_STATEMENT);
                } else {
                    JavaParserUtil.error(builder, JavaPsiBundle.message("expected.switch.rule", new Object[0]));
                    PsiBuilderUtil.expect(builder, JavaTokenType.SEMICOLON);
                }
            }
            JavaParserUtil.done(statement, JavaElementType.SWITCH_LABELED_RULE);
        } else {
            JavaParserUtil.expectOrError(builder, JavaTokenType.COLON, "expected.colon");
            JavaParserUtil.done(statement, JavaElementType.SWITCH_LABEL_STATEMENT);
        }
        return statement;
    }

    @NotNull
    private static PsiBuilder.Marker parseBreakStatement(PsiBuilder builder) {
        PsiBuilder.Marker statement = builder.mark();
        builder.advanceLexer();
        PsiBuilderUtil.expect(builder, JavaTokenType.IDENTIFIER);
        JavaParserUtil.semicolon(builder);
        JavaParserUtil.done(statement, JavaElementType.BREAK_STATEMENT);
        PsiBuilder.Marker marker = statement;
        if (marker == null) {
            StatementParser.$$$reportNull$$$0(20);
        }
        return marker;
    }

    @NotNull
    private PsiBuilder.Marker parseYieldStatement(PsiBuilder builder) {
        PsiBuilder.Marker statement = builder.mark();
        builder.remapCurrentToken(JavaTokenType.YIELD_KEYWORD);
        builder.advanceLexer();
        if (this.myParser.getExpressionParser().parse(builder) == null) {
            JavaParserUtil.error(builder, JavaPsiBundle.message("expected.expression", new Object[0]));
        } else {
            JavaParserUtil.semicolon(builder);
        }
        JavaParserUtil.done(statement, JavaElementType.YIELD_STATEMENT);
        PsiBuilder.Marker marker = statement;
        if (marker == null) {
            StatementParser.$$$reportNull$$$0(21);
        }
        return marker;
    }

    @NotNull
    private static PsiBuilder.Marker parseContinueStatement(PsiBuilder builder) {
        PsiBuilder.Marker statement = builder.mark();
        builder.advanceLexer();
        PsiBuilderUtil.expect(builder, JavaTokenType.IDENTIFIER);
        JavaParserUtil.semicolon(builder);
        JavaParserUtil.done(statement, JavaElementType.CONTINUE_STATEMENT);
        PsiBuilder.Marker marker = statement;
        if (marker == null) {
            StatementParser.$$$reportNull$$$0(22);
        }
        return marker;
    }

    @NotNull
    private PsiBuilder.Marker parseReturnStatement(PsiBuilder builder) {
        PsiBuilder.Marker statement = builder.mark();
        builder.advanceLexer();
        this.myParser.getExpressionParser().parse(builder);
        JavaParserUtil.semicolon(builder);
        JavaParserUtil.done(statement, JavaElementType.RETURN_STATEMENT);
        PsiBuilder.Marker marker = statement;
        if (marker == null) {
            StatementParser.$$$reportNull$$$0(23);
        }
        return marker;
    }

    @NotNull
    private PsiBuilder.Marker parseThrowStatement(PsiBuilder builder) {
        PsiBuilder.Marker statement = builder.mark();
        builder.advanceLexer();
        if (this.myParser.getExpressionParser().parse(builder) == null) {
            JavaParserUtil.error(builder, JavaPsiBundle.message("expected.expression", new Object[0]));
        } else {
            JavaParserUtil.semicolon(builder);
        }
        JavaParserUtil.done(statement, JavaElementType.THROW_STATEMENT);
        PsiBuilder.Marker marker = statement;
        if (marker == null) {
            StatementParser.$$$reportNull$$$0(24);
        }
        return marker;
    }

    @NotNull
    private PsiBuilder.Marker parseSynchronizedStatement(PsiBuilder builder) {
        PsiBuilder.Marker marker = this.parseExprInParenthWithBlock(builder, JavaElementType.SYNCHRONIZED_STATEMENT, true);
        if (marker == null) {
            StatementParser.$$$reportNull$$$0(25);
        }
        return marker;
    }

    @NotNull
    private PsiBuilder.Marker parseTryStatement(PsiBuilder builder) {
        PsiBuilder.Marker tryBlock;
        boolean hasResourceList;
        PsiBuilder.Marker statement = builder.mark();
        builder.advanceLexer();
        boolean bl = hasResourceList = builder.getTokenType() == JavaTokenType.LPARENTH;
        if (hasResourceList) {
            this.myParser.getDeclarationParser().parseResourceList(builder);
        }
        if ((tryBlock = this.parseCodeBlock(builder, true)) == null) {
            JavaParserUtil.error(builder, JavaPsiBundle.message("expected.lbrace", new Object[0]));
        } else if (!hasResourceList && !TRY_CLOSERS_SET.contains(builder.getTokenType())) {
            JavaParserUtil.error(builder, JavaPsiBundle.message("expected.catch.or.finally", new Object[0]));
        } else {
            PsiBuilder.Marker finallyBlock;
            while (builder.getTokenType() == JavaTokenType.CATCH_KEYWORD && this.parseCatchBlock(builder)) {
            }
            if (PsiBuilderUtil.expect(builder, JavaTokenType.FINALLY_KEYWORD) && (finallyBlock = this.parseCodeBlock(builder, true)) == null) {
                JavaParserUtil.error(builder, JavaPsiBundle.message("expected.lbrace", new Object[0]));
            }
        }
        JavaParserUtil.done(statement, JavaElementType.TRY_STATEMENT);
        PsiBuilder.Marker marker = statement;
        if (marker == null) {
            StatementParser.$$$reportNull$$$0(26);
        }
        return marker;
    }

    public boolean parseCatchBlock(@NotNull PsiBuilder builder) {
        if (builder == null) {
            StatementParser.$$$reportNull$$$0(27);
        }
        assert (builder.getTokenType() == JavaTokenType.CATCH_KEYWORD) : builder.getTokenType();
        PsiBuilder.Marker section = builder.mark();
        builder.advanceLexer();
        if (!PsiBuilderUtil.expect(builder, JavaTokenType.LPARENTH)) {
            JavaParserUtil.error(builder, JavaPsiBundle.message("expected.lparen", new Object[0]));
            JavaParserUtil.done(section, JavaElementType.CATCH_SECTION);
            return false;
        }
        PsiBuilder.Marker param = this.myParser.getDeclarationParser().parseParameter(builder, false, true, false);
        if (param == null) {
            JavaParserUtil.error(builder, JavaPsiBundle.message("expected.parameter", new Object[0]));
        }
        if (!PsiBuilderUtil.expect(builder, JavaTokenType.RPARENTH)) {
            JavaParserUtil.error(builder, JavaPsiBundle.message("expected.rparen", new Object[0]));
            JavaParserUtil.done(section, JavaElementType.CATCH_SECTION);
            return false;
        }
        PsiBuilder.Marker body2 = this.parseCodeBlock(builder, true);
        if (body2 == null) {
            JavaParserUtil.error(builder, JavaPsiBundle.message("expected.lbrace", new Object[0]));
            JavaParserUtil.done(section, JavaElementType.CATCH_SECTION);
            return false;
        }
        JavaParserUtil.done(section, JavaElementType.CATCH_SECTION);
        return true;
    }

    @NotNull
    private PsiBuilder.Marker parseAssertStatement(PsiBuilder builder) {
        PsiBuilder.Marker statement = builder.mark();
        builder.advanceLexer();
        if (this.myParser.getExpressionParser().parse(builder) == null) {
            JavaParserUtil.error(builder, JavaPsiBundle.message("expected.boolean.expression", new Object[0]));
        } else if (PsiBuilderUtil.expect(builder, JavaTokenType.COLON) && this.myParser.getExpressionParser().parse(builder) == null) {
            JavaParserUtil.error(builder, JavaPsiBundle.message("expected.expression", new Object[0]));
        } else {
            JavaParserUtil.semicolon(builder);
        }
        JavaParserUtil.done(statement, JavaElementType.ASSERT_STATEMENT);
        PsiBuilder.Marker marker = statement;
        if (marker == null) {
            StatementParser.$$$reportNull$$$0(28);
        }
        return marker;
    }

    @NotNull
    private PsiBuilder.Marker parseBlockStatement(PsiBuilder builder) {
        PsiBuilder.Marker statement = builder.mark();
        this.parseCodeBlock(builder, true);
        JavaParserUtil.done(statement, JavaElementType.BLOCK_STATEMENT);
        PsiBuilder.Marker marker = statement;
        if (marker == null) {
            StatementParser.$$$reportNull$$$0(29);
        }
        return marker;
    }

    @NotNull
    public PsiBuilder.Marker parseExprInParenthWithBlock(@NotNull PsiBuilder builder, @NotNull IElementType type2, boolean block) {
        if (builder == null) {
            StatementParser.$$$reportNull$$$0(30);
        }
        if (type2 == null) {
            StatementParser.$$$reportNull$$$0(31);
        }
        PsiBuilder.Marker statement = builder.mark();
        builder.advanceLexer();
        if (this.parseExprInParenth(builder)) {
            PsiBuilder.Marker body2;
            PsiBuilder.Marker marker = body2 = block ? this.parseCodeBlock(builder, true) : this.parseStatement(builder);
            if (body2 == null) {
                JavaParserUtil.error(builder, JavaPsiBundle.message(block ? "expected.lbrace" : "expected.statement", new Object[0]));
            }
        }
        JavaParserUtil.done(statement, type2);
        PsiBuilder.Marker marker = statement;
        if (marker == null) {
            StatementParser.$$$reportNull$$$0(32);
        }
        return marker;
    }

    private boolean parseExprInParenth(PsiBuilder builder) {
        if (!PsiBuilderUtil.expect(builder, JavaTokenType.LPARENTH)) {
            JavaParserUtil.error(builder, JavaPsiBundle.message("expected.lparen", new Object[0]));
            return false;
        }
        PsiBuilder.Marker beforeExpr = builder.mark();
        PsiBuilder.Marker expr = this.myParser.getExpressionParser().parse(builder);
        if (expr == null || builder.getTokenType() == JavaTokenType.SEMICOLON) {
            beforeExpr.rollbackTo();
            JavaParserUtil.error(builder, JavaPsiBundle.message("expected.expression", new Object[0]));
            if (builder.getTokenType() != JavaTokenType.RPARENTH) {
                return false;
            }
        } else {
            beforeExpr.drop();
            if (builder.getTokenType() != JavaTokenType.RPARENTH) {
                JavaParserUtil.error(builder, JavaPsiBundle.message("expected.rparen", new Object[0]));
                return false;
            }
        }
        builder.advanceLexer();
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 28: 
            case 29: 
            case 32: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 28: 
            case 29: 
            case 32: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "javaParser";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 27: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 28: 
            case 29: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/java/parser/StatementParser";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/java/parser/StatementParser";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "parseIfStatement";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "parseWhileStatement";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "parseForStatement";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "parseForLoopFromInitializer";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "parseForEachFromColon";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "parseDoWhileStatement";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "parseSwitchStatement";
                break;
            }
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "parseCaseLabel";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "parseBreakStatement";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "parseYieldStatement";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "parseContinueStatement";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "parseReturnStatement";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "parseThrowStatement";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "parseSynchronizedStatement";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "parseTryStatement";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "parseAssertStatement";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "parseBlockStatement";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "parseExprInParenthWithBlock";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "parseCodeBlock";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "parseCodeBlockDeep";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "parseStatements";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "parseStatement";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isStmtYieldToken";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 28: 
            case 29: 
            case 32: {
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "parseCatchBlock";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "parseExprInParenthWithBlock";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 28: 
            case 29: 
            case 32: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    private static enum BraceMode {
        TILL_FIRST,
        TILL_LAST;

    }
}

