/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.cfa.util;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin._Assertions;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.collections.immutable.ExtensionsKt;
import kotlinx.collections.immutable.PersistentMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.contracts.description.EventOccurrencesRange;
import org.jetbrains.kotlin.fir.analysis.cfa.util.CfgTraverserKt;
import org.jetbrains.kotlin.fir.analysis.cfa.util.DeclaredVariableCollector;
import org.jetbrains.kotlin.fir.analysis.cfa.util.PathAwareControlFlowGraphVisitor;
import org.jetbrains.kotlin.fir.analysis.cfa.util.PropertyInitializationInfo;
import org.jetbrains.kotlin.fir.analysis.cfa.util.PropertyInitializationInfoCollectorKt;
import org.jetbrains.kotlin.fir.analysis.cfa.util.TraverseDirection;
import org.jetbrains.kotlin.fir.references.FirReferenceUtilsKt;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.CFGNode;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.ControlFlowGraph;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.Edge;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.EdgeLabel;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.LoopBlockEnterNode;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.LoopConditionEnterNode;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.LoopEnterNode;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.LoopExitNode;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.NormalPath;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.VariableAssignmentNode;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.VariableDeclarationNode;
import org.jetbrains.kotlin.fir.symbols.impl.FirPropertySymbol;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 )2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001)B\u001d\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ4\u0010\u000f\u001a(\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0011\u0012\u001a\u0012\u0018\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00020\nj\b\u0012\u0004\u0012\u00020\u0002`\u00120\u00102\u0006\u0010\u0013\u001a\u00020\u0014JB\u0010\u0015\u001a\u0012\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00020\nj\u0002`\f2\u0016\u0010\u0016\u001a\u0012\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00020\nj\u0002`\f2\u0006\u0010\u0017\u001a\u00020\u00052\b\b\u0002\u0010\u0018\u001a\u00020\u0019H\u0002JP\u0010\u001a\u001a\u0012\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00020\nj\u0002`\f2\n\u0010\u001b\u001a\u0006\u0012\u0002\b\u00030\u00112\n\u0010\u001c\u001a\u0006\u0012\u0002\b\u00030\u00112\u0006\u0010\u001d\u001a\u00020\u001e2\u0016\u0010\u001f\u001a\u0012\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00020\nj\u0002`\fH\u0016J8\u0010 \u001a\u0012\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00020\nj\u0002`\f2\u0006\u0010!\u001a\u00020\"2\u0016\u0010\u001f\u001a\u0012\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00020\nj\u0002`\fH\u0016J8\u0010#\u001a\u0012\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00020\nj\u0002`\f2\u0006\u0010!\u001a\u00020$2\u0016\u0010\u001f\u001a\u0012\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00020\nj\u0002`\fH\u0016J8\u0010%\u001a\u0012\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00020\nj\u0002`\f2\u0006\u0010!\u001a\u00020&2\u0016\u0010\u001f\u001a\u0012\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00020\nj\u0002`\fH\u0016J8\u0010'\u001a\u0012\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00020\nj\u0002`\f2\u0006\u0010!\u001a\u00020(2\u0016\u0010\u001f\u001a\u0012\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00020\nj\u0002`\fH\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\t\u001a\u0012\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00020\nj\u0002`\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/cfa/util/PropertyInitializationInfoCollector;", "Lorg/jetbrains/kotlin/fir/analysis/cfa/util/PathAwareControlFlowGraphVisitor;", "Lorg/jetbrains/kotlin/fir/analysis/cfa/util/PropertyInitializationInfo;", "localProperties", "", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirPropertySymbol;", "declaredVariableCollector", "Lorg/jetbrains/kotlin/fir/analysis/cfa/util/DeclaredVariableCollector;", "(Ljava/util/Set;Lorg/jetbrains/kotlin/fir/analysis/cfa/util/DeclaredVariableCollector;)V", "emptyInfo", "Lkotlinx/collections/immutable/PersistentMap;", "Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/EdgeLabel;", "Lorg/jetbrains/kotlin/fir/analysis/cfa/util/PathAwarePropertyInitializationInfo;", "getEmptyInfo", "()Lkotlinx/collections/immutable/PersistentMap;", "getData", "", "Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/CFGNode;", "Lorg/jetbrains/kotlin/fir/analysis/cfa/util/PathAwareControlFlowInfo;", "graph", "Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/ControlFlowGraph;", "processVariableWithAssignment", "dataForNode", "symbol", "overwriteRange", "", "visitEdge", "from", "to", "metadata", "Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/Edge;", "data", "visitLoopEnterNode", "node", "Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/LoopEnterNode;", "visitLoopExitNode", "Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/LoopExitNode;", "visitVariableAssignmentNode", "Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/VariableAssignmentNode;", "visitVariableDeclarationNode", "Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/VariableDeclarationNode;", "Companion", "checkers"})
@SourceDebugExtension(value={"SMAP\nPropertyInitializationInfoCollector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PropertyInitializationInfoCollector.kt\norg/jetbrains/kotlin/fir/analysis/cfa/util/PropertyInitializationInfoCollector\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,164:1\n1789#2,3:165\n*S KotlinDebug\n*F\n+ 1 PropertyInitializationInfoCollector.kt\norg/jetbrains/kotlin/fir/analysis/cfa/util/PropertyInitializationInfoCollector\n*L\n93#1:165,3\n*E\n"})
public final class PropertyInitializationInfoCollector
extends PathAwareControlFlowGraphVisitor<PropertyInitializationInfo> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Set<FirPropertySymbol> localProperties;
    @NotNull
    private final DeclaredVariableCollector declaredVariableCollector;
    @NotNull
    private static final PersistentMap<EdgeLabel, PropertyInitializationInfo> EMPTY_INFO;

    public PropertyInitializationInfoCollector(@NotNull Set<? extends FirPropertySymbol> localProperties, @NotNull DeclaredVariableCollector declaredVariableCollector) {
        Intrinsics.checkNotNullParameter(localProperties, "localProperties");
        Intrinsics.checkNotNullParameter(declaredVariableCollector, "declaredVariableCollector");
        this.localProperties = localProperties;
        this.declaredVariableCollector = declaredVariableCollector;
    }

    public /* synthetic */ PropertyInitializationInfoCollector(Set set, DeclaredVariableCollector declaredVariableCollector, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            declaredVariableCollector = new DeclaredVariableCollector();
        }
        this(set, declaredVariableCollector);
    }

    @Override
    @NotNull
    public PersistentMap<EdgeLabel, PropertyInitializationInfo> getEmptyInfo() {
        return EMPTY_INFO;
    }

    @Override
    @NotNull
    public PersistentMap<EdgeLabel, PropertyInitializationInfo> visitVariableAssignmentNode(@NotNull VariableAssignmentNode node, @NotNull PersistentMap<EdgeLabel, PropertyInitializationInfo> data2) {
        Intrinsics.checkNotNullParameter(node, "node");
        Intrinsics.checkNotNullParameter(data2, "data");
        PersistentMap dataForNode = this.visitNode((CFGNode)node, data2);
        FirPropertySymbol firPropertySymbol = FirReferenceUtilsKt.toResolvedPropertySymbol$default(node.getFir().getCalleeReference(), false, 1, null);
        if (firPropertySymbol == null) {
            return dataForNode;
        }
        FirPropertySymbol symbol2 = firPropertySymbol;
        return !this.localProperties.contains(symbol2) ? dataForNode : PropertyInitializationInfoCollector.processVariableWithAssignment$default(this, dataForNode, symbol2, false, 4, null);
    }

    @Override
    @NotNull
    public PersistentMap<EdgeLabel, PropertyInitializationInfo> visitVariableDeclarationNode(@NotNull VariableDeclarationNode node, @NotNull PersistentMap<EdgeLabel, PropertyInitializationInfo> data2) {
        Intrinsics.checkNotNullParameter(node, "node");
        Intrinsics.checkNotNullParameter(data2, "data");
        PersistentMap<EdgeLabel, PropertyInitializationInfo> dataForNode = this.visitNode((CFGNode)node, data2);
        return this.processVariableWithAssignment(dataForNode, node.getFir().getSymbol(), node.getFir().getInitializer() == null && node.getFir().getDelegate() == null);
    }

    @NotNull
    public final Map<CFGNode<?>, PersistentMap<EdgeLabel, PropertyInitializationInfo>> getData(@NotNull ControlFlowGraph graph) {
        Intrinsics.checkNotNullParameter(graph, "graph");
        return CfgTraverserKt.collectDataForNode$default(graph, TraverseDirection.Forward, this, false, 4, null);
    }

    private final PersistentMap<EdgeLabel, PropertyInitializationInfo> processVariableWithAssignment(PersistentMap<EdgeLabel, PropertyInitializationInfo> dataForNode, FirPropertySymbol symbol2, boolean overwriteRange) {
        boolean bl;
        boolean bl2 = bl = !((Collection)dataForNode.keySet()).isEmpty();
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        return overwriteRange ? PropertyInitializationInfoCollectorKt.access$overwriteRange(dataForNode, symbol2, EventOccurrencesRange.ZERO) : PropertyInitializationInfoCollectorKt.addRange(dataForNode, symbol2, EventOccurrencesRange.EXACTLY_ONCE);
    }

    static /* synthetic */ PersistentMap processVariableWithAssignment$default(PropertyInitializationInfoCollector propertyInitializationInfoCollector, PersistentMap persistentMap, FirPropertySymbol firPropertySymbol, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = false;
        }
        return propertyInitializationInfoCollector.processVariableWithAssignment(persistentMap, firPropertySymbol, bl);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public PersistentMap<EdgeLabel, PropertyInitializationInfo> visitEdge(@NotNull CFGNode<?> from2, @NotNull CFGNode<?> to, @NotNull Edge metadata, @NotNull PersistentMap<EdgeLabel, PropertyInitializationInfo> data2) {
        Set set;
        Intrinsics.checkNotNullParameter(from2, "from");
        Intrinsics.checkNotNullParameter(to, "to");
        Intrinsics.checkNotNullParameter(metadata, "metadata");
        Intrinsics.checkNotNullParameter(data2, "data");
        PersistentMap<EdgeLabel, PropertyInitializationInfo> result2 = super.visitEdge(from2, to, metadata, data2);
        if (!metadata.getKind().isBack()) {
            return result2;
        }
        CFGNode<?> cFGNode = to;
        if (cFGNode instanceof LoopEnterNode) {
            set = (Set)this.declaredVariableCollector.getDeclaredVariablesPerElement().get(((LoopEnterNode)to).getFir());
        } else if (cFGNode instanceof LoopBlockEnterNode) {
            set = (Set)this.declaredVariableCollector.getDeclaredVariablesPerElement().get(((LoopBlockEnterNode)to).getFir());
        } else if (cFGNode instanceof LoopConditionEnterNode) {
            set = (Set)this.declaredVariableCollector.getDeclaredVariablesPerElement().get(((LoopConditionEnterNode)to).getLoop());
        } else {
            return result2;
        }
        Set declaredVariableSymbolsInCapturedScope = set;
        Iterable $this$fold$iv = declaredVariableSymbolsInCapturedScope;
        boolean $i$f$fold = false;
        PersistentMap accumulator$iv = data2;
        for (Object element$iv : $this$fold$iv) {
            void variableSymbol;
            FirPropertySymbol firPropertySymbol = (FirPropertySymbol)element$iv;
            PersistentMap filteredData = accumulator$iv;
            boolean bl = false;
            accumulator$iv = PropertyInitializationInfoCollectorKt.access$removeRange(filteredData, variableSymbol);
        }
        return accumulator$iv;
    }

    @Override
    @NotNull
    public PersistentMap<EdgeLabel, PropertyInitializationInfo> visitLoopEnterNode(@NotNull LoopEnterNode node, @NotNull PersistentMap<EdgeLabel, PropertyInitializationInfo> data2) {
        Intrinsics.checkNotNullParameter(node, "node");
        Intrinsics.checkNotNullParameter(data2, "data");
        this.declaredVariableCollector.enterCapturingStatement(node.getFir());
        return this.visitNode((CFGNode)node, data2);
    }

    @Override
    @NotNull
    public PersistentMap<EdgeLabel, PropertyInitializationInfo> visitLoopExitNode(@NotNull LoopExitNode node, @NotNull PersistentMap<EdgeLabel, PropertyInitializationInfo> data2) {
        Intrinsics.checkNotNullParameter(node, "node");
        Intrinsics.checkNotNullParameter(data2, "data");
        this.declaredVariableCollector.exitCapturingStatement(node.getFir());
        return this.visitNode((CFGNode)node, data2);
    }

    static {
        Pair[] pairArray = new Pair[]{TuplesKt.to(NormalPath.INSTANCE, PropertyInitializationInfo.Companion.getEMPTY())};
        EMPTY_INFO = ExtensionsKt.persistentMapOf(pairArray);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001e\u0010\u0003\u001a\u0012\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004j\u0002`\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/cfa/util/PropertyInitializationInfoCollector$Companion;", "", "()V", "EMPTY_INFO", "Lkotlinx/collections/immutable/PersistentMap;", "Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/EdgeLabel;", "Lorg/jetbrains/kotlin/fir/analysis/cfa/util/PropertyInitializationInfo;", "Lorg/jetbrains/kotlin/fir/analysis/cfa/util/PathAwarePropertyInitializationInfo;", "checkers"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

