/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.expression;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.expression.FirExpressionChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirAnonymousFunction;
import org.jetbrains.kotlin.fir.declarations.FirConstructor;
import org.jetbrains.kotlin.fir.declarations.FirErrorFunction;
import org.jetbrains.kotlin.fir.declarations.FirFunction;
import org.jetbrains.kotlin.fir.expressions.ExhaustivenessStatusKt;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirExpressionWithSmartcast;
import org.jetbrains.kotlin.fir.expressions.FirReturnExpression;
import org.jetbrains.kotlin.fir.expressions.FirWhenExpression;
import org.jetbrains.kotlin.fir.types.ConeInferenceContext;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeNullability;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.InferenceUtilsKt;
import org.jetbrains.kotlin.fir.types.TypeComponentsKt;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirFunctionReturnTypeMismatchChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirExpressionChecker;", "Lorg/jetbrains/kotlin/fir/expressions/FirReturnExpression;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirReturnExpressionChecker;", "()V", "check", "", "expression", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkers"})
public final class FirFunctionReturnTypeMismatchChecker
extends FirExpressionChecker<FirReturnExpression> {
    @NotNull
    public static final FirFunctionReturnTypeMismatchChecker INSTANCE = new FirFunctionReturnTypeMismatchChecker();

    private FirFunctionReturnTypeMismatchChecker() {
    }

    @Override
    public void check(@NotNull FirReturnExpression expression2, @NotNull CheckerContext context, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        Intrinsics.checkNotNullParameter(context, "context");
        Intrinsics.checkNotNullParameter(reporter, "reporter");
        if (expression2.getSource() == null) {
            return;
        }
        FirFunction targetElement = expression2.getTarget().getLabeledElement();
        if (targetElement instanceof FirErrorFunction || targetElement instanceof FirAnonymousFunction && ((FirAnonymousFunction)targetElement).isLambda()) {
            return;
        }
        FirExpression resultExpression = expression2.getResult();
        if (resultExpression instanceof FirWhenExpression && !ExhaustivenessStatusKt.isExhaustive((FirWhenExpression)resultExpression)) {
            return;
        }
        ConeKotlinType functionReturnType = targetElement instanceof FirConstructor ? FirTypeUtilsKt.getConeType(context.getSession().getBuiltinTypes().getUnitType()) : FirTypeUtilsKt.getConeType(targetElement.getReturnTypeRef());
        ConeInferenceContext typeContext2 = TypeComponentsKt.getTypeContext(context.getSession());
        FirTypeRef $this$coneTypeSafe$iv = resultExpression.getTypeRef();
        boolean $i$f$coneTypeSafe = false;
        FirResolvedTypeRef firResolvedTypeRef = $this$coneTypeSafe$iv instanceof FirResolvedTypeRef ? (FirResolvedTypeRef)$this$coneTypeSafe$iv : null;
        ConeKotlinType coneKotlinType = firResolvedTypeRef != null ? firResolvedTypeRef.getType() : null;
        if (!(coneKotlinType instanceof ConeKotlinType)) {
            coneKotlinType = null;
        }
        if (coneKotlinType == null) {
            return;
        }
        ConeKotlinType returnExpressionType = coneKotlinType;
        if (!FirHelpersKt.isSubtypeForTypeMismatch(typeContext2, returnExpressionType, functionReturnType)) {
            if (FirTypeUtilsKt.isNullLiteral(resultExpression) && functionReturnType.getNullability() == ConeNullability.NOT_NULL) {
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)resultExpression.getSource(), FirErrors.INSTANCE.getNULL_FOR_NONNULL_TYPE(), (DiagnosticContext)context, null, 8, null);
            } else {
                boolean isDueToNullability = InferenceUtilsKt.isTypeMismatchDueToNullability(TypeComponentsKt.getTypeContext(context.getSession()), returnExpressionType, functionReturnType);
                if (resultExpression instanceof FirExpressionWithSmartcast && !((FirExpressionWithSmartcast)resultExpression).isStable() && FirHelpersKt.isSubtypeForTypeMismatch(typeContext2, FirTypeUtilsKt.getConeType(((FirExpressionWithSmartcast)resultExpression).getSmartcastType()), functionReturnType)) {
                    KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)resultExpression.getSource(), FirErrors.INSTANCE.getSMARTCAST_IMPOSSIBLE(), (Object)functionReturnType, (Object)resultExpression, (Object)((FirExpressionWithSmartcast)resultExpression).getSmartcastStability().getDescription(), (Object)isDueToNullability, (DiagnosticContext)context, null, 128, null);
                } else {
                    KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)resultExpression.getSource(), FirErrors.INSTANCE.getRETURN_TYPE_MISMATCH(), (Object)functionReturnType, (Object)returnExpressionType, (Object)targetElement, (Object)isDueToNullability, (DiagnosticContext)context, null, 128, null);
                }
            }
        }
    }
}

