/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.common.lower;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.BackendContext;
import org.jetbrains.kotlin.backend.common.DeclarationTransformer;
import org.jetbrains.kotlin.backend.common.lower.DeclarationIrBuilder;
import org.jetbrains.kotlin.backend.common.lower.InnerClassesLoweringKt;
import org.jetbrains.kotlin.backend.common.lower.InnerClassesSupport;
import org.jetbrains.kotlin.backend.common.lower.LowerUtilsKt;
import org.jetbrains.kotlin.backend.common.lower.VariableRemapper;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.IrStatement;
import org.jetbrains.kotlin.ir.builders.ExpressionHelpersKt;
import org.jetbrains.kotlin.ir.builders.IrBuilderWithScope;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrValueDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.declarations.PersistentApiKt;
import org.jetbrains.kotlin.ir.expressions.IrBlockBody;
import org.jetbrains.kotlin.ir.expressions.IrBody;
import org.jetbrains.kotlin.ir.expressions.IrDelegatingConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpressionBody;
import org.jetbrains.kotlin.ir.expressions.IrInstanceInitializerCall;
import org.jetbrains.kotlin.ir.expressions.impl.IrGetValueImpl;
import org.jetbrains.kotlin.ir.util.DumpIrTreeKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.util.PatchDeclarationParentsKt;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformer;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoidKt;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eH\u0002J\u0018\u0010\u0010\u001a\n\u0012\u0004\u0012\u00020\u0012\u0018\u00010\u00112\u0006\u0010\u0013\u001a\u00020\u0012H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/backend/common/lower/InnerClassesLowering;", "Lorg/jetbrains/kotlin/backend/common/DeclarationTransformer;", "context", "Lorg/jetbrains/kotlin/backend/common/BackendContext;", "innerClassesSupport", "Lorg/jetbrains/kotlin/backend/common/lower/InnerClassesSupport;", "(Lorg/jetbrains/kotlin/backend/common/BackendContext;Lorg/jetbrains/kotlin/backend/common/lower/InnerClassesSupport;)V", "getContext", "()Lorg/jetbrains/kotlin/backend/common/BackendContext;", "withLocalDeclarations", "", "getWithLocalDeclarations", "()Z", "lowerConstructor", "Lorg/jetbrains/kotlin/ir/declarations/IrConstructor;", "irConstructor", "transformFlat", "", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "declaration", "ir.backend.common"})
public final class InnerClassesLowering
implements DeclarationTransformer {
    @NotNull
    private final BackendContext context;
    @NotNull
    private final InnerClassesSupport innerClassesSupport;

    public InnerClassesLowering(@NotNull BackendContext context2, @NotNull InnerClassesSupport innerClassesSupport) {
        Intrinsics.checkNotNullParameter(context2, "context");
        Intrinsics.checkNotNullParameter(innerClassesSupport, "innerClassesSupport");
        this.context = context2;
        this.innerClassesSupport = innerClassesSupport;
    }

    @NotNull
    public final BackendContext getContext() {
        return this.context;
    }

    @Override
    public boolean getWithLocalDeclarations() {
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public List<IrDeclaration> transformFlat(@NotNull IrDeclaration declaration2) {
        Intrinsics.checkNotNullParameter(declaration2, "declaration");
        if (declaration2 instanceof IrClass && ((IrClass)declaration2).isInner()) {
            PersistentApiKt.getStageController().unrestrictDeclarationListsAccess((Function0)new Function0<Unit>(declaration2, this){
                final /* synthetic */ IrDeclaration $declaration;
                final /* synthetic */ InnerClassesLowering this$0;
                {
                    this.$declaration = $declaration;
                    this.this$0 = $receiver;
                    super(0);
                }

                public final void invoke() {
                    IrDeclaration irDeclaration2 = this.$declaration;
                    Collection collection = ((IrClass)irDeclaration2).getDeclarations();
                    IrField irField = InnerClassesLowering.access$getInnerClassesSupport$p(this.this$0).getOuterThisField((IrClass)this.$declaration);
                    boolean bl = false;
                    collection.add(irField);
                }
            });
        } else if (declaration2 instanceof IrConstructor) {
            IrClass irClass2 = IrUtilsKt.getParentAsClass(declaration2);
            if (!irClass2.isInner()) {
                return null;
            }
            IrConstructor newConstructor2 = this.lowerConstructor((IrConstructor)declaration2);
            Map oldConstructorParameterToNew = InnerClassesLoweringKt.access$primaryConstructorParameterMap(this.innerClassesSupport, (IrConstructor)declaration2);
            VariableRemapper variableRemapper = new VariableRemapper(oldConstructorParameterToNew);
            Iterator iterator2 = oldConstructorParameterToNew.entrySet().iterator();
            while (iterator2.hasNext()) {
                IrExpressionBody irExpressionBody;
                IrValueParameter newParam;
                Map.Entry entry;
                Map.Entry entry2 = entry = iterator2.next();
                boolean bl = false;
                IrValueParameter oldParam = (IrValueParameter)entry2.getKey();
                Object object = entry;
                boolean bl2 = false;
                IrValueParameter irValueParameter = newParam = (IrValueParameter)object.getValue();
                object = oldParam.getDefaultValue();
                if (object == null) {
                    irExpressionBody = null;
                } else {
                    void oldDefault;
                    Object object2 = object;
                    boolean bl3 = false;
                    boolean bl4 = false;
                    Object object3 = object2;
                    IrValueParameter irValueParameter2 = irValueParameter;
                    boolean bl5 = false;
                    IrExpressionBody irExpressionBody2 = this.getContext().getIrFactory().createExpressionBody(oldDefault.getStartOffset(), oldDefault.getEndOffset(), (Function1<? super IrExpressionBody, Unit>)new Function1<IrExpressionBody, Unit>((IrExpressionBody)oldDefault, variableRemapper, newConstructor2){
                        final /* synthetic */ IrExpressionBody $oldDefault;
                        final /* synthetic */ VariableRemapper $variableRemapper;
                        final /* synthetic */ IrConstructor $newConstructor;
                        {
                            this.$oldDefault = $oldDefault;
                            this.$variableRemapper = $variableRemapper;
                            this.$newConstructor = $newConstructor;
                            super(1);
                        }

                        public final void invoke(@NotNull IrExpressionBody irExpressionBody) {
                            Intrinsics.checkNotNullParameter(irExpressionBody, "<this>");
                            irExpressionBody.setExpression((IrExpression)PatchDeclarationParentsKt.patchDeclarationParents(this.$oldDefault.getExpression().transform((IrElementTransformer)this.$variableRemapper, (Object)null), this.$newConstructor));
                        }
                    });
                    irValueParameter = irValueParameter2;
                    irExpressionBody = irExpressionBody2;
                }
                irValueParameter.setDefaultValue(irExpressionBody);
            }
            return CollectionsKt.listOf(newConstructor2);
        }
        return null;
    }

    private final IrConstructor lowerConstructor(IrConstructor irConstructor2) {
        IrBlockBody irBlockBody;
        IrConstructor loweredConstructor = this.innerClassesSupport.getInnerClassConstructorWithOuterThisParameter(irConstructor2);
        IrValueParameter outerThisParameter = loweredConstructor.getValueParameters().get(0);
        IrClass irClass2 = IrUtilsKt.getParentAsClass(irConstructor2);
        IrField parentThisField = this.innerClassesSupport.getOuterThisField(irClass2);
        IrBody irBody = irConstructor2.getBody();
        IrBlockBody irBlockBody2 = irBlockBody = irBody instanceof IrBlockBody ? (IrBlockBody)irBody : null;
        if (irBlockBody == null) {
            throw new AssertionError((Object)Intrinsics.stringPlus("Unexpected constructor body: ", irConstructor2.getBody()));
        }
        IrBlockBody blockBody = irBlockBody;
        loweredConstructor.setBody(this.context.getIrFactory().createBlockBody(blockBody.getStartOffset(), blockBody.getEndOffset(), (Function1<? super IrBlockBody, Unit>)new Function1<IrBlockBody, Unit>(this, irConstructor2, blockBody, loweredConstructor, irClass2, parentThisField, outerThisParameter){
            final /* synthetic */ InnerClassesLowering this$0;
            final /* synthetic */ IrConstructor $irConstructor;
            final /* synthetic */ IrBlockBody $blockBody;
            final /* synthetic */ IrConstructor $loweredConstructor;
            final /* synthetic */ IrClass $irClass;
            final /* synthetic */ IrField $parentThisField;
            final /* synthetic */ IrValueParameter $outerThisParameter;
            {
                this.this$0 = $receiver;
                this.$irConstructor = $irConstructor;
                this.$blockBody = $blockBody;
                this.$loweredConstructor = $loweredConstructor;
                this.$irClass = $irClass;
                this.$parentThisField = $parentThisField;
                this.$outerThisParameter = $outerThisParameter;
                super(1);
            }

            public final void invoke(@NotNull IrBlockBody irBlockBody) {
                Object v3;
                Object it;
                Object object;
                boolean bl;
                Object object2;
                block4: {
                    Intrinsics.checkNotNullParameter(irBlockBody, "<this>");
                    Object object3 = LowerUtilsKt.createIrBuilder(this.this$0.getContext(), this.$irConstructor.getSymbol(), this.$irConstructor.getStartOffset(), this.$irConstructor.getEndOffset());
                    IrClass irClass2 = this.$irClass;
                    object2 = this.$parentThisField;
                    IrValueParameter irValueParameter = this.$outerThisParameter;
                    boolean bl2 = false;
                    boolean bl3 = false;
                    DeclarationIrBuilder $this$invoke_u24lambda_u2d0 = object3;
                    boolean bl4 = false;
                    List<IrStatement> list2 = irBlockBody.getStatements();
                    IrBuilderWithScope irBuilderWithScope = $this$invoke_u24lambda_u2d0;
                    IrBuilderWithScope irBuilderWithScope2 = $this$invoke_u24lambda_u2d0;
                    IrValueParameter irValueParameter2 = irClass2.getThisReceiver();
                    Intrinsics.checkNotNull(irValueParameter2);
                    list2.add(0, ExpressionHelpersKt.irSetField(irBuilderWithScope, ExpressionHelpersKt.irGet(irBuilderWithScope2, irValueParameter2), (IrField)object2, ExpressionHelpersKt.irGet($this$invoke_u24lambda_u2d0, irValueParameter)));
                    irBlockBody.getStatements().addAll((Collection<IrStatement>)this.$blockBody.getStatements());
                    object3 = irBlockBody.getStatements();
                    boolean bl5 = false;
                    object2 = object3;
                    bl = false;
                    object = object2.iterator();
                    while (object.hasNext()) {
                        T t = object.next();
                        it = (IrStatement)t;
                        boolean bl6 = false;
                        if (!(it instanceof IrInstanceInitializerCall)) continue;
                        v3 = t;
                        break block4;
                    }
                    v3 = null;
                }
                if (v3 == null) {
                    IrDelegatingConstructorCall delegatingConstructorCall;
                    Object v4;
                    block5: {
                        object2 = irBlockBody.getStatements();
                        bl = false;
                        object = object2;
                        boolean bl7 = false;
                        it = object.iterator();
                        while (it.hasNext()) {
                            E e = it.next();
                            IrStatement it2 = (IrStatement)e;
                            boolean bl8 = false;
                            if (!(it2 instanceof IrDelegatingConstructorCall)) continue;
                            v4 = e;
                            break block5;
                        }
                        v4 = null;
                    }
                    IrDelegatingConstructorCall irDelegatingConstructorCall = v4;
                    if (irDelegatingConstructorCall == null) {
                        throw new AssertionError((Object)Intrinsics.stringPlus("Delegating constructor call expected: ", DumpIrTreeKt.dump$default(this.$irConstructor, false, 1, null)));
                    }
                    irDelegatingConstructorCall = delegatingConstructorCall = irDelegatingConstructorCall;
                    object2 = this.$outerThisParameter;
                    bl = false;
                    boolean bl9 = false;
                    IrDelegatingConstructorCall $this$invoke_u24lambda_u2d3 = irDelegatingConstructorCall;
                    boolean bl10 = false;
                    $this$invoke_u24lambda_u2d3.setDispatchReceiver(new IrGetValueImpl($this$invoke_u24lambda_u2d3.getStartOffset(), $this$invoke_u24lambda_u2d3.getEndOffset(), ((IrValueDeclaration)object2).getSymbol(), null, 8, null));
                }
                PatchDeclarationParentsKt.patchDeclarationParents((IrElement)irBlockBody, this.$loweredConstructor);
                Map oldConstructorParameterToNew = InnerClassesLoweringKt.access$primaryConstructorParameterMap(InnerClassesLowering.access$getInnerClassesSupport$p(this.this$0), this.$irConstructor);
                IrElementTransformerVoidKt.transformChildrenVoid(irBlockBody, new VariableRemapper(oldConstructorParameterToNew));
            }
        }));
        return loweredConstructor;
    }

    @Override
    public void lower(@NotNull IrFile irFile) {
        DeclarationTransformer.DefaultImpls.lower(this, irFile);
    }

    public static final /* synthetic */ InnerClassesSupport access$getInnerClassesSupport$p(InnerClassesLowering $this) {
        return $this.innerClassesSupport;
    }
}

