/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.doubles;

import it.unimi.dsi.fastutil.Arrays;
import it.unimi.dsi.fastutil.Hash;
import it.unimi.dsi.fastutil.doubles.DoubleComparator;
import java.io.Serializable;

public final class DoubleArrays {
    public static final double[] EMPTY_ARRAY = new double[0];
    public static final double[] DEFAULT_EMPTY_ARRAY = new double[0];
    protected static final Segment POISON_PILL = new Segment(-1, -1, -1);
    public static final Hash.Strategy<double[]> HASH_STRATEGY = new ArrayHashStrategy();

    public static void ensureOffsetLength(double[] a, int offset2, int length) {
        Arrays.ensureOffsetLength(a.length, offset2, length);
    }

    private static void insertionSort(double[] a, int from, int to, DoubleComparator comp2) {
        int i = from;
        while (++i < to) {
            double t = a[i];
            int j = i;
            double u = a[j - 1];
            while (comp2.compare(t, u) < 0) {
                a[j] = u;
                if (from == j - 1) {
                    --j;
                    break;
                }
                u = a[--j - 1];
            }
            a[j] = t;
        }
    }

    private static void insertionSort(double[] a, int from, int to) {
        int i = from;
        while (++i < to) {
            double t = a[i];
            int j = i;
            double u = a[j - 1];
            while (Double.compare(t, u) < 0) {
                a[j] = u;
                if (from == j - 1) {
                    --j;
                    break;
                }
                u = a[--j - 1];
            }
            a[j] = t;
        }
    }

    public static void mergeSort(double[] a, int from, int to, double[] supp) {
        int len = to - from;
        if (len < 16) {
            DoubleArrays.insertionSort(a, from, to);
            return;
        }
        int mid = from + to >>> 1;
        DoubleArrays.mergeSort(supp, from, mid, a);
        DoubleArrays.mergeSort(supp, mid, to, a);
        if (Double.compare(supp[mid - 1], supp[mid]) <= 0) {
            System.arraycopy(supp, from, a, from, len);
            return;
        }
        int p = from;
        int q = mid;
        for (int i = from; i < to; ++i) {
            a[i] = q >= to || p < mid && Double.compare(supp[p], supp[q]) <= 0 ? supp[p++] : supp[q++];
        }
    }

    public static void mergeSort(double[] a, int from, int to) {
        DoubleArrays.mergeSort(a, from, to, (double[])a.clone());
    }

    public static void mergeSort(double[] a, int from, int to, DoubleComparator comp2, double[] supp) {
        int len = to - from;
        if (len < 16) {
            DoubleArrays.insertionSort(a, from, to, comp2);
            return;
        }
        int mid = from + to >>> 1;
        DoubleArrays.mergeSort(supp, from, mid, comp2, a);
        DoubleArrays.mergeSort(supp, mid, to, comp2, a);
        if (comp2.compare(supp[mid - 1], supp[mid]) <= 0) {
            System.arraycopy(supp, from, a, from, len);
            return;
        }
        int p = from;
        int q = mid;
        for (int i = from; i < to; ++i) {
            a[i] = q >= to || p < mid && comp2.compare(supp[p], supp[q]) <= 0 ? supp[p++] : supp[q++];
        }
    }

    public static void mergeSort(double[] a, int from, int to, DoubleComparator comp2) {
        DoubleArrays.mergeSort(a, from, to, comp2, (double[])a.clone());
    }

    public static void stableSort(double[] a, int from, int to) {
        DoubleArrays.mergeSort(a, from, to);
    }

    public static void stableSort(double[] a) {
        DoubleArrays.stableSort(a, 0, a.length);
    }

    public static void stableSort(double[] a, int from, int to, DoubleComparator comp2) {
        DoubleArrays.mergeSort(a, from, to, comp2);
    }

    public static void stableSort(double[] a, DoubleComparator comp2) {
        DoubleArrays.stableSort(a, 0, a.length, comp2);
    }

    protected static final class Segment {
        protected final int offset;
        protected final int length;
        protected final int level;

        protected Segment(int offset2, int length, int level) {
            this.offset = offset2;
            this.length = length;
            this.level = level;
        }

        public String toString() {
            return "Segment [offset=" + this.offset + ", length=" + this.length + ", level=" + this.level + "]";
        }
    }

    private static final class ArrayHashStrategy
    implements Hash.Strategy<double[]>,
    Serializable {
        private static final long serialVersionUID = -7046029254386353129L;

        private ArrayHashStrategy() {
        }

        @Override
        public int hashCode(double[] o) {
            return java.util.Arrays.hashCode(o);
        }

        @Override
        public boolean equals(double[] a, double[] b) {
            return java.util.Arrays.equals(a, b);
        }
    }
}

