/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.mainKts.relocatedDeps.org.apache.ivy.ant;

import java.io.File;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;
import org.jetbrains.kotlin.mainKts.relocatedDeps.org.apache.ivy.ant.IvyCacheTask;
import org.jetbrains.kotlin.mainKts.relocatedDeps.org.apache.ivy.core.report.ArtifactDownloadReport;
import org.jetbrains.kotlin.mainKts.relocatedDeps.org.apache.tools.ant.BuildException;
import org.jetbrains.kotlin.mainKts.relocatedDeps.org.apache.tools.ant.DirectoryScanner;
import org.jetbrains.kotlin.mainKts.relocatedDeps.org.apache.tools.ant.Project;
import org.jetbrains.kotlin.mainKts.relocatedDeps.org.apache.tools.ant.types.FileSet;
import org.jetbrains.kotlin.mainKts.relocatedDeps.org.apache.tools.ant.types.PatternSet;
import org.jetbrains.kotlin.mainKts.relocatedDeps.org.apache.tools.ant.types.Resource;

public class IvyCacheFileset
extends IvyCacheTask {
    private String setid;

    public String getSetid() {
        return this.setid;
    }

    public void setSetid(String id) {
        this.setid = id;
    }

    @Override
    public void setUseOrigin(boolean useOrigin) {
        if (useOrigin) {
            throw new UnsupportedOperationException("the cachefileset task does not support the useOrigin mode, since filesets require to have only one root directory. Please use the the cachepath task instead");
        }
    }

    @Override
    public void doExecute() throws BuildException {
        this.prepareAndCheck();
        if (this.setid == null) {
            throw new BuildException("setid is required in ivy cachefileset");
        }
        try {
            List<ArtifactDownloadReport> artifactDownloadReports = this.getArtifactReports();
            if (artifactDownloadReports.isEmpty()) {
                EmptyFileSet emptyFileSet = new EmptyFileSet();
                emptyFileSet.setProject(this.getProject());
                this.getProject().addReference(this.setid, (Object)emptyFileSet);
                return;
            }
            File baseDir = this.requireCommonBaseDir(artifactDownloadReports);
            FileSet fileset = new FileSet();
            fileset.setDir(baseDir);
            fileset.setProject(this.getProject());
            for (ArtifactDownloadReport artifactDownloadReport : artifactDownloadReports) {
                if (artifactDownloadReport.getLocalFile() == null) continue;
                PatternSet.NameEntry ne = fileset.createInclude();
                ne.setName(this.getPath(baseDir, artifactDownloadReport.getLocalFile()));
            }
            this.getProject().addReference(this.setid, (Object)fileset);
        }
        catch (Exception ex) {
            throw new BuildException("impossible to build ivy cache fileset: " + ex, (Throwable)ex);
        }
    }

    File requireCommonBaseDir(List<ArtifactDownloadReport> artifactDownloadReports) {
        File base = null;
        for (ArtifactDownloadReport artifactDownloadReport : artifactDownloadReports) {
            if (artifactDownloadReport.getLocalFile() == null) continue;
            if (base == null) {
                base = artifactDownloadReport.getLocalFile().getParentFile().getAbsoluteFile();
                continue;
            }
            if ((base = this.getBaseDir(base, artifactDownloadReport.getLocalFile())) != null) continue;
            throw new BuildException("Cannot find a common base directory, from resolved artifacts, for generating a cache fileset");
        }
        if (base == null) {
            throw new BuildException("Cannot find a common base directory, from resolved artifacts, for generating a cache fileset");
        }
        return base;
    }

    private String getPath(File base, File file) {
        String absoluteBasePath = base.getAbsolutePath();
        int beginIndex = absoluteBasePath.length();
        if (!absoluteBasePath.endsWith(File.separator)) {
            ++beginIndex;
        }
        return file.getAbsolutePath().substring(beginIndex);
    }

    File getBaseDir(File file1, File file2) {
        File next;
        if (file1 == null || file2 == null) {
            return null;
        }
        Iterator file1Parents = this.getParents(file1).iterator();
        Iterator file2Parents = this.getParents(file2.getAbsoluteFile()).iterator();
        File result = null;
        while (file1Parents.hasNext() && file2Parents.hasNext() && (next = (File)file1Parents.next()).equals(file2Parents.next())) {
            result = next;
        }
        return result;
    }

    private LinkedList<File> getParents(File file) {
        LinkedList<File> r = new LinkedList<File>();
        while (file != null) {
            r.addFirst(file);
            file = file.getParentFile();
        }
        return r;
    }

    private static class EmptyDirectoryScanner
    extends DirectoryScanner {
        private EmptyDirectoryScanner() {
        }

        public String[] getIncludedFiles() {
            return new String[0];
        }
    }

    private static class EmptyIterator<T>
    implements Iterator<T> {
        private EmptyIterator() {
        }

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public T next() {
            throw new NoSuchElementException("EmptyFileSet Iterator");
        }

        @Override
        public void remove() {
            throw new IllegalStateException("EmptyFileSet Iterator");
        }
    }

    private static class EmptyFileSet
    extends FileSet {
        private DirectoryScanner ds = new EmptyDirectoryScanner();

        private EmptyFileSet() {
        }

        public Iterator<Resource> iterator() {
            return new EmptyIterator<Resource>();
        }

        public Object clone() {
            return new EmptyFileSet();
        }

        public int size() {
            return 0;
        }

        public DirectoryScanner getDirectoryScanner(Project project) {
            return this.ds;
        }
    }
}

