/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.scope.processor;

import com.intellij.openapi.util.Key;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.ResolveState;
import com.intellij.psi.filters.ElementFilter;
import com.intellij.psi.infos.CandidateInfo;
import com.intellij.psi.scope.JavaScopeProcessorEvent;
import com.intellij.psi.scope.NameHint;
import com.intellij.psi.scope.PsiConflictResolver;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.scope.processor.FilterScopeProcessor;
import com.intellij.psi.util.PsiUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class ConflictFilterProcessor
extends FilterScopeProcessor<CandidateInfo>
implements NameHint {
    private final PsiConflictResolver[] myResolvers;
    private JavaResolveResult[] myCachedResult;
    protected String myName;
    protected final PsiElement myPlace;
    protected final PsiFile myPlaceFile;

    public ConflictFilterProcessor(String name, @NotNull ElementFilter filter2, @NotNull PsiConflictResolver[] resolvers, @NotNull List<CandidateInfo> container, @NotNull PsiElement place, PsiFile placeFile) {
        if (filter2 == null) {
            ConflictFilterProcessor.$$$reportNull$$$0(0);
        }
        if (resolvers == null) {
            ConflictFilterProcessor.$$$reportNull$$$0(1);
        }
        if (container == null) {
            ConflictFilterProcessor.$$$reportNull$$$0(2);
        }
        if (place == null) {
            ConflictFilterProcessor.$$$reportNull$$$0(3);
        }
        super(filter2, container);
        this.myResolvers = resolvers;
        this.myName = name;
        this.myPlace = place;
        this.myPlaceFile = placeFile;
    }

    @Override
    public boolean execute(@NotNull PsiElement element, @NotNull ResolveState state) {
        JavaResolveResult[] cachedResult;
        if (element == null) {
            ConflictFilterProcessor.$$$reportNull$$$0(4);
        }
        if (state == null) {
            ConflictFilterProcessor.$$$reportNull$$$0(5);
        }
        if ((cachedResult = this.myCachedResult) != null && cachedResult.length == 1 && this.stopAtFoundResult(cachedResult[0])) {
            return false;
        }
        if (this.myName == null || PsiUtil.checkName(element, this.myName, this.myPlace)) {
            return super.execute(element, state);
        }
        return true;
    }

    protected boolean stopAtFoundResult(JavaResolveResult cachedResult) {
        return cachedResult.isAccessible();
    }

    @Override
    protected void add(@NotNull PsiElement element, @NotNull PsiSubstitutor substitutor2) {
        if (element == null) {
            ConflictFilterProcessor.$$$reportNull$$$0(6);
        }
        if (substitutor2 == null) {
            ConflictFilterProcessor.$$$reportNull$$$0(7);
        }
        this.add(new CandidateInfo(element, substitutor2));
    }

    protected void add(CandidateInfo info2) {
        this.myCachedResult = null;
        this.myResults.add(info2);
    }

    @Override
    public void handleEvent(@NotNull PsiScopeProcessor.Event event, Object associated) {
        if (event == null) {
            ConflictFilterProcessor.$$$reportNull$$$0(8);
        }
        if (event == JavaScopeProcessorEvent.CHANGE_LEVEL && this.myName != null) {
            this.getResult();
        }
    }

    @NotNull
    public JavaResolveResult[] getResult() {
        JavaResolveResult[] cachedResult = this.myCachedResult;
        if (cachedResult == null) {
            List<CandidateInfo> conflicts = this.getResults();
            if (!conflicts.isEmpty()) {
                for (PsiConflictResolver resolver2 : this.myResolvers) {
                    CandidateInfo candidate2 = resolver2.resolveConflict(conflicts);
                    if (candidate2 == null) continue;
                    conflicts.clear();
                    conflicts.add(candidate2);
                    break;
                }
            }
            cachedResult = conflicts.toArray(JavaResolveResult.EMPTY_ARRAY);
            this.myCachedResult = cachedResult;
        }
        if (cachedResult == null) {
            ConflictFilterProcessor.$$$reportNull$$$0(9);
        }
        return cachedResult;
    }

    @Override
    public String getName(@NotNull ResolveState state) {
        if (state == null) {
            ConflictFilterProcessor.$$$reportNull$$$0(10);
        }
        return this.myName;
    }

    public void setName(String name) {
        this.myName = name;
    }

    @Override
    public <T> T getHint(@NotNull Key<T> hintKey) {
        if (hintKey == null) {
            ConflictFilterProcessor.$$$reportNull$$$0(11);
        }
        if (hintKey == NameHint.KEY) {
            return (T)(this.myName != null ? this : null);
        }
        return super.getHint(hintKey);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolvers";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "container";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 5: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "substitutor";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/scope/processor/ConflictFilterProcessor";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hintKey";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/scope/processor/ConflictFilterProcessor";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getResult";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "execute";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "add";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "handleEvent";
                break;
            }
            case 9: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getName";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getHint";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

