/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.types.checker;

import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.renderer.DescriptorRenderer;
import org.jetbrains.kotlin.resolve.calls.inference.CapturedTypeConstructorKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeConstructor;
import org.jetbrains.kotlin.types.TypeConstructorSubstitution;
import org.jetbrains.kotlin.types.TypeProjection;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.Variance;
import org.jetbrains.kotlin.types.checker.SubtypePathNode;
import org.jetbrains.kotlin.types.checker.TypeCheckerProcedureCallbacksImpl;
import org.jetbrains.kotlin.types.checker.TypeCheckingProcedureCallbacks;
import org.jetbrains.kotlin.types.typesApproximation.CapturedTypeApproximationKt;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=2, d1={"\u0000\u001c\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\u001a\"\u0010\u0000\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u001a\f\u0010\u0006\u001a\u00020\u0001*\u00020\u0001H\u0002\u001a\f\u0010\u0007\u001a\u00020\b*\u00020\tH\u0002\u00a8\u0006\n"}, d2={"findCorrespondingSupertype", "Lorg/jetbrains/kotlin/types/KotlinType;", "subtype", "supertype", "typeCheckingProcedureCallbacks", "Lorg/jetbrains/kotlin/types/checker/TypeCheckingProcedureCallbacks;", "approximate", "debugInfo", "", "Lorg/jetbrains/kotlin/types/TypeConstructor;", "descriptors"})
public final class UtilsKt {
    @Nullable
    public static final KotlinType findCorrespondingSupertype(@NotNull KotlinType subtype, @NotNull KotlinType supertype, @NotNull TypeCheckingProcedureCallbacks typeCheckingProcedureCallbacks) {
        Intrinsics.checkParameterIsNotNull(subtype, "subtype");
        Intrinsics.checkParameterIsNotNull(supertype, "supertype");
        Intrinsics.checkParameterIsNotNull(typeCheckingProcedureCallbacks, "typeCheckingProcedureCallbacks");
        ArrayDeque<SubtypePathNode> queue = new ArrayDeque<SubtypePathNode>();
        queue.add(new SubtypePathNode(subtype, null));
        TypeConstructor supertypeConstructor = supertype.getConstructor();
        while (!queue.isEmpty()) {
            SubtypePathNode lastPathNode = (SubtypePathNode)queue.poll();
            KotlinType currentSubtype = lastPathNode.getType();
            TypeConstructor constructor2 = currentSubtype.getConstructor();
            if (typeCheckingProcedureCallbacks.assertEqualTypeConstructors(constructor2, supertypeConstructor)) {
                KotlinType substituted = currentSubtype;
                boolean isAnyMarkedNullable = currentSubtype.isMarkedNullable();
                for (SubtypePathNode currentPathNode = lastPathNode.getPrevious(); currentPathNode != null; currentPathNode = currentPathNode.getPrevious()) {
                    KotlinType kotlinType2;
                    boolean bl;
                    KotlinType currentType;
                    block10: {
                        currentType = currentPathNode.getType();
                        Iterable $this$any$iv = currentType.getArguments();
                        boolean $i$f$any = false;
                        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                            bl = false;
                        } else {
                            for (Object element$iv : $this$any$iv) {
                                TypeProjection it = (TypeProjection)element$iv;
                                boolean bl2 = false;
                                if (!(it.getProjectionKind() != Variance.INVARIANT)) continue;
                                bl = true;
                                break block10;
                            }
                            bl = false;
                        }
                    }
                    if (bl) {
                        KotlinType kotlinType3 = CapturedTypeConstructorKt.wrapWithCapturingSubstitution$default(TypeConstructorSubstitution.Companion.create(currentType), false, 1, null).buildSubstitutor().safeSubstitute(substituted, Variance.INVARIANT);
                        Intrinsics.checkExpressionValueIsNotNull(kotlinType3, "TypeConstructorSubstitut\u2026uted, Variance.INVARIANT)");
                        kotlinType2 = UtilsKt.approximate(kotlinType3);
                    } else {
                        KotlinType kotlinType4 = TypeConstructorSubstitution.Companion.create(currentType).buildSubstitutor().safeSubstitute(substituted, Variance.INVARIANT);
                        kotlinType2 = kotlinType4;
                        Intrinsics.checkExpressionValueIsNotNull(kotlinType4, "TypeConstructorSubstitut\u2026uted, Variance.INVARIANT)");
                    }
                    substituted = kotlinType2;
                    isAnyMarkedNullable = isAnyMarkedNullable || currentType.isMarkedNullable();
                }
                TypeConstructor substitutedConstructor = substituted.getConstructor();
                if (!typeCheckingProcedureCallbacks.assertEqualTypeConstructors(substitutedConstructor, supertypeConstructor)) {
                    throw (Throwable)((Object)new AssertionError((Object)("Type constructors should be equals!\n" + "substitutedSuperType: " + UtilsKt.debugInfo(substitutedConstructor) + ", \n\n" + "supertype: " + UtilsKt.debugInfo(supertypeConstructor) + " \n" + typeCheckingProcedureCallbacks.assertEqualTypeConstructors(substitutedConstructor, supertypeConstructor))));
                }
                return TypeUtils.makeNullableAsSpecified(substituted, isAnyMarkedNullable);
            }
            Iterator<KotlinType> iterator2 = constructor2.getSupertypes().iterator();
            while (iterator2.hasNext()) {
                KotlinType immediateSupertype;
                KotlinType kotlinType5 = immediateSupertype = iterator2.next();
                Intrinsics.checkExpressionValueIsNotNull(kotlinType5, "immediateSupertype");
                queue.add(new SubtypePathNode(kotlinType5, lastPathNode));
            }
        }
        return null;
    }

    public static /* synthetic */ KotlinType findCorrespondingSupertype$default(KotlinType kotlinType2, KotlinType kotlinType3, TypeCheckingProcedureCallbacks typeCheckingProcedureCallbacks, int n, Object object) {
        if ((n & 4) != 0) {
            typeCheckingProcedureCallbacks = new TypeCheckerProcedureCallbacksImpl();
        }
        return UtilsKt.findCorrespondingSupertype(kotlinType2, kotlinType3, typeCheckingProcedureCallbacks);
    }

    private static final KotlinType approximate(@NotNull KotlinType $this$approximate) {
        return CapturedTypeApproximationKt.approximateCapturedTypes($this$approximate).getUpper();
    }

    private static final String debugInfo(@NotNull TypeConstructor $this$debugInfo) {
        boolean bl = false;
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl2 = false;
        boolean bl3 = false;
        StringBuilder $this$buildString = stringBuilder;
        boolean bl4 = false;
        Function1<String, StringBuilder> $fun$unaryPlus$1 = new Function1<String, StringBuilder>($this$buildString){
            final /* synthetic */ StringBuilder $this_buildString;

            @NotNull
            public final StringBuilder invoke(@NotNull String $this$unaryPlus) {
                Intrinsics.checkParameterIsNotNull($this$unaryPlus, "$this$unaryPlus");
                StringBuilder stringBuilder = this.$this_buildString;
                boolean bl = false;
                StringBuilder stringBuilder2 = stringBuilder.append($this$unaryPlus);
                Intrinsics.checkExpressionValueIsNotNull(stringBuilder2, "append(value)");
                return StringsKt.appendln(stringBuilder2);
            }
            {
                this.$this_buildString = stringBuilder;
                super(1);
            }
        };
        $fun$unaryPlus$1.invoke("type: " + $this$debugInfo);
        $fun$unaryPlus$1.invoke("hashCode: " + $this$debugInfo.hashCode());
        $fun$unaryPlus$1.invoke("javaClass: " + $this$debugInfo.getClass().getCanonicalName());
        for (DeclarationDescriptor declarationDescriptor = (DeclarationDescriptor)$this$debugInfo.getDeclarationDescriptor(); declarationDescriptor != null; declarationDescriptor = declarationDescriptor.getContainingDeclaration()) {
            $fun$unaryPlus$1.invoke("fqName: " + DescriptorRenderer.FQ_NAMES_IN_TYPES.render(declarationDescriptor));
            $fun$unaryPlus$1.invoke("javaClass: " + declarationDescriptor.getClass().getCanonicalName());
        }
        String string = stringBuilder.toString();
        Intrinsics.checkExpressionValueIsNotNull(string, "StringBuilder().apply(builderAction).toString()");
        return string;
    }
}

