/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.contracts.parsing;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.config.AnalysisFlags;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.contracts.description.ContractDescription;
import org.jetbrains.kotlin.contracts.description.ContractProviderKey;
import org.jetbrains.kotlin.contracts.description.LazyContractProvider;
import org.jetbrains.kotlin.contracts.parsing.ContractCallContext;
import org.jetbrains.kotlin.contracts.parsing.ContractParsingDiagnosticsCollector;
import org.jetbrains.kotlin.contracts.parsing.PsiContractParserDispatcher;
import org.jetbrains.kotlin.contracts.parsing.PsiContractsUtilsKt;
import org.jetbrains.kotlin.contracts.parsing.TraceBasedCollector;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ModalityKt;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilKt;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.scopes.HierarchicalScope;
import org.jetbrains.kotlin.resolve.scopes.LexicalScope;
import org.jetbrains.kotlin.resolve.scopes.LexicalScopeKind;
import org.jetbrains.kotlin.storage.StorageManager;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J&\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017J\u0010\u0010\u0018\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0012\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\f\u0010\u001b\u001a\u00020\u0017*\u00020\u000eH\u0002J\u0014\u0010\u001b\u001a\u00020\u0017*\u00020\u00112\u0006\u0010\u001c\u001a\u00020\u001dH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lorg/jetbrains/kotlin/contracts/parsing/ContractParsingServices;", "", "languageVersionSettings", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "storageManager", "Lorg/jetbrains/kotlin/storage/StorageManager;", "(Lorg/jetbrains/kotlin/config/LanguageVersionSettings;Lorg/jetbrains/kotlin/storage/StorageManager;)V", "getLanguageVersionSettings", "()Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "checkContractAllowedHere", "", "collector", "Lorg/jetbrains/kotlin/contracts/parsing/ContractParsingDiagnosticsCollector;", "callContext", "Lorg/jetbrains/kotlin/contracts/parsing/ContractCallContext;", "checkContractAndRecordIfPresent", "expression", "Lorg/jetbrains/kotlin/psi/KtExpression;", "trace", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "scope", "Lorg/jetbrains/kotlin/resolve/scopes/LexicalScope;", "isFirstStatement", "", "checkFeatureEnabled", "parseContractAndReportErrors", "Lorg/jetbrains/kotlin/contracts/description/ContractDescription;", "isContractDescriptionCallPreciseCheck", "context", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "frontend"})
public final class ContractParsingServices {
    @NotNull
    private final LanguageVersionSettings languageVersionSettings;
    private final StorageManager storageManager;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void checkContractAndRecordIfPresent(@NotNull KtExpression expression2, @NotNull BindingTrace trace, @NotNull LexicalScope scope, boolean isFirstStatement) {
        Intrinsics.checkParameterIsNotNull(expression2, "expression");
        Intrinsics.checkParameterIsNotNull(trace, "trace");
        Intrinsics.checkParameterIsNotNull(scope, "scope");
        if (!KtPsiUtilKt.isContractDescriptionCallPsiCheck(expression2)) {
            return;
        }
        ContractCallContext callContext = new ContractCallContext(expression2, isFirstStatement, scope, trace);
        DeclarationDescriptor declarationDescriptor = scope.getOwnerDescriptor();
        if (!(declarationDescriptor instanceof FunctionDescriptor)) {
            declarationDescriptor = null;
        }
        FunctionDescriptor functionDescriptor = (FunctionDescriptor)declarationDescriptor;
        LazyContractProvider contractProviderIfAny = functionDescriptor != null ? (LazyContractProvider)functionDescriptor.getUserData(ContractProviderKey.INSTANCE) : null;
        ContractDescription resultingContractDescription = null;
        try {
            if (!this.isContractDescriptionCallPreciseCheck(callContext)) {
                return;
            }
            resultingContractDescription = this.parseContractAndReportErrors(callContext);
        }
        finally {
            LazyContractProvider lazyContractProvider = contractProviderIfAny;
            if (lazyContractProvider != null) {
                lazyContractProvider.setContractDescription(resultingContractDescription);
            }
        }
    }

    private final boolean isContractDescriptionCallPreciseCheck(@NotNull ContractCallContext $receiver) {
        return this.isContractDescriptionCallPreciseCheck($receiver.getContractCallExpression(), $receiver.getBindingContext());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final ContractDescription parseContractAndReportErrors(ContractCallContext callContext) {
        TraceBasedCollector collector2 = new TraceBasedCollector(callContext.getTrace(), callContext.getContractCallExpression());
        try {
            ContractDescription contractDescription;
            ContractDescription contractDescription2;
            this.checkFeatureEnabled(collector2);
            this.checkContractAllowedHere(collector2, callContext);
            if (collector2.hasErrors()) {
                ContractDescription contractDescription3 = null;
                return contractDescription3;
            }
            ContractDescription parsedContract = new PsiContractParserDispatcher(collector2, callContext, this.storageManager).parseContract();
            if (parsedContract == null) {
                collector2.addFallbackErrorIfNecessary();
            }
            ContractDescription contractDescription4 = parsedContract;
            if (contractDescription4 != null) {
                ContractDescription it = contractDescription2 = contractDescription4;
                contractDescription = !collector2.hasErrors() ? contractDescription2 : null;
            } else {
                contractDescription = null;
            }
            contractDescription2 = contractDescription;
            return contractDescription2;
        }
        finally {
            collector2.flushDiagnostics();
        }
    }

    private final void checkFeatureEnabled(ContractParsingDiagnosticsCollector collector2) {
        boolean isFeatureTurnedOn;
        boolean bl = isFeatureTurnedOn = this.languageVersionSettings.supportsFeature(LanguageFeature.AllowContractsForCustomFunctions) || this.languageVersionSettings.getFlag(AnalysisFlags.getAllowKotlinPackage()) != false;
        if (!isFeatureTurnedOn) {
            collector2.unsupportedFeature(this.languageVersionSettings);
        }
    }

    private final void checkContractAllowedHere(ContractParsingDiagnosticsCollector collector2, ContractCallContext callContext) {
        FunctionDescriptor functionDescriptor;
        block15: {
            block14: {
                DeclarationDescriptor declarationDescriptor = callContext.getOwnerDescriptor();
                if (!(declarationDescriptor instanceof FunctionDescriptor)) {
                    declarationDescriptor = null;
                }
                functionDescriptor = (FunctionDescriptor)declarationDescriptor;
                LexicalScope scope = callContext.getScope();
                if (!callContext.isFirstStatement()) {
                    collector2.contractNotAllowed("Contract should be the first statement");
                }
                if (functionDescriptor == null) {
                    collector2.contractNotAllowed("Contracts are allowed only for functions");
                }
                if (!(callContext.getOwnerDescriptor().getContainingDeclaration() instanceof PackageFragmentDescriptor) || scope.getKind() != LexicalScopeKind.CODE_BLOCK) break block14;
                HierarchicalScope hierarchicalScope = scope.getParent();
                if (!(hierarchicalScope instanceof LexicalScope)) {
                    hierarchicalScope = null;
                }
                LexicalScope lexicalScope = (LexicalScope)hierarchicalScope;
                if ((lexicalScope != null ? lexicalScope.getKind() : null) == LexicalScopeKind.FUNCTION_INNER_SCOPE) break block15;
            }
            collector2.contractNotAllowed("Contracts are allowed only for top-level functions");
        }
        FunctionDescriptor functionDescriptor2 = functionDescriptor;
        if (functionDescriptor2 != null) {
            if (functionDescriptor2.isOperator()) {
                collector2.contractNotAllowed("Contracts are not allowed for operator functions");
            }
        }
        FunctionDescriptor functionDescriptor3 = functionDescriptor;
        if (functionDescriptor3 != null) {
            if (functionDescriptor3.isSuspend()) {
                collector2.contractNotAllowed("Contracts are not allowed for suspend functions");
            }
        }
        FunctionDescriptor functionDescriptor4 = functionDescriptor;
        if (functionDescriptor4 != null) {
            if (ModalityKt.isOverridable(functionDescriptor4)) {
                collector2.contractNotAllowed("Contracts are not allowed for open functions");
            }
        }
    }

    private final boolean isContractDescriptionCallPreciseCheck(@NotNull KtExpression $receiver, BindingContext context) {
        ResolvedCall<? extends CallableDescriptor> resolvedCall2 = CallUtilKt.getResolvedCall($receiver, context);
        return resolvedCall2 != null && (resolvedCall2 = resolvedCall2.getResultingDescriptor()) != null ? PsiContractsUtilsKt.isContractCallDescriptor((DeclarationDescriptor)((Object)resolvedCall2)) : false;
    }

    @NotNull
    public final LanguageVersionSettings getLanguageVersionSettings() {
        return this.languageVersionSettings;
    }

    public ContractParsingServices(@NotNull LanguageVersionSettings languageVersionSettings, @NotNull StorageManager storageManager) {
        Intrinsics.checkParameterIsNotNull(languageVersionSettings, "languageVersionSettings");
        Intrinsics.checkParameterIsNotNull(storageManager, "storageManager");
        this.languageVersionSettings = languageVersionSettings;
        this.storageManager = storageManager;
    }
}

