/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.bindingContextUtil;

import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Collection;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.kotlin.psi.KtCallableDeclaration;
import org.jetbrains.kotlin.psi.KtDeclarationWithBody;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtNullableType;
import org.jetbrains.kotlin.psi.KtQualifiedExpression;
import org.jetbrains.kotlin.psi.KtReferenceExpression;
import org.jetbrains.kotlin.psi.KtReturnExpression;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtTypeElement;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.bindingContextUtil.BindingContextUtilsKt;
import org.jetbrains.kotlin.resolve.calls.context.ResolutionContext;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowInfo;
import org.jetbrains.kotlin.resolve.scopes.HierarchicalScope;
import org.jetbrains.kotlin.resolve.scopes.LexicalScope;
import org.jetbrains.kotlin.resolve.scopes.utils.ScopeUtilsKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.expressions.KotlinTypeInfo;
import org.jetbrains.kotlin.types.expressions.typeInfoFactory.TypeInfoFactoryKt;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;
import org.jetbrains.kotlin.util.slicedMap.ReadOnlySlice;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=2, d1={"\u0000j\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0014\u0010\u0000\u001a\u0004\u0018\u00010\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004\u001a\u0014\u0010\u0000\u001a\u0004\u0018\u00010\u0001*\u00020\u00052\u0006\u0010\u0003\u001a\u00020\u0004\u001a\u0012\u0010\u0006\u001a\u00020\u0007*\u00020\u00042\u0006\u0010\b\u001a\u00020\t\u001a\u0012\u0010\n\u001a\u00020\u0007*\u00020\u00042\u0006\u0010\b\u001a\u00020\t\u001a\u0018\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f*\u00020\u000e2\u0006\u0010\u0003\u001a\u00020\u0004\u001a\u0014\u0010\u000f\u001a\u0004\u0018\u00010\u0010*\u00020\u00112\u0006\u0010\u0003\u001a\u00020\u0004\u001a\u0014\u0010\u0012\u001a\u0004\u0018\u00010\u0013*\u00020\u00112\u0006\u0010\u0003\u001a\u00020\u0004\u001a\u0012\u0010\u0014\u001a\u00020\u0015*\u00020\u000e2\u0006\u0010\u0003\u001a\u00020\u0004\u001a\u0012\u0010\u0016\u001a\u00020\u0015*\u00020\u000e2\u0006\u0010\u0003\u001a\u00020\u0004\u001a\u0012\u0010\u0017\u001a\u00020\u0015*\u00020\u000e2\u0006\u0010\u0003\u001a\u00020\u0004\u001a\u0012\u0010\u0018\u001a\u00020\u0015*\u00020\u000e2\u0006\u0010\u0003\u001a\u00020\u0004\u001a*\u0010\u0019\u001a\u00020\u001a\"\u000e\b\u0000\u0010\u001b*\b\u0012\u0004\u0012\u0002H\u001b0\u001c*\b\u0012\u0004\u0012\u0002H\u001b0\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\u000e\u001a\u001c\u0010\u001e\u001a\u00020\u001a*\u00020\u001f2\u0006\u0010 \u001a\u00020!2\b\u0010\"\u001a\u0004\u0018\u00010#\u00a8\u0006$"}, d2={"getAbbreviatedTypeOrType", "Lorg/jetbrains/kotlin/types/KotlinType;", "Lorg/jetbrains/kotlin/psi/KtTypeElement;", "context", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "Lorg/jetbrains/kotlin/psi/KtTypeReference;", "getDataFlowInfoAfter", "Lorg/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowInfo;", "position", "Lcom/intellij/psi/PsiElement;", "getDataFlowInfoBefore", "getReferenceTargets", "", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "Lorg/jetbrains/kotlin/psi/KtExpression;", "getTargetFunction", "Lorg/jetbrains/kotlin/psi/KtCallableDeclaration;", "Lorg/jetbrains/kotlin/psi/KtReturnExpression;", "getTargetFunctionDescriptor", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "isUnreachableCode", "", "isUsedAsExpression", "isUsedAsResultOfLambda", "isUsedAsStatement", "recordDataFlowInfo", "", "C", "Lorg/jetbrains/kotlin/resolve/calls/context/ResolutionContext;", "expression", "recordScope", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "scope", "Lorg/jetbrains/kotlin/resolve/scopes/LexicalScope;", "element", "Lorg/jetbrains/kotlin/psi/KtElement;", "frontend"})
public final class BindingContextUtilsKt {
    /*
     * WARNING - void declaration
     */
    @Nullable
    public static final FunctionDescriptor getTargetFunctionDescriptor(@NotNull KtReturnExpression $receiver, @NotNull BindingContext context) {
        void $receiver$iv;
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(context, "context");
        KtSimpleNameExpression targetLabel = $receiver.getTargetLabel();
        if (targetLabel != null) {
            SimpleFunctionDescriptor simpleFunctionDescriptor;
            PsiElement psiElement = (PsiElement)context.get(BindingContext.LABEL_TARGET, targetLabel);
            if (psiElement != null) {
                PsiElement psiElement2;
                PsiElement it = psiElement2 = psiElement;
                simpleFunctionDescriptor = (SimpleFunctionDescriptor)context.get(BindingContext.FUNCTION, it);
            } else {
                simpleFunctionDescriptor = null;
            }
            return simpleFunctionDescriptor;
        }
        PsiElement it = $receiver;
        BindingContext bindingContext = context;
        ReadOnlySlice<PsiElement, DeclarationDescriptor> readOnlySlice = BindingContext.DECLARATION_TO_DESCRIPTOR;
        KtDeclarationWithBody ktDeclarationWithBody = PsiTreeUtil.getParentOfType((PsiElement)$receiver$iv, KtDeclarationWithBody.class, false);
        DeclarationDescriptor declarationDescriptor = bindingContext.get(readOnlySlice, ktDeclarationWithBody);
        FunctionDescriptor containingFunctionDescriptor = DescriptorUtils.getParentOfType(declarationDescriptor, FunctionDescriptor.class, false);
        if (containingFunctionDescriptor == null) {
            return null;
        }
        return SequencesKt.firstOrNull(SequencesKt.dropWhile(SequencesKt.generateSequence(containingFunctionDescriptor, (Function1)getTargetFunctionDescriptor.2.INSTANCE), getTargetFunctionDescriptor.3.INSTANCE));
    }

    @Nullable
    public static final KtCallableDeclaration getTargetFunction(@NotNull KtReturnExpression $receiver, @NotNull BindingContext context) {
        KtCallableDeclaration ktCallableDeclaration;
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(context, "context");
        FunctionDescriptor functionDescriptor = BindingContextUtilsKt.getTargetFunctionDescriptor($receiver, context);
        if (functionDescriptor != null) {
            FunctionDescriptor functionDescriptor2 = functionDescriptor;
            FunctionDescriptor it = functionDescriptor2;
            PsiElement psiElement = DescriptorToSourceUtils.descriptorToDeclaration(it);
            if (!(psiElement instanceof KtCallableDeclaration)) {
                psiElement = null;
            }
            ktCallableDeclaration = (KtCallableDeclaration)psiElement;
        } else {
            ktCallableDeclaration = null;
        }
        return ktCallableDeclaration;
    }

    public static final boolean isUsedAsExpression(@NotNull KtExpression $receiver, @NotNull BindingContext context) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(context, "context");
        Object v2 = context.get(BindingContext.USED_AS_EXPRESSION, $receiver);
        if (v2 == null) {
            Intrinsics.throwNpe();
        }
        return (Boolean)v2;
    }

    public static final boolean isUsedAsResultOfLambda(@NotNull KtExpression $receiver, @NotNull BindingContext context) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(context, "context");
        Object v2 = context.get(BindingContext.USED_AS_RESULT_OF_LAMBDA, $receiver);
        if (v2 == null) {
            Intrinsics.throwNpe();
        }
        return (Boolean)v2;
    }

    public static final boolean isUsedAsStatement(@NotNull KtExpression $receiver, @NotNull BindingContext context) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(context, "context");
        return !BindingContextUtilsKt.isUsedAsExpression($receiver, context);
    }

    public static final <C extends ResolutionContext<C>> void recordDataFlowInfo(@NotNull ResolutionContext<C> $receiver, @Nullable KtExpression expression2) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        if (expression2 == null) {
            return;
        }
        KotlinTypeInfo typeInfo = (KotlinTypeInfo)$receiver.trace.get(BindingContext.EXPRESSION_TYPE_INFO, expression2);
        if (typeInfo != null) {
            BindingTrace bindingTrace = $receiver.trace;
            DataFlowInfo dataFlowInfo = $receiver.dataFlowInfo;
            Intrinsics.checkExpressionValueIsNotNull(dataFlowInfo, "dataFlowInfo");
            bindingTrace.record(BindingContext.EXPRESSION_TYPE_INFO, expression2, typeInfo.replaceDataFlowInfo(dataFlowInfo));
        } else if (Intrinsics.areEqual($receiver.dataFlowInfo, DataFlowInfo.Companion.getEMPTY()) ^ true) {
            BindingTrace bindingTrace = $receiver.trace;
            DataFlowInfo dataFlowInfo = $receiver.dataFlowInfo;
            Intrinsics.checkExpressionValueIsNotNull(dataFlowInfo, "dataFlowInfo");
            bindingTrace.record(BindingContext.EXPRESSION_TYPE_INFO, expression2, TypeInfoFactoryKt.noTypeInfo(dataFlowInfo));
        }
    }

    public static final void recordScope(@NotNull BindingTrace $receiver, @NotNull LexicalScope scope, @Nullable KtElement element) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(scope, "scope");
        if (element != null) {
            HierarchicalScope hierarchicalScope = ScopeUtilsKt.takeSnapshot(scope);
            if (hierarchicalScope == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.resolve.scopes.LexicalScope");
            }
            $receiver.record(BindingContext.LEXICAL_SCOPE, element, (LexicalScope)hierarchicalScope);
        }
    }

    @NotNull
    public static final DataFlowInfo getDataFlowInfoAfter(@NotNull BindingContext $receiver, @NotNull PsiElement position) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(position, "position");
        Iterator<PsiElement> iterator2 = PsiUtilsKt.getParentsWithSelf(position).iterator();
        while (iterator2.hasNext()) {
            Object object;
            PsiElement element = iterator2.next();
            PsiElement psiElement = element;
            if (!(psiElement instanceof KtExpression)) {
                psiElement = null;
            }
            if ((object = (KtExpression)psiElement) == null) continue;
            Object object2 = object;
            Object it = object2;
            PsiElement parent2 = it.getParent();
            KotlinTypeInfo kotlinTypeInfo = parent2 instanceof KtQualifiedExpression && Intrinsics.areEqual(it, ((KtQualifiedExpression)parent2).getSelectorExpression()) ? null : (KotlinTypeInfo)$receiver.get(BindingContext.EXPRESSION_TYPE_INFO, it);
            object = kotlinTypeInfo;
            if (kotlinTypeInfo == null) continue;
            it = object2 = object;
            return ((KotlinTypeInfo)it).getDataFlowInfo();
        }
        return DataFlowInfo.Companion.getEMPTY();
    }

    @NotNull
    public static final DataFlowInfo getDataFlowInfoBefore(@NotNull BindingContext $receiver, @NotNull PsiElement position) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(position, "position");
        Iterator<PsiElement> iterator2 = PsiUtilsKt.getParentsWithSelf(position).iterator();
        while (iterator2.hasNext()) {
            Object object;
            Object it;
            Object object2;
            PsiElement element = iterator2.next();
            PsiElement psiElement = element;
            if (!(psiElement instanceof KtExpression)) {
                psiElement = null;
            }
            if ((object2 = (KtExpression)psiElement) == null || (object2 = (DataFlowInfo)$receiver.get(BindingContext.DATA_FLOW_INFO_BEFORE, it = (object = object2))) == null) continue;
            it = object = object2;
            return it;
        }
        return DataFlowInfo.Companion.getEMPTY();
    }

    public static final boolean isUnreachableCode(@NotNull KtExpression $receiver, @NotNull BindingContext context) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(context, "context");
        Object v2 = context.get(BindingContext.UNREACHABLE_CODE, $receiver);
        if (v2 == null) {
            Intrinsics.throwNpe();
        }
        return (Boolean)v2;
    }

    @NotNull
    public static final Collection<DeclarationDescriptor> getReferenceTargets(@NotNull KtExpression $receiver, @NotNull BindingContext context) {
        Object object;
        Object object2;
        DeclarationDescriptor it;
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(context, "context");
        DeclarationDescriptor targetDescriptor = $receiver instanceof KtReferenceExpression ? (DeclarationDescriptor)context.get(BindingContext.REFERENCE_TARGET, $receiver) : null;
        Object object3 = targetDescriptor;
        if (object3 != null && (object3 = CollectionsKt.listOf(it = (object2 = object3))) != null) {
            object = (Collection)object3;
        } else {
            object2 = (Collection)context.get(BindingContext.AMBIGUOUS_REFERENCE_TARGET, $receiver);
            object = object2;
            if (object == null) {
                object = CollectionsKt.emptyList();
            }
        }
        return object;
    }

    @Nullable
    public static final KotlinType getAbbreviatedTypeOrType(@NotNull KtTypeReference $receiver, @NotNull BindingContext context) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(context, "context");
        KotlinType kotlinType = (KotlinType)context.get(BindingContext.ABBREVIATED_TYPE, $receiver);
        if (kotlinType == null) {
            kotlinType = (KotlinType)context.get(BindingContext.TYPE, $receiver);
        }
        return kotlinType;
    }

    @Nullable
    public static final KotlinType getAbbreviatedTypeOrType(@NotNull KtTypeElement $receiver, @NotNull BindingContext context) {
        KotlinType kotlinType;
        PsiElement parent2;
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(context, "context");
        PsiElement psiElement = parent2 = $receiver.getParent();
        if (psiElement instanceof KtTypeReference) {
            kotlinType = BindingContextUtilsKt.getAbbreviatedTypeOrType((KtTypeReference)parent2, context);
        } else if (psiElement instanceof KtNullableType) {
            KotlinType outerType = BindingContextUtilsKt.getAbbreviatedTypeOrType((KtTypeElement)parent2, context);
            if ($receiver instanceof KtNullableType) {
                kotlinType = outerType;
            } else {
                KotlinType kotlinType2 = outerType;
                kotlinType = kotlinType2 != null ? TypeUtilsKt.makeNotNullable(kotlinType2) : null;
            }
        } else {
            kotlinType = null;
        }
        return kotlinType;
    }
}

