/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.components;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.FunctionTypesKt;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.builtins.ReflectionTypes;
import org.jetbrains.kotlin.descriptors.annotations.Annotations;
import org.jetbrains.kotlin.resolve.calls.components.ArgumentsUtilsKt;
import org.jetbrains.kotlin.resolve.calls.components.SimpleArgumentsChecksKt;
import org.jetbrains.kotlin.resolve.calls.inference.ConstraintSystemBuilder;
import org.jetbrains.kotlin.resolve.calls.inference.model.ArgumentConstraintPosition;
import org.jetbrains.kotlin.resolve.calls.inference.model.TypeVariableForLambdaReturnType;
import org.jetbrains.kotlin.resolve.calls.model.CallableReferenceKotlinCallArgument;
import org.jetbrains.kotlin.resolve.calls.model.CollectionLiteralKotlinCallArgument;
import org.jetbrains.kotlin.resolve.calls.model.FunctionExpression;
import org.jetbrains.kotlin.resolve.calls.model.KotlinCallArgument;
import org.jetbrains.kotlin.resolve.calls.model.KotlinDiagnosticsHolder;
import org.jetbrains.kotlin.resolve.calls.model.LambdaKotlinCallArgument;
import org.jetbrains.kotlin.resolve.calls.model.LambdaWithTypeVariableAsExpectedTypeAtom;
import org.jetbrains.kotlin.resolve.calls.model.NotCallableExpectedType;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedAtom;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCallableReferenceAtom;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCollectionLiteralAtom;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedLambdaAtom;
import org.jetbrains.kotlin.resolve.calls.model.SimpleKotlinCallArgument;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.TypeConstructor;
import org.jetbrains.kotlin.types.TypeProjection;
import org.jetbrains.kotlin.types.UnwrappedType;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=2, d1={"\u0000P\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a\"\u0010\u0000\u001a\u00020\u00012\b\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u001a\u001c\u0010\b\u001a\u0004\u0018\u00010\u00012\b\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u001a\u001e\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00030\n2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u001a*\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0004\u001a\u00020\r2\b\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u000e\u001a\u00020\u000fH\u0002\u001a\u001a\u0010\u0010\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003H\u0002\u001a,\u0010\u0013\u001a\u00020\f2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0004\u001a\u00020\u00052\b\u0010\u0002\u001a\u0004\u0018\u00010\u00032\b\b\u0002\u0010\u0014\u001a\u00020\u0015H\u0002\u001a0\u0010\u0016\u001a\u00020\f2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0004\u001a\u00020\u00172\b\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0018\u001a\u00020\u0015\u001a\u0012\u0010\u0019\u001a\u00020\u0001*\u00020\u001a2\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\u001b"}, d2={"extraLambdaInfo", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedLambdaAtom;", "expectedType", "Lorg/jetbrains/kotlin/types/UnwrappedType;", "argument", "Lorg/jetbrains/kotlin/resolve/calls/model/LambdaKotlinCallArgument;", "csBuilder", "Lorg/jetbrains/kotlin/resolve/calls/inference/ConstraintSystemBuilder;", "extractLambdaInfoFromFunctionalType", "extractLambdaParameters", "", "preprocessCallableReference", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedAtom;", "Lorg/jetbrains/kotlin/resolve/calls/model/CallableReferenceKotlinCallArgument;", "diagnosticsHolder", "Lorg/jetbrains/kotlin/resolve/calls/model/KotlinDiagnosticsHolder;", "preprocessCollectionLiteralArgument", "collectionLiteralArgument", "Lorg/jetbrains/kotlin/resolve/calls/model/CollectionLiteralKotlinCallArgument;", "preprocessLambdaArgument", "forceResolution", "", "resolveKtPrimitive", "Lorg/jetbrains/kotlin/resolve/calls/model/KotlinCallArgument;", "isReceiver", "transformToResolvedLambda", "Lorg/jetbrains/kotlin/resolve/calls/model/LambdaWithTypeVariableAsExpectedTypeAtom;", "resolution"})
public final class PostponeArgumentsChecksKt {
    @NotNull
    public static final ResolvedAtom resolveKtPrimitive(@NotNull ConstraintSystemBuilder csBuilder, @NotNull KotlinCallArgument argument, @Nullable UnwrappedType expectedType2, @NotNull KotlinDiagnosticsHolder diagnosticsHolder, boolean isReceiver) {
        ResolvedAtom resolvedAtom;
        Intrinsics.checkParameterIsNotNull(csBuilder, "csBuilder");
        Intrinsics.checkParameterIsNotNull(argument, "argument");
        Intrinsics.checkParameterIsNotNull(diagnosticsHolder, "diagnosticsHolder");
        KotlinCallArgument kotlinCallArgument = argument;
        if (kotlinCallArgument instanceof SimpleKotlinCallArgument) {
            resolvedAtom = SimpleArgumentsChecksKt.checkSimpleArgument(csBuilder, (SimpleKotlinCallArgument)argument, expectedType2, diagnosticsHolder, isReceiver);
        } else if (kotlinCallArgument instanceof LambdaKotlinCallArgument) {
            resolvedAtom = PostponeArgumentsChecksKt.preprocessLambdaArgument$default(csBuilder, (LambdaKotlinCallArgument)argument, expectedType2, false, 8, null);
        } else if (kotlinCallArgument instanceof CallableReferenceKotlinCallArgument) {
            resolvedAtom = PostponeArgumentsChecksKt.preprocessCallableReference(csBuilder, (CallableReferenceKotlinCallArgument)argument, expectedType2, diagnosticsHolder);
        } else if (kotlinCallArgument instanceof CollectionLiteralKotlinCallArgument) {
            resolvedAtom = PostponeArgumentsChecksKt.preprocessCollectionLiteralArgument((CollectionLiteralKotlinCallArgument)argument, expectedType2);
        } else {
            Void void_ = ArgumentsUtilsKt.unexpectedArgument(argument);
            throw null;
        }
        return resolvedAtom;
    }

    private static final ResolvedAtom preprocessLambdaArgument(ConstraintSystemBuilder csBuilder, LambdaKotlinCallArgument argument, UnwrappedType expectedType2, boolean forceResolution) {
        ResolvedLambdaAtom resolvedArgument;
        if (expectedType2 != null && !forceResolution && csBuilder.isTypeVariable(expectedType2)) {
            return new LambdaWithTypeVariableAsExpectedTypeAtom(argument, expectedType2);
        }
        ResolvedLambdaAtom resolvedLambdaAtom = PostponeArgumentsChecksKt.extractLambdaInfoFromFunctionalType(expectedType2, argument);
        if (resolvedLambdaAtom == null) {
            resolvedLambdaAtom = resolvedArgument = PostponeArgumentsChecksKt.extraLambdaInfo(expectedType2, argument, csBuilder);
        }
        if (expectedType2 != null) {
            SimpleType lambdaType = FunctionTypesKt.createFunctionType(csBuilder.getBuiltIns(), Annotations.Companion.getEMPTY(), resolvedArgument.getReceiver(), resolvedArgument.getParameters(), null, resolvedArgument.getReturnType(), resolvedArgument.isSuspend());
            csBuilder.addSubtypeConstraint(lambdaType, expectedType2, new ArgumentConstraintPosition(argument));
        }
        return resolvedArgument;
    }

    static /* synthetic */ ResolvedAtom preprocessLambdaArgument$default(ConstraintSystemBuilder constraintSystemBuilder, LambdaKotlinCallArgument lambdaKotlinCallArgument, UnwrappedType unwrappedType, boolean bl, int n, Object object) {
        if ((n & 8) != 0) {
            bl = false;
        }
        return PostponeArgumentsChecksKt.preprocessLambdaArgument(constraintSystemBuilder, lambdaKotlinCallArgument, unwrappedType, bl);
    }

    /*
     * WARNING - void declaration
     */
    private static final ResolvedLambdaAtom extraLambdaInfo(UnwrappedType expectedType2, LambdaKotlinCallArgument argument, ConstraintSystemBuilder csBuilder) {
        TypeVariableForLambdaReturnType typeVariableForLambdaReturnType;
        List list2;
        Object object;
        KotlinBuiltIns builtIns = csBuilder.getBuiltIns();
        UnwrappedType unwrappedType = expectedType2;
        boolean isSuspend = unwrappedType != null ? FunctionTypesKt.isSuspendFunctionType(unwrappedType) : false;
        boolean isFunctionSupertype = expectedType2 != null && KotlinBuiltIns.isNotNullOrNullableFunctionSupertype(expectedType2);
        LambdaKotlinCallArgument $receiver$iv = argument;
        LambdaKotlinCallArgument lambdaKotlinCallArgument = $receiver$iv;
        if (!(lambdaKotlinCallArgument instanceof FunctionExpression)) {
            lambdaKotlinCallArgument = null;
        }
        FunctionExpression argumentAsFunctionExpression = (FunctionExpression)lambdaKotlinCallArgument;
        TypeVariableForLambdaReturnType typeVariable2 = new TypeVariableForLambdaReturnType(argument, builtIns, "_L");
        FunctionExpression functionExpression = argumentAsFunctionExpression;
        UnwrappedType receiverType = functionExpression != null ? functionExpression.getReceiverType() : null;
        Object object2 = argumentAsFunctionExpression;
        if (object2 == null || (object2 = object2.getReturnType()) == null) {
            Object object3 = expectedType2;
            if (object3 != null && (object3 = ((KotlinType)object3).getArguments()) != null && (object3 = (TypeProjection)CollectionsKt.singleOrNull(object3)) != null && (object3 = object3.getType()) != null && (object3 = ((KotlinType)object3).unwrap()) != null) {
                Object object4;
                Object it = object4 = object3;
                object2 = isFunctionSupertype ? object4 : null;
            } else {
                object2 = object = null;
            }
        }
        if (object2 == null) {
            object = typeVariable2.getDefaultType();
        }
        Object returnType = object;
        UnwrappedType[] unwrappedTypeArray = argument.getParametersTypes();
        if (unwrappedTypeArray != null) {
            void $receiver$iv$iv;
            UnwrappedType[] $receiver$iv2;
            UnwrappedType[] $i$a$1$takeIf = $receiver$iv2 = unwrappedTypeArray;
            Collection destination$iv$iv = new ArrayList($receiver$iv2.length);
            int n = ((void)$receiver$iv$iv).length;
            for (int i = 0; i < n; ++i) {
                void it;
                void item$iv$iv;
                void var17_18 = item$iv$iv = $receiver$iv$iv[i];
                Collection collection = destination$iv$iv;
                UnwrappedType unwrappedType2 = it;
                if (unwrappedType2 == null) {
                    SimpleType simpleType2 = builtIns.getNothingType();
                    Intrinsics.checkExpressionValueIsNotNull(simpleType2, "builtIns.nothingType");
                    unwrappedType2 = simpleType2;
                }
                void var22_20 = unwrappedType2;
                collection.add(var22_20);
            }
            list2 = (List)destination$iv$iv;
        } else {
            list2 = CollectionsKt.emptyList();
        }
        List parameters2 = list2;
        boolean newTypeVariableUsed = Intrinsics.areEqual(returnType, typeVariable2.getDefaultType());
        if (newTypeVariableUsed) {
            csBuilder.registerVariable(typeVariable2);
        }
        TypeVariableForLambdaReturnType typeVariableForLambdaReturnType2 = typeVariable2;
        Object object5 = returnType;
        List list3 = parameters2;
        UnwrappedType unwrappedType3 = receiverType;
        boolean bl = isSuspend;
        LambdaKotlinCallArgument lambdaKotlinCallArgument2 = argument;
        TypeVariableForLambdaReturnType it = typeVariableForLambdaReturnType2;
        TypeVariableForLambdaReturnType typeVariableForLambdaReturnType3 = typeVariableForLambdaReturnType = newTypeVariableUsed ? typeVariableForLambdaReturnType2 : null;
        Object object6 = object5;
        List list4 = list3;
        UnwrappedType unwrappedType4 = unwrappedType3;
        boolean bl2 = bl;
        LambdaKotlinCallArgument lambdaKotlinCallArgument3 = lambdaKotlinCallArgument2;
        return new ResolvedLambdaAtom(lambdaKotlinCallArgument3, bl2, unwrappedType4, list4, (UnwrappedType)object6, typeVariableForLambdaReturnType3);
    }

    private static final ResolvedLambdaAtom extractLambdaInfoFromFunctionalType(UnwrappedType expectedType2, LambdaKotlinCallArgument argument) {
        Object object;
        Object receiverType;
        FunctionExpression argumentAsFunctionExpression;
        Object object2;
        if (expectedType2 == null || !FunctionTypesKt.isBuiltinFunctionalType(expectedType2)) {
            return null;
        }
        List<UnwrappedType> parameters2 = PostponeArgumentsChecksKt.extractLambdaParameters(expectedType2, argument);
        LambdaKotlinCallArgument $receiver$iv = argument;
        LambdaKotlinCallArgument lambdaKotlinCallArgument = $receiver$iv;
        if (!(lambdaKotlinCallArgument instanceof FunctionExpression)) {
            lambdaKotlinCallArgument = null;
        }
        if ((object2 = (argumentAsFunctionExpression = (FunctionExpression)lambdaKotlinCallArgument)) == null || (object2 = object2.getReceiverType()) == null) {
            KotlinType kotlinType = FunctionTypesKt.getReceiverTypeFromFunctionType(expectedType2);
            object2 = receiverType = kotlinType != null ? kotlinType.unwrap() : null;
        }
        if ((object = argumentAsFunctionExpression) == null || (object = object.getReturnType()) == null) {
            object = FunctionTypesKt.getReturnTypeFromFunctionType(expectedType2).unwrap();
        }
        Object returnType = object;
        return new ResolvedLambdaAtom(argument, FunctionTypesKt.isSuspendFunctionType(expectedType2), (UnwrappedType)receiverType, parameters2, (UnwrappedType)returnType, null);
    }

    /*
     * WARNING - void declaration
     */
    private static final List<UnwrappedType> extractLambdaParameters(UnwrappedType expectedType2, LambdaKotlinCallArgument argument) {
        UnwrappedType[] $receiver$iv;
        UnwrappedType[] parametersTypes = argument.getParametersTypes();
        List<TypeProjection> expectedParameters = FunctionTypesKt.getValueParameterTypesFromFunctionType(expectedType2);
        if (parametersTypes == null) {
            void $receiver$iv$iv;
            Iterable $receiver$iv2;
            Iterable iterable = $receiver$iv2 = (Iterable)expectedParameters;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv2, 10));
            for (Object item$iv$iv : $receiver$iv$iv) {
                void it;
                TypeProjection typeProjection = (TypeProjection)item$iv$iv;
                Collection collection = destination$iv$iv;
                UnwrappedType unwrappedType = it.getType().unwrap();
                collection.add(unwrappedType);
            }
            return (List)destination$iv$iv;
        }
        UnwrappedType[] $receiver$iv$iv = $receiver$iv = parametersTypes;
        Collection destination$iv$iv = new ArrayList($receiver$iv.length);
        int index$iv$iv = 0;
        for (UnwrappedType item$iv$iv : $receiver$iv$iv) {
            UnwrappedType unwrappedType;
            void type2;
            int n = index$iv$iv++;
            UnwrappedType $i$f$mapTo = item$iv$iv;
            int $i$f$map = n;
            Collection collection = destination$iv$iv;
            UnwrappedType unwrappedType2 = type2;
            if (unwrappedType2 == null) {
                void index2;
                Object object = CollectionsKt.getOrNull(expectedParameters, (int)index2);
                unwrappedType2 = object != null && (object = object.getType()) != null ? ((KotlinType)object).unwrap() : (unwrappedType = null);
            }
            if (unwrappedType2 == null) {
                SimpleType simpleType2 = TypeUtilsKt.getBuiltIns(expectedType2).getNullableAnyType();
                Intrinsics.checkExpressionValueIsNotNull(simpleType2, "expectedType.builtIns.nullableAnyType");
                unwrappedType = simpleType2;
            }
            void var17_15 = unwrappedType;
            collection.add(var17_15);
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public static final ResolvedLambdaAtom transformToResolvedLambda(@NotNull LambdaWithTypeVariableAsExpectedTypeAtom $receiver, @NotNull ConstraintSystemBuilder csBuilder) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(csBuilder, "csBuilder");
        UnwrappedType fixedExpectedType = csBuilder.buildCurrentSubstitutor().safeSubstitute($receiver.getExpectedType());
        ResolvedAtom resolvedAtom = PostponeArgumentsChecksKt.preprocessLambdaArgument(csBuilder, $receiver.getAtom(), fixedExpectedType, true);
        if (resolvedAtom == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.resolve.calls.model.ResolvedLambdaAtom");
        }
        ResolvedLambdaAtom resolvedLambdaAtom = (ResolvedLambdaAtom)resolvedAtom;
        $receiver.setAnalyzed(resolvedLambdaAtom);
        return resolvedLambdaAtom;
    }

    private static final ResolvedAtom preprocessCallableReference(ConstraintSystemBuilder csBuilder, CallableReferenceKotlinCallArgument argument, UnwrappedType expectedType2, KotlinDiagnosticsHolder diagnosticsHolder) {
        Object v0;
        ResolvedCallableReferenceAtom result2;
        block3: {
            result2 = new ResolvedCallableReferenceAtom(argument, expectedType2);
            if (expectedType2 == null) {
                return result2;
            }
            Iterable $receiver$iv = csBuilder.getProperSuperTypeConstructors(expectedType2);
            for (Object element$iv : $receiver$iv) {
                TypeConstructor it = (TypeConstructor)element$iv;
                if (!(!ReflectionTypes.Companion.isPossibleExpectedCallableType(it))) continue;
                v0 = element$iv;
                break block3;
            }
            v0 = null;
        }
        TypeConstructor notCallableTypeConstructor = v0;
        if (notCallableTypeConstructor != null) {
            diagnosticsHolder.addDiagnostic(new NotCallableExpectedType(argument, expectedType2, notCallableTypeConstructor));
        }
        return result2;
    }

    private static final ResolvedAtom preprocessCollectionLiteralArgument(CollectionLiteralKotlinCallArgument collectionLiteralArgument, UnwrappedType expectedType2) {
        return new ResolvedCollectionLiteralAtom(collectionLiteralArgument, expectedType2);
    }
}

