/*
 * Decompiled with CFR 0.152.
 */
package org.jline.terminal.impl.jna.linux;

import com.sun.jna.LastErrorException;
import com.sun.jna.Library;
import com.sun.jna.Native;
import com.sun.jna.Platform;
import java.io.FileDescriptor;
import java.io.IOException;
import org.jline.terminal.Attributes;
import org.jline.terminal.Size;
import org.jline.terminal.impl.jna.JnaNativePty;
import org.jline.terminal.impl.jna.linux.CLibrary;

public class LinuxNativePty
extends JnaNativePty {
    private static final CLibrary C_LIBRARY = Native.load(Platform.C_LIBRARY_NAME, CLibrary.class);

    public static LinuxNativePty current() throws IOException {
        int slave = 0;
        byte[] buf = new byte[64];
        C_LIBRARY.ttyname_r(slave, buf, buf.length);
        int len = 0;
        while (buf[len] != 0) {
            ++len;
        }
        String name2 = new String(buf, 0, len);
        return new LinuxNativePty(-1, null, slave, FileDescriptor.in, 1, FileDescriptor.out, name2);
    }

    public static LinuxNativePty open(Attributes attr, Size size) throws IOException {
        int[] master = new int[1];
        int[] slave = new int[1];
        byte[] buf = new byte[64];
        UtilLibrary.INSTANCE.openpty(master, slave, buf, attr != null ? new CLibrary.termios(attr) : null, size != null ? new CLibrary.winsize(size) : null);
        int len = 0;
        while (buf[len] != 0) {
            ++len;
        }
        String name2 = new String(buf, 0, len);
        return new LinuxNativePty(master[0], LinuxNativePty.newDescriptor(master[0]), slave[0], LinuxNativePty.newDescriptor(slave[0]), name2);
    }

    public LinuxNativePty(int master, FileDescriptor masterFD, int slave, FileDescriptor slaveFD, String name2) {
        super(master, masterFD, slave, slaveFD, name2);
    }

    public LinuxNativePty(int master, FileDescriptor masterFD, int slave, FileDescriptor slaveFD, int slaveOut, FileDescriptor slaveOutFD, String name2) {
        super(master, masterFD, slave, slaveFD, slaveOut, slaveOutFD, name2);
    }

    @Override
    public Attributes getAttr() throws IOException {
        CLibrary.termios termios2 = new CLibrary.termios();
        C_LIBRARY.tcgetattr(this.getSlave(), termios2);
        return termios2.toAttributes();
    }

    @Override
    protected void doSetAttr(Attributes attr) throws IOException {
        CLibrary.termios termios2 = new CLibrary.termios(attr);
        CLibrary.termios org = new CLibrary.termios();
        C_LIBRARY.tcgetattr(this.getSlave(), org);
        org.c_iflag = termios2.c_iflag;
        org.c_oflag = termios2.c_oflag;
        org.c_lflag = termios2.c_lflag;
        System.arraycopy(termios2.c_cc, 0, org.c_cc, 0, termios2.c_cc.length);
        C_LIBRARY.tcsetattr(this.getSlave(), 1, org);
    }

    @Override
    public Size getSize() throws IOException {
        CLibrary.winsize sz = new CLibrary.winsize();
        C_LIBRARY.ioctl(this.getSlave(), CLibrary.TIOCGWINSZ, sz);
        return sz.toSize();
    }

    @Override
    public void setSize(Size size) throws IOException {
        CLibrary.winsize sz = new CLibrary.winsize(size);
        C_LIBRARY.ioctl(this.getSlave(), CLibrary.TIOCSWINSZ, sz);
    }

    public static int isatty(int fd) {
        return C_LIBRARY.isatty(fd);
    }

    public static interface UtilLibrary
    extends Library {
        public static final UtilLibrary INSTANCE = Native.load("util", UtilLibrary.class);

        public void openpty(int[] var1, int[] var2, byte[] var3, CLibrary.termios var4, CLibrary.winsize var5) throws LastErrorException;
    }
}

