/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.deprecation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.builtins.StandardNames;
import org.jetbrains.kotlin.config.ApiVersion;
import org.jetbrains.kotlin.config.KotlinCompilerVersion;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.config.MavenComparableVersion;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyAccessorDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.TypeAliasDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.Annotated;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.kotlin.descriptors.impl.DescriptorDerivedFromTypeAlias;
import org.jetbrains.kotlin.descriptors.impl.TypeAliasConstructorDescriptor;
import org.jetbrains.kotlin.metadata.ProtoBuf;
import org.jetbrains.kotlin.metadata.deserialization.VersionRequirement;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.Call;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.SinceKotlinAccessibility;
import org.jetbrains.kotlin.resolve.SinceKotlinUtilKt;
import org.jetbrains.kotlin.resolve.calls.checkers.OperatorCallCheckerKt;
import org.jetbrains.kotlin.resolve.checkers.ExperimentalUsageChecker;
import org.jetbrains.kotlin.resolve.deprecation.DeprecatedByAnnotation;
import org.jetbrains.kotlin.resolve.deprecation.DeprecatedByOverridden;
import org.jetbrains.kotlin.resolve.deprecation.DeprecatedByVersionRequirement;
import org.jetbrains.kotlin.resolve.deprecation.DeprecatedOperatorMod;
import org.jetbrains.kotlin.resolve.deprecation.DeprecatedTypealiasByAnnotation;
import org.jetbrains.kotlin.resolve.deprecation.DeprecationLevelValue;
import org.jetbrains.kotlin.resolve.deprecation.DeprecationSettings;
import org.jetbrains.kotlin.resolve.deprecation.DescriptorBasedDeprecationInfo;
import org.jetbrains.kotlin.resolve.deprecation.DescriptorBasedDeprecationInfoKt;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.serialization.deserialization.descriptors.DeserializedClassDescriptor;
import org.jetbrains.kotlin.serialization.deserialization.descriptors.DeserializedMemberDescriptor;
import org.jetbrains.kotlin.storage.MemoizedFunctionToNotNull;
import org.jetbrains.kotlin.storage.StorageManager;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.UnwrappedType;
import org.jetbrains.kotlin.utils.SmartList;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 12\u00020\u0001:\u000212B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u001f\u0010\u0012\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u000b\u0082\u0002\u000e\n\f\b\u0000\u0012\u0002\u0018\u0000\u001a\u0004\u0010\u0001(\u0000J\u0012\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0017\u001a\u00020\u0014H\u0002J\u0016\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00192\u0006\u0010\u001b\u001a\u00020\u000bH\u0002J\u0012\u0010\u001c\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u001b\u001a\u00020\u000bH\u0002J\u0014\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00160\u00192\u0006\u0010\u0013\u001a\u00020\u000bJ\u0014\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00160\u00192\u0006\u0010\u0013\u001a\u00020\u000bJ\u000e\u0010\u001f\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u000bJ<\u0010 \u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u000b2\n\b\u0002\u0010!\u001a\u0004\u0018\u00010\"2\n\b\u0002\u0010#\u001a\u0004\u0018\u00010$2\b\b\u0002\u0010%\u001a\u00020\u00102\b\b\u0002\u0010&\u001a\u00020\u0010H\u0007J2\u0010 \u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u000b2\b\u0010'\u001a\u0004\u0018\u00010(2\b\u0010#\u001a\u0004\u0018\u00010$2\u0006\u0010%\u001a\u00020\u00102\u0006\u0010&\u001a\u00020\u0010J\u0018\u0010)\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\u0004\u001a\u00020\u0005H\u0002J\u001a\u0010*\u001a\u00020+*\u00020\u000b2\f\u0010,\u001a\b\u0012\u0004\u0012\u00020\u00160-H\u0002J\u0012\u0010.\u001a\b\u0012\u0004\u0012\u00020\u00160\u0019*\u00020/H\u0002J\u0012\u00100\u001a\b\u0012\u0004\u0012\u00020\u00160\u0019*\u00020\u000bH\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000e0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u000f\u001a\u00020\u0010*\u00020\u000b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0011\u00f2\u0001\u0004\n\u00020\u0014\u00a8\u00063"}, d2={"Lorg/jetbrains/kotlin/resolve/deprecation/DeprecationResolver;", "", "storageManager", "Lorg/jetbrains/kotlin/storage/StorageManager;", "languageVersionSettings", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "deprecationSettings", "Lorg/jetbrains/kotlin/resolve/deprecation/DeprecationSettings;", "(Lorg/jetbrains/kotlin/storage/StorageManager;Lorg/jetbrains/kotlin/config/LanguageVersionSettings;Lorg/jetbrains/kotlin/resolve/deprecation/DeprecationSettings;)V", "deprecations", "Lorg/jetbrains/kotlin/storage/MemoizedFunctionToNotNull;", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "Lorg/jetbrains/kotlin/resolve/deprecation/DeprecationResolver$DeprecationInfo;", "isHiddenBecauseOfKotlinVersionAccessibility", "Lorg/jetbrains/kotlin/resolve/SinceKotlinAccessibility;", "isBuiltInOperatorMod", "", "(Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;)Z", "areDeprecationsInheritedFromOverriden", "descriptor", "Lorg/jetbrains/kotlin/descriptors/CallableMemberDescriptor;", "deprecationByOverridden", "Lorg/jetbrains/kotlin/resolve/deprecation/DescriptorBasedDeprecationInfo;", "root", "getDeprecationByVersionRequirement", "", "Lorg/jetbrains/kotlin/resolve/deprecation/DeprecatedByVersionRequirement;", "target", "getDeprecationFromUserData", "getDeprecations", "getHiddenDeprecationsFromOverriden", "isDeprecatedHidden", "isHiddenInResolution", "call", "Lorg/jetbrains/kotlin/psi/Call;", "bindingContext", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "isSuperCall", "fromImportingScope", "callElement", "Lorg/jetbrains/kotlin/psi/KtElement;", "shouldSkipDeprecationOnKotlinIoReadBytes", "addDeprecationIfPresent", "", "result", "", "deprecationsByConstituentTypes", "Lorg/jetbrains/kotlin/types/KotlinType;", "getOwnDeprecations", "Companion", "DeprecationInfo", "frontend"})
public final class DeprecationResolver {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final LanguageVersionSettings languageVersionSettings;
    @NotNull
    private final DeprecationSettings deprecationSettings;
    @NotNull
    private final MemoizedFunctionToNotNull<DeclarationDescriptor, DeprecationInfo> deprecations;
    @NotNull
    private final MemoizedFunctionToNotNull<DeclarationDescriptor, SinceKotlinAccessibility> isHiddenBecauseOfKotlinVersionAccessibility;
    @NotNull
    private static final FqName JAVA_DEPRECATED = new FqName("java.lang.Deprecated");

    public DeprecationResolver(@NotNull StorageManager storageManager, @NotNull LanguageVersionSettings languageVersionSettings, @NotNull DeprecationSettings deprecationSettings) {
        Intrinsics.checkNotNullParameter(storageManager, "storageManager");
        Intrinsics.checkNotNullParameter(languageVersionSettings, "languageVersionSettings");
        Intrinsics.checkNotNullParameter(deprecationSettings, "deprecationSettings");
        this.languageVersionSettings = languageVersionSettings;
        this.deprecationSettings = deprecationSettings;
        this.deprecations = storageManager.createMemoizedFunction((Function1)new Function1<DeclarationDescriptor, DeprecationInfo>(this){
            final /* synthetic */ DeprecationResolver this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @NotNull
            public final DeprecationInfo invoke(@NotNull DeclarationDescriptor descriptor2) {
                DeprecationInfo deprecationInfo;
                Intrinsics.checkNotNullParameter(descriptor2, "descriptor");
                List deprecations2 = DeprecationResolver.access$getOwnDeprecations(this.this$0, descriptor2);
                if (!((Collection)deprecations2).isEmpty()) {
                    deprecationInfo = new DeprecationInfo(deprecations2, false, null, 4, null);
                    return deprecationInfo;
                } else if (descriptor2 instanceof CallableMemberDescriptor) {
                    boolean bl;
                    List<DescriptorBasedDeprecationInfo> inheritedDeprecations = CollectionsKt.listOfNotNull(DeprecationResolver.access$deprecationByOverridden(this.this$0, (CallableMemberDescriptor)descriptor2));
                    boolean bl2 = bl = !((Collection)inheritedDeprecations).isEmpty();
                    if (bl) {
                        boolean bl3 = DeprecationResolver.access$getLanguageVersionSettings$p(this.this$0).supportsFeature(LanguageFeature.StopPropagatingDeprecationThroughOverrides);
                        if (bl3) {
                            deprecationInfo = new DeprecationInfo(CollectionsKt.emptyList(), true, inheritedDeprecations);
                            return deprecationInfo;
                        } else {
                            if (bl3) throw new NoWhenBranchMatchedException();
                            deprecationInfo = new DeprecationInfo(inheritedDeprecations, true, null, 4, null);
                        }
                        return deprecationInfo;
                    } else {
                        if (bl) throw new NoWhenBranchMatchedException();
                        deprecationInfo = DeprecationInfo.Companion.getEMPTY();
                    }
                    return deprecationInfo;
                } else {
                    deprecationInfo = DeprecationInfo.Companion.getEMPTY();
                }
                return deprecationInfo;
            }
        });
        this.isHiddenBecauseOfKotlinVersionAccessibility = storageManager.createMemoizedFunction((Function1)new Function1<DeclarationDescriptor, SinceKotlinAccessibility>(this){
            final /* synthetic */ DeprecationResolver this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final SinceKotlinAccessibility invoke(@NotNull DeclarationDescriptor descriptor2) {
                Intrinsics.checkNotNullParameter(descriptor2, "descriptor");
                return SinceKotlinUtilKt.checkSinceKotlinVersionAccessibility(descriptor2, DeprecationResolver.access$getLanguageVersionSettings$p(this.this$0));
            }
        });
    }

    @NotNull
    public final List<DescriptorBasedDeprecationInfo> getDeprecations(@NotNull DeclarationDescriptor descriptor2) {
        Intrinsics.checkNotNullParameter(descriptor2, "descriptor");
        DeclarationDescriptor declarationDescriptor = descriptor2.getOriginal();
        Intrinsics.checkNotNullExpressionValue(declarationDescriptor, "descriptor.original");
        return ((DeprecationInfo)this.deprecations.invoke(declarationDescriptor)).getDeprecations();
    }

    public final boolean areDeprecationsInheritedFromOverriden(@NotNull DeclarationDescriptor descriptor2) {
        Intrinsics.checkNotNullParameter(descriptor2, "descriptor");
        DeclarationDescriptor declarationDescriptor = descriptor2.getOriginal();
        Intrinsics.checkNotNullExpressionValue(declarationDescriptor, "descriptor.original");
        return ((DeprecationInfo)this.deprecations.invoke(declarationDescriptor)).getHasInheritedDeprecations();
    }

    @NotNull
    public final List<DescriptorBasedDeprecationInfo> getHiddenDeprecationsFromOverriden(@NotNull DeclarationDescriptor descriptor2) {
        Intrinsics.checkNotNullParameter(descriptor2, "descriptor");
        DeclarationDescriptor declarationDescriptor = descriptor2.getOriginal();
        Intrinsics.checkNotNullExpressionValue(declarationDescriptor, "descriptor.original");
        return ((DeprecationInfo)this.deprecations.invoke(declarationDescriptor)).getHiddenInheritedDeprecations();
    }

    public final boolean isDeprecatedHidden(@NotNull DeclarationDescriptor descriptor2) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter(descriptor2, "descriptor");
            Iterable $this$any$iv = this.getDeprecations(descriptor2);
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    DescriptorBasedDeprecationInfo it = (DescriptorBasedDeprecationInfo)element$iv;
                    boolean bl2 = false;
                    if (!(it.getDeprecationLevel() == DeprecationLevelValue.HIDDEN)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    @JvmOverloads
    public final boolean isHiddenInResolution(@NotNull DeclarationDescriptor descriptor2, @Nullable Call call2, @Nullable BindingContext bindingContext, boolean isSuperCall, boolean fromImportingScope) {
        Intrinsics.checkNotNullParameter(descriptor2, "descriptor");
        Call call3 = call2;
        return this.isHiddenInResolution(descriptor2, call3 != null ? call3.getCallElement() : null, bindingContext, isSuperCall, fromImportingScope);
    }

    public static /* synthetic */ boolean isHiddenInResolution$default(DeprecationResolver deprecationResolver, DeclarationDescriptor declarationDescriptor, Call call2, BindingContext bindingContext, boolean bl, boolean bl2, int n, Object object) {
        if ((n & 2) != 0) {
            call2 = null;
        }
        if ((n & 4) != 0) {
            bindingContext = null;
        }
        if ((n & 8) != 0) {
            bl = false;
        }
        if ((n & 0x10) != 0) {
            bl2 = false;
        }
        return deprecationResolver.isHiddenInResolution(declarationDescriptor, call2, bindingContext, bl, bl2);
    }

    public final boolean isHiddenInResolution(@NotNull DeclarationDescriptor descriptor2, @Nullable KtElement callElement, @Nullable BindingContext bindingContext, boolean isSuperCall, boolean fromImportingScope) {
        Intrinsics.checkNotNullParameter(descriptor2, "descriptor");
        if (descriptor2 instanceof FunctionDescriptor) {
            if (((FunctionDescriptor)descriptor2).isHiddenToOvercomeSignatureClash()) {
                return true;
            }
            if (((FunctionDescriptor)descriptor2).isHiddenForResolutionEverywhereBesideSupercalls() && !isSuperCall) {
                return true;
            }
        }
        DeclarationDescriptor declarationDescriptor = descriptor2.getOriginal();
        Intrinsics.checkNotNullExpressionValue(declarationDescriptor, "descriptor.original");
        SinceKotlinAccessibility sinceKotlinAccessibility = (SinceKotlinAccessibility)this.isHiddenBecauseOfKotlinVersionAccessibility.invoke(declarationDescriptor);
        if (sinceKotlinAccessibility instanceof SinceKotlinAccessibility.NotAccessible) {
            return true;
        }
        if (sinceKotlinAccessibility instanceof SinceKotlinAccessibility.NotAccessibleButWasExperimental) {
            boolean bl;
            block10: {
                if (callElement != null && bindingContext != null) {
                    ExperimentalUsageChecker.Companion $this$isHiddenInResolution_u24lambda_u2d3 = ExperimentalUsageChecker.Companion;
                    boolean bl2 = false;
                    Iterable $this$any$iv = ((SinceKotlinAccessibility.NotAccessibleButWasExperimental)sinceKotlinAccessibility).getMarkerClasses();
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            ClassDescriptor classDescriptor = (ClassDescriptor)element$iv;
                            boolean bl3 = false;
                            if (!(!$this$isHiddenInResolution_u24lambda_u2d3.isExperimentalityAccepted(callElement, DescriptorUtilsKt.getFqNameSafe(classDescriptor), this.languageVersionSettings, bindingContext))) continue;
                            bl = true;
                            break block10;
                        }
                        bl = false;
                    }
                } else {
                    bl = !fromImportingScope;
                }
            }
            return bl;
        }
        return this.isDeprecatedHidden(descriptor2);
    }

    private final List<DescriptorBasedDeprecationInfo> deprecationsByConstituentTypes(KotlinType $this$deprecationsByConstituentTypes) {
        SmartList<DescriptorBasedDeprecationInfo> smartList;
        SmartList<DescriptorBasedDeprecationInfo> deprecations2 = smartList = new SmartList<DescriptorBasedDeprecationInfo>();
        boolean bl = false;
        TypeUtils.contains($this$deprecationsByConstituentTypes, new Function1<UnwrappedType, Boolean>(deprecations2, this){
            final /* synthetic */ SmartList<DescriptorBasedDeprecationInfo> $deprecations;
            final /* synthetic */ DeprecationResolver this$0;
            {
                this.$deprecations = $deprecations;
                this.this$0 = $receiver;
                super(1);
            }

            public final Boolean invoke(UnwrappedType type2) {
                block0: {
                    ClassifierDescriptor classifierDescriptor = type2.getConstructor().getDeclarationDescriptor();
                    if (classifierDescriptor == null) break block0;
                    ClassifierDescriptor classifierDescriptor2 = classifierDescriptor;
                    SmartList<DescriptorBasedDeprecationInfo> smartList = this.$deprecations;
                    DeprecationResolver deprecationResolver = this.this$0;
                    ClassifierDescriptor it = classifierDescriptor2;
                    boolean bl = false;
                    smartList.addAll((Collection<DescriptorBasedDeprecationInfo>)deprecationResolver.getDeprecations(it));
                }
                return false;
            }
        });
        return smartList;
    }

    private final DescriptorBasedDeprecationInfo deprecationByOverridden(CallableMemberDescriptor root2) {
        HashSet<CallableMemberDescriptor> visited2 = new HashSet<CallableMemberDescriptor>();
        LinkedHashSet<DescriptorBasedDeprecationInfo> deprecations2 = new LinkedHashSet<DescriptorBasedDeprecationInfo>();
        Ref.BooleanRef hasUndeprecatedOverridden = new Ref.BooleanRef();
        DeprecationResolver.deprecationByOverridden$traverse(visited2, this, deprecations2, hasUndeprecatedOverridden, root2);
        if (hasUndeprecatedOverridden.element || deprecations2.isEmpty()) {
            return null;
        }
        if (root2.getKind().isReal()) {
            boolean bl;
            block6: {
                Iterable $this$none$iv = deprecations2;
                boolean $i$f$none = false;
                if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $this$none$iv) {
                        DescriptorBasedDeprecationInfo p0 = (DescriptorBasedDeprecationInfo)element$iv;
                        boolean bl2 = false;
                        if (!p0.getPropagatesToOverrides()) continue;
                        bl = false;
                        break block6;
                    }
                    bl = true;
                }
            }
            if (bl) {
                return null;
            }
        }
        return new DeprecatedByOverridden((Collection<? extends DescriptorBasedDeprecationInfo>)deprecations2);
    }

    /*
     * WARNING - void declaration
     */
    private final List<DescriptorBasedDeprecationInfo> getOwnDeprecations(DeclarationDescriptor $this$getOwnDeprecations) {
        if (this.isBuiltInOperatorMod($this$getOwnDeprecations) && !OperatorCallCheckerKt.shouldWarnAboutDeprecatedModFromBuiltIns(this.languageVersionSettings)) {
            return CollectionsKt.emptyList();
        }
        if (this.shouldSkipDeprecationOnKotlinIoReadBytes($this$getOwnDeprecations, this.languageVersionSettings)) {
            return CollectionsKt.emptyList();
        }
        SmartList result2 = new SmartList();
        this.addDeprecationIfPresent($this$getOwnDeprecations, result2);
        DeclarationDescriptor declarationDescriptor = $this$getOwnDeprecations;
        if (declarationDescriptor instanceof TypeAliasDescriptor) {
            Iterable $this$mapTo$iv = this.deprecationsByConstituentTypes(((TypeAliasDescriptor)$this$getOwnDeprecations).getExpandedType());
            boolean $i$f$mapTo = false;
            for (Object item$iv : $this$mapTo$iv) {
                void deprecation2;
                DescriptorBasedDeprecationInfo descriptorBasedDeprecationInfo = (DescriptorBasedDeprecationInfo)item$iv;
                Collection collection = result2;
                boolean bl = false;
                collection.add(deprecation2 instanceof DeprecatedByAnnotation ? (DescriptorBasedDeprecationInfo)new DeprecatedTypealiasByAnnotation((TypeAliasDescriptor)$this$getOwnDeprecations, (DeprecatedByAnnotation)deprecation2) : deprecation2);
            }
        } else if (declarationDescriptor instanceof DescriptorDerivedFromTypeAlias) {
            result2.addAll(this.getOwnDeprecations(((DescriptorDerivedFromTypeAlias)((Object)$this$getOwnDeprecations)).getTypeAliasDescriptor()));
        } else if (declarationDescriptor instanceof PropertyAccessorDescriptor) {
            PropertyDescriptor propertyDescriptor = ((PropertyAccessorDescriptor)$this$getOwnDeprecations).getCorrespondingProperty();
            Intrinsics.checkNotNullExpressionValue(propertyDescriptor, "correspondingProperty");
            this.addDeprecationIfPresent(propertyDescriptor, result2);
        }
        return CollectionsKt.distinct(result2);
    }

    private final void addDeprecationIfPresent(DeclarationDescriptor $this$addDeprecationIfPresent, List<DescriptorBasedDeprecationInfo> result2) {
        block3: {
            DeprecatedByAnnotation deprecatedByAnnotation;
            AnnotationDescriptor annotation2;
            AnnotationDescriptor annotationDescriptor = $this$addDeprecationIfPresent.getAnnotations().findAnnotation(StandardNames.FqNames.deprecated);
            if (annotationDescriptor == null) {
                annotationDescriptor = $this$addDeprecationIfPresent.getAnnotations().findAnnotation(JAVA_DEPRECATED);
            }
            if ((annotation2 = annotationDescriptor) != null && (deprecatedByAnnotation = DeprecatedByAnnotation.Companion.create(annotation2, $this$addDeprecationIfPresent.getAnnotations().findAnnotation(StandardNames.FqNames.deprecatedSinceKotlin), $this$addDeprecationIfPresent, this.deprecationSettings.propagatedToOverrides(annotation2), this.languageVersionSettings.getApiVersion())) != null) {
                DescriptorBasedDeprecationInfo deprecation2 = $this$addDeprecationIfPresent instanceof TypeAliasConstructorDescriptor ? (DescriptorBasedDeprecationInfo)new DeprecatedTypealiasByAnnotation(((TypeAliasConstructorDescriptor)$this$addDeprecationIfPresent).getTypeAliasDescriptor(), deprecatedByAnnotation) : (this.isBuiltInOperatorMod($this$addDeprecationIfPresent) ? (DescriptorBasedDeprecationInfo)new DeprecatedOperatorMod(this.languageVersionSettings, deprecatedByAnnotation) : (DescriptorBasedDeprecationInfo)deprecatedByAnnotation);
                result2.add(deprecation2);
            }
            for (DescriptorBasedDeprecationInfo deprecation2 : this.getDeprecationByVersionRequirement($this$addDeprecationIfPresent)) {
                result2.add(deprecation2);
            }
            DescriptorBasedDeprecationInfo descriptorBasedDeprecationInfo = this.getDeprecationFromUserData($this$addDeprecationIfPresent);
            if (descriptorBasedDeprecationInfo == null) break block3;
            DescriptorBasedDeprecationInfo p0 = descriptorBasedDeprecationInfo;
            boolean bl = false;
            result2.add(p0);
        }
    }

    private final boolean isBuiltInOperatorMod(DeclarationDescriptor $this$isBuiltInOperatorMod) {
        return $this$isBuiltInOperatorMod instanceof FunctionDescriptor && OperatorCallCheckerKt.isOperatorMod((FunctionDescriptor)$this$isBuiltInOperatorMod) && KotlinBuiltIns.isUnderKotlinPackage($this$isBuiltInOperatorMod);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean shouldSkipDeprecationOnKotlinIoReadBytes(DeclarationDescriptor descriptor2, LanguageVersionSettings languageVersionSettings) {
        if (!Intrinsics.areEqual(descriptor2.getName().asString(), "readBytes")) return false;
        DeclarationDescriptor declarationDescriptor = descriptor2.getContainingDeclaration();
        Object object = declarationDescriptor instanceof PackageFragmentDescriptor ? (PackageFragmentDescriptor)declarationDescriptor : null;
        if (!Intrinsics.areEqual(object != null && (object = object.getFqName()) != null ? ((FqName)object).asString() : null, "kotlin.io")) return false;
        if (!(descriptor2 instanceof FunctionDescriptor)) return false;
        List<ValueParameterDescriptor> list2 = ((FunctionDescriptor)descriptor2).getValueParameters();
        Intrinsics.checkNotNullExpressionValue(list2, "descriptor.valueParameters");
        ValueParameterDescriptor valueParameterDescriptor = CollectionsKt.singleOrNull(list2);
        Annotated annotated = valueParameterDescriptor;
        if (valueParameterDescriptor == null) return false;
        KotlinType kotlinType = annotated.getType();
        annotated = kotlinType;
        if (kotlinType == null) return false;
        Annotated annotated2 = annotated;
        boolean bl = false;
        if (!KotlinBuiltIns.isInt((KotlinType)annotated2)) return false;
        boolean bl2 = true;
        if (!bl2) return false;
        if (languageVersionSettings.getApiVersion().compareTo(ApiVersion.KOTLIN_1_3) >= 0) return false;
        return true;
    }

    private final DescriptorBasedDeprecationInfo getDeprecationFromUserData(DeclarationDescriptor target) {
        DeclarationDescriptor $this$safeAs$iv = target;
        boolean $i$f$safeAs = false;
        DeclarationDescriptor declarationDescriptor = $this$safeAs$iv;
        if (!(declarationDescriptor instanceof CallableDescriptor)) {
            declarationDescriptor = null;
        }
        CallableDescriptor callableDescriptor = (CallableDescriptor)declarationDescriptor;
        return callableDescriptor != null ? callableDescriptor.getUserData(DescriptorBasedDeprecationInfoKt.getDEPRECATED_FUNCTION_KEY()) : null;
    }

    /*
     * WARNING - void declaration
     */
    private final List<DeprecatedByVersionRequirement> getDeprecationByVersionRequirement(DeclarationDescriptor target) {
        void $this$mapNotNullTo$iv$iv;
        Object object = target instanceof DeserializedMemberDescriptor ? (DeserializedMemberDescriptor)target : null;
        if (object == null || (object = object.getVersionRequirements()) == null) {
            DeserializedClassDescriptor deserializedClassDescriptor = target instanceof DeserializedClassDescriptor ? (DeserializedClassDescriptor)target : null;
            if (deserializedClassDescriptor != null) {
                object = deserializedClassDescriptor.getVersionRequirements();
            } else {
                return CollectionsKt.emptyList();
            }
        }
        List<VersionRequirement> versionRequirements = object;
        Iterable $this$mapNotNull$iv = versionRequirements;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            DeprecatedByVersionRequirement it$iv$iv;
            MavenComparableVersion currentVersion;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            VersionRequirement versionRequirement = (VersionRequirement)element$iv$iv;
            boolean bl2 = false;
            MavenComparableVersion requiredVersion = DeprecationResolver.getDeprecationByVersionRequirement$createVersion(versionRequirement.getVersion().asString());
            switch (WhenMappings.$EnumSwitchMapping$0[versionRequirement.getKind().ordinal()]) {
                case 1: {
                    MavenComparableVersion mavenComparableVersion = new MavenComparableVersion(this.languageVersionSettings.getLanguageVersion().getVersionString());
                    break;
                }
                case 2: {
                    MavenComparableVersion mavenComparableVersion = this.languageVersionSettings.getApiVersion().getVersion();
                    break;
                }
                case 3: {
                    MavenComparableVersion mavenComparableVersion;
                    String string2 = KotlinCompilerVersion.getVersion();
                    String string3 = string2;
                    if (string3 != null) {
                        Intrinsics.checkNotNullExpressionValue(string3, "getVersion()");
                        string3 = StringsKt.substringBefore$default(string2, '-', null, 2, null);
                        if (string3 != null) {
                            String p0 = string3;
                            boolean bl3 = false;
                            mavenComparableVersion = DeprecationResolver.getDeprecationByVersionRequirement$createVersion(p0);
                            break;
                        }
                    }
                    mavenComparableVersion = null;
                    break;
                }
                default: {
                    MavenComparableVersion mavenComparableVersion = currentVersion = null;
                }
            }
            if ((currentVersion != null && currentVersion.compareTo(requiredVersion) < 0 ? new DeprecatedByVersionRequirement(versionRequirement, target) : null) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl4 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @JvmOverloads
    public final boolean isHiddenInResolution(@NotNull DeclarationDescriptor descriptor2, @Nullable Call call2, @Nullable BindingContext bindingContext, boolean isSuperCall) {
        Intrinsics.checkNotNullParameter(descriptor2, "descriptor");
        return DeprecationResolver.isHiddenInResolution$default(this, descriptor2, call2, bindingContext, isSuperCall, false, 16, null);
    }

    @JvmOverloads
    public final boolean isHiddenInResolution(@NotNull DeclarationDescriptor descriptor2, @Nullable Call call2, @Nullable BindingContext bindingContext) {
        Intrinsics.checkNotNullParameter(descriptor2, "descriptor");
        return DeprecationResolver.isHiddenInResolution$default(this, descriptor2, call2, bindingContext, false, false, 24, null);
    }

    @JvmOverloads
    public final boolean isHiddenInResolution(@NotNull DeclarationDescriptor descriptor2, @Nullable Call call2) {
        Intrinsics.checkNotNullParameter(descriptor2, "descriptor");
        return DeprecationResolver.isHiddenInResolution$default(this, descriptor2, call2, null, false, false, 28, null);
    }

    @JvmOverloads
    public final boolean isHiddenInResolution(@NotNull DeclarationDescriptor descriptor2) {
        Intrinsics.checkNotNullParameter(descriptor2, "descriptor");
        return DeprecationResolver.isHiddenInResolution$default(this, descriptor2, null, null, false, false, 30, null);
    }

    private static final void deprecationByOverridden$traverse(HashSet<CallableMemberDescriptor> visited2, DeprecationResolver this$0, LinkedHashSet<DescriptorBasedDeprecationInfo> deprecations2, Ref.BooleanRef hasUndeprecatedOverridden, CallableMemberDescriptor node) {
        if (visited2.contains(node)) {
            return;
        }
        visited2.add(node);
        List<DescriptorBasedDeprecationInfo> deprecationsByAnnotation = this$0.getOwnDeprecations(node);
        Collection<? extends CallableMemberDescriptor> collection = node.getOriginal().getOverriddenDescriptors();
        Intrinsics.checkNotNullExpressionValue(collection, "node.original.overriddenDescriptors");
        Collection<? extends CallableMemberDescriptor> overriddenDescriptors = collection;
        if (!((Collection)deprecationsByAnnotation).isEmpty()) {
            deprecations2.addAll((Collection<DescriptorBasedDeprecationInfo>)deprecationsByAnnotation);
        } else {
            if (overriddenDescriptors.isEmpty()) {
                hasUndeprecatedOverridden.element = true;
                return;
            }
            Iterable $this$forEach$iv = overriddenDescriptors;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                CallableMemberDescriptor p0 = (CallableMemberDescriptor)element$iv;
                boolean bl = false;
                DeprecationResolver.deprecationByOverridden$traverse(visited2, this$0, deprecations2, hasUndeprecatedOverridden, p0);
            }
        }
    }

    private static final MavenComparableVersion getDeprecationByVersionRequirement$createVersion(String version) {
        MavenComparableVersion mavenComparableVersion;
        try {
            mavenComparableVersion = new MavenComparableVersion(version);
        }
        catch (Exception e) {
            mavenComparableVersion = null;
        }
        return mavenComparableVersion;
    }

    public static final /* synthetic */ List access$getOwnDeprecations(DeprecationResolver $this, DeclarationDescriptor $receiver) {
        return $this.getOwnDeprecations($receiver);
    }

    public static final /* synthetic */ DescriptorBasedDeprecationInfo access$deprecationByOverridden(DeprecationResolver $this, CallableMemberDescriptor root2) {
        return $this.deprecationByOverridden(root2);
    }

    public static final /* synthetic */ LanguageVersionSettings access$getLanguageVersionSettings$p(DeprecationResolver $this) {
        return $this.languageVersionSettings;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000e\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0082\b\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018B+\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u000e\b\u0002\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\bJ\u000f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\u0006H\u00c6\u0003J\u000f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J3\u0010\u0011\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00062\u000e\b\u0002\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0001J\u0013\u0010\u0012\u001a\u00020\u00062\b\u0010\u0013\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\n\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/kotlin/resolve/deprecation/DeprecationResolver$DeprecationInfo;", "", "deprecations", "", "Lorg/jetbrains/kotlin/resolve/deprecation/DescriptorBasedDeprecationInfo;", "hasInheritedDeprecations", "", "hiddenInheritedDeprecations", "(Ljava/util/List;ZLjava/util/List;)V", "getDeprecations", "()Ljava/util/List;", "getHasInheritedDeprecations", "()Z", "getHiddenInheritedDeprecations", "component1", "component2", "component3", "copy", "equals", "other", "hashCode", "", "toString", "", "Companion", "frontend"})
    private static final class DeprecationInfo {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final List<DescriptorBasedDeprecationInfo> deprecations;
        private final boolean hasInheritedDeprecations;
        @NotNull
        private final List<DescriptorBasedDeprecationInfo> hiddenInheritedDeprecations;
        @NotNull
        private static final DeprecationInfo EMPTY = new DeprecationInfo(CollectionsKt.emptyList(), false, CollectionsKt.emptyList());

        public DeprecationInfo(@NotNull List<? extends DescriptorBasedDeprecationInfo> deprecations2, boolean hasInheritedDeprecations, @NotNull List<? extends DescriptorBasedDeprecationInfo> hiddenInheritedDeprecations) {
            Intrinsics.checkNotNullParameter(deprecations2, "deprecations");
            Intrinsics.checkNotNullParameter(hiddenInheritedDeprecations, "hiddenInheritedDeprecations");
            this.deprecations = deprecations2;
            this.hasInheritedDeprecations = hasInheritedDeprecations;
            this.hiddenInheritedDeprecations = hiddenInheritedDeprecations;
        }

        public /* synthetic */ DeprecationInfo(List list2, boolean bl, List list3, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 4) != 0) {
                list3 = CollectionsKt.emptyList();
            }
            this(list2, bl, list3);
        }

        @NotNull
        public final List<DescriptorBasedDeprecationInfo> getDeprecations() {
            return this.deprecations;
        }

        public final boolean getHasInheritedDeprecations() {
            return this.hasInheritedDeprecations;
        }

        @NotNull
        public final List<DescriptorBasedDeprecationInfo> getHiddenInheritedDeprecations() {
            return this.hiddenInheritedDeprecations;
        }

        @NotNull
        public final List<DescriptorBasedDeprecationInfo> component1() {
            return this.deprecations;
        }

        public final boolean component2() {
            return this.hasInheritedDeprecations;
        }

        @NotNull
        public final List<DescriptorBasedDeprecationInfo> component3() {
            return this.hiddenInheritedDeprecations;
        }

        @NotNull
        public final DeprecationInfo copy(@NotNull List<? extends DescriptorBasedDeprecationInfo> deprecations2, boolean hasInheritedDeprecations, @NotNull List<? extends DescriptorBasedDeprecationInfo> hiddenInheritedDeprecations) {
            Intrinsics.checkNotNullParameter(deprecations2, "deprecations");
            Intrinsics.checkNotNullParameter(hiddenInheritedDeprecations, "hiddenInheritedDeprecations");
            return new DeprecationInfo(deprecations2, hasInheritedDeprecations, hiddenInheritedDeprecations);
        }

        public static /* synthetic */ DeprecationInfo copy$default(DeprecationInfo deprecationInfo, List list2, boolean bl, List list3, int n, Object object) {
            if ((n & 1) != 0) {
                list2 = deprecationInfo.deprecations;
            }
            if ((n & 2) != 0) {
                bl = deprecationInfo.hasInheritedDeprecations;
            }
            if ((n & 4) != 0) {
                list3 = deprecationInfo.hiddenInheritedDeprecations;
            }
            return deprecationInfo.copy(list2, bl, list3);
        }

        @NotNull
        public String toString() {
            return "DeprecationInfo(deprecations=" + this.deprecations + ", hasInheritedDeprecations=" + this.hasInheritedDeprecations + ", hiddenInheritedDeprecations=" + this.hiddenInheritedDeprecations + ')';
        }

        public int hashCode() {
            int result2 = ((Object)this.deprecations).hashCode();
            int n = this.hasInheritedDeprecations ? 1 : 0;
            if (n != 0) {
                n = 1;
            }
            result2 = result2 * 31 + n;
            result2 = result2 * 31 + ((Object)this.hiddenInheritedDeprecations).hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof DeprecationInfo)) {
                return false;
            }
            DeprecationInfo deprecationInfo = (DeprecationInfo)other;
            if (!Intrinsics.areEqual(this.deprecations, deprecationInfo.deprecations)) {
                return false;
            }
            if (this.hasInheritedDeprecations != deprecationInfo.hasInheritedDeprecations) {
                return false;
            }
            return Intrinsics.areEqual(this.hiddenInheritedDeprecations, deprecationInfo.hiddenInheritedDeprecations);
        }

        @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/resolve/deprecation/DeprecationResolver$DeprecationInfo$Companion;", "", "()V", "EMPTY", "Lorg/jetbrains/kotlin/resolve/deprecation/DeprecationResolver$DeprecationInfo;", "getEMPTY", "()Lorg/jetbrains/kotlin/resolve/deprecation/DeprecationResolver$DeprecationInfo;", "frontend"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final DeprecationInfo getEMPTY() {
                return EMPTY;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/resolve/deprecation/DeprecationResolver$Companion;", "", "()V", "JAVA_DEPRECATED", "Lorg/jetbrains/kotlin/name/FqName;", "getJAVA_DEPRECATED", "()Lorg/jetbrains/kotlin/name/FqName;", "frontend"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final FqName getJAVA_DEPRECATED() {
            return JAVA_DEPRECATED;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 7, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ProtoBuf.VersionRequirement.VersionKind.values().length];
            nArray[ProtoBuf.VersionRequirement.VersionKind.LANGUAGE_VERSION.ordinal()] = 1;
            nArray[ProtoBuf.VersionRequirement.VersionKind.API_VERSION.ordinal()] = 2;
            nArray[ProtoBuf.VersionRequirement.VersionKind.COMPILER_VERSION.ordinal()] = 3;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

