/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.org.eclipse.sisu.space;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import org.jetbrains.kotlin.org.eclipse.sisu.inject.Logs;
import org.jetbrains.kotlin.org.eclipse.sisu.space.AbstractSisuIndex;
import org.jetbrains.kotlin.org.eclipse.sisu.space.AnnotationVisitor;
import org.jetbrains.kotlin.org.eclipse.sisu.space.ClassSpace;
import org.jetbrains.kotlin.org.eclipse.sisu.space.ClassVisitor;
import org.jetbrains.kotlin.org.eclipse.sisu.space.QualifierCache;
import org.jetbrains.kotlin.org.eclipse.sisu.space.SpaceScanner;
import org.jetbrains.kotlin.org.eclipse.sisu.space.SpaceVisitor;
import org.jetbrains.kotlin.org.eclipse.sisu.space.URLClassSpace;

public class SisuIndex
extends AbstractSisuIndex
implements ClassVisitor,
SpaceVisitor {
    private final QualifierCache qualifierCache = new QualifierCache();
    private final File targetDirectory;
    private ClassSpace space;
    private String clazzName;

    public SisuIndex(File targetDirectory) {
        this.targetDirectory = targetDirectory;
    }

    public static void main(String[] args2) {
        ArrayList<URL> indexPath = new ArrayList<URL>(args2.length);
        String[] stringArray = args2;
        int n = args2.length;
        int n2 = 0;
        while (n2 < n) {
            String path2 = stringArray[n2];
            try {
                indexPath.add(new File(path2).toURI().toURL());
            }
            catch (MalformedURLException e) {
                Logs.warn("Bad classpath element: {}", path2, e);
            }
            ++n2;
        }
        ClassLoader parent2 = SisuIndex.class.getClassLoader();
        URL[] urls = indexPath.toArray(new URL[indexPath.size()]);
        ClassLoader loader = urls.length > 0 ? URLClassLoader.newInstance(urls, parent2) : parent2;
        new SisuIndex(new File(".")).index(new URLClassSpace(loader));
    }

    public final void index(ClassSpace _space) {
        try {
            new SpaceScanner(_space).accept(this);
        }
        finally {
            this.flushIndex();
        }
    }

    @Override
    public final void enterSpace(ClassSpace _space) {
        this.space = _space;
    }

    @Override
    public final ClassVisitor visitClass(URL url) {
        return this;
    }

    @Override
    public final void enterClass(int modifiers2, String name2, String _extends, String[] _implements) {
        if ((modifiers2 & 0x7600) == 0) {
            this.clazzName = name2;
        }
    }

    @Override
    public final AnnotationVisitor visitAnnotation(String desc) {
        if (this.clazzName != null && this.qualifierCache.qualify(this.space, desc)) {
            this.addClassToIndex("javax.inject.Named", this.clazzName.replace('/', '.'));
        }
        return null;
    }

    @Override
    public final void leaveClass() {
        this.clazzName = null;
    }

    @Override
    public final void leaveSpace() {
        this.space = null;
    }

    @Override
    protected void info(String message) {
        System.out.println("[INFO] " + message);
    }

    @Override
    protected void warn(String message) {
        System.out.println("[WARN] " + message);
    }

    @Override
    protected Reader getReader(String path2) throws IOException {
        return new InputStreamReader((InputStream)new FileInputStream(new File(this.targetDirectory, path2)), "UTF-8");
    }

    @Override
    protected Writer getWriter(String path2) throws IOException {
        File index2 = new File(this.targetDirectory, path2);
        File parent2 = index2.getParentFile();
        if (parent2.isDirectory() || parent2.mkdirs()) {
            return new OutputStreamWriter((OutputStream)new FileOutputStream(index2), "UTF-8");
        }
        throw new IOException("Error creating: " + parent2);
    }
}

