/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.org.eclipse.sisu.bean;

import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.jetbrains.kotlin.org.eclipse.sisu.bean.BeanProperty;
import org.jetbrains.kotlin.org.eclipse.sisu.bean.BeanPropertyField;
import org.jetbrains.kotlin.org.eclipse.sisu.bean.BeanPropertySetter;

final class BeanPropertyIterator<T>
implements Iterator<BeanProperty<T>> {
    private final Iterator<Member> memberIterator;
    private BeanProperty<T> nextProperty;

    BeanPropertyIterator(Iterable<Member> members2) {
        this.memberIterator = members2.iterator();
    }

    @Override
    public boolean hasNext() {
        while (this.nextProperty == null) {
            if (!this.memberIterator.hasNext()) {
                return false;
            }
            Member member2 = this.memberIterator.next();
            int modifiers2 = member2.getModifiers();
            if (Modifier.isStatic(modifiers2) || Modifier.isAbstract(modifiers2) || member2.isSynthetic()) continue;
            if (member2 instanceof Method) {
                if (!BeanPropertyIterator.isSetter(member2)) continue;
                this.nextProperty = new BeanPropertySetter((Method)member2);
                continue;
            }
            if (!(member2 instanceof Field)) continue;
            this.nextProperty = new BeanPropertyField((Field)member2);
        }
        return true;
    }

    @Override
    public BeanProperty<T> next() {
        if (this.hasNext()) {
            BeanProperty<T> property2 = this.nextProperty;
            this.nextProperty = null;
            return property2;
        }
        throw new NoSuchElementException();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    private static boolean isSetter(Member member2) {
        String name2 = member2.getName();
        return name2.startsWith("set") && name2.length() > 3 && Character.isUpperCase(name2.charAt(3)) && ((Method)member2).getParameterTypes().length == 1;
    }
}

