/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.org.eclipse.aether.named.support;

import java.util.Deque;
import java.util.concurrent.TimeUnit;
import org.jetbrains.kotlin.org.eclipse.aether.named.support.AdaptedSemaphoreNamedLock$$Lambda$0;
import org.jetbrains.kotlin.org.eclipse.aether.named.support.NamedLockFactorySupport;
import org.jetbrains.kotlin.org.eclipse.aether.named.support.NamedLockSupport;

public class AdaptedSemaphoreNamedLock
extends NamedLockSupport {
    private final ThreadLocal<Deque<Integer>> threadPerms = ThreadLocal.withInitial(AdaptedSemaphoreNamedLock$$Lambda$0.INSTANCE);
    private final AdaptedSemaphore semaphore;

    public AdaptedSemaphoreNamedLock(String name2, NamedLockFactorySupport factory2, AdaptedSemaphore semaphore) {
        super(name2, factory2);
        this.semaphore = semaphore;
    }

    @Override
    public boolean lockShared(long time, TimeUnit unit2) throws InterruptedException {
        Deque<Integer> perms = this.threadPerms.get();
        if (!perms.isEmpty()) {
            perms.push(0);
            return true;
        }
        if (this.semaphore.tryAcquire(1, time, unit2)) {
            perms.push(1);
            return true;
        }
        return false;
    }

    @Override
    public boolean lockExclusively(long time, TimeUnit unit2) throws InterruptedException {
        Deque<Integer> perms = this.threadPerms.get();
        if (!perms.isEmpty()) {
            if (perms.contains(Integer.MAX_VALUE)) {
                perms.push(0);
                return true;
            }
            return false;
        }
        if (this.semaphore.tryAcquire(Integer.MAX_VALUE, time, unit2)) {
            perms.push(Integer.MAX_VALUE);
            return true;
        }
        return false;
    }

    @Override
    public void unlock() {
        Deque<Integer> steps = this.threadPerms.get();
        if (steps.isEmpty()) {
            throw new IllegalStateException("Wrong API usage: unlock without lock");
        }
        int step = steps.pop();
        if (step > 0) {
            this.semaphore.release(step);
        }
    }

    public static interface AdaptedSemaphore {
        public boolean tryAcquire(int var1, long var2, TimeUnit var4) throws InterruptedException;

        public void release(int var1);
    }
}

