/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.org.eclipse.aether.internal.impl.checksum;

import java.nio.ByteBuffer;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.jetbrains.kotlin.org.eclipse.aether.spi.connector.checksum.ChecksumAlgorithm;
import org.jetbrains.kotlin.org.eclipse.aether.spi.connector.checksum.ChecksumAlgorithmFactorySupport;
import org.jetbrains.kotlin.org.eclipse.aether.util.ChecksumUtils;

public abstract class MessageDigestChecksumAlgorithmFactorySupport
extends ChecksumAlgorithmFactorySupport {
    public MessageDigestChecksumAlgorithmFactorySupport(String name2, String extension) {
        super(name2, extension);
    }

    @Override
    public ChecksumAlgorithm getAlgorithm() {
        try {
            final MessageDigest messageDigest = MessageDigest.getInstance(this.getName());
            return new ChecksumAlgorithm(){

                @Override
                public void update(ByteBuffer input) {
                    messageDigest.update(input);
                }

                @Override
                public String checksum() {
                    return ChecksumUtils.toHexString(messageDigest.digest());
                }
            };
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException("MessageDigest algorithm " + this.getName() + " not supported, but is required by resolver.", e);
        }
    }
}

