/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.org.eclipse.aether.internal.impl;

import java.util.Objects;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jetbrains.kotlin.org.eclipse.aether.RepositorySystemSession;
import org.jetbrains.kotlin.org.eclipse.aether.internal.impl.FailChecksumPolicy;
import org.jetbrains.kotlin.org.eclipse.aether.internal.impl.WarnChecksumPolicy;
import org.jetbrains.kotlin.org.eclipse.aether.repository.RemoteRepository;
import org.jetbrains.kotlin.org.eclipse.aether.spi.connector.checksum.ChecksumPolicy;
import org.jetbrains.kotlin.org.eclipse.aether.spi.connector.checksum.ChecksumPolicyProvider;
import org.jetbrains.kotlin.org.eclipse.aether.transfer.TransferResource;

@Singleton
@Named
public final class DefaultChecksumPolicyProvider
implements ChecksumPolicyProvider {
    @Override
    public ChecksumPolicy newChecksumPolicy(RepositorySystemSession session2, RemoteRepository repository, TransferResource resource, String policy) {
        Objects.requireNonNull(session2, "session cannot be null");
        Objects.requireNonNull(repository, "repository cannot be null");
        Objects.requireNonNull(resource, "resource cannot be null");
        DefaultChecksumPolicyProvider.validatePolicy("policy", policy);
        String string2 = policy;
        int n = -1;
        switch (string2.hashCode()) {
            case -1190396462: {
                if (!string2.equals("ignore")) break;
                n = 0;
                break;
            }
            case 3135262: {
                if (!string2.equals("fail")) break;
                n = 1;
                break;
            }
            case 3641990: {
                if (!string2.equals("warn")) break;
                n = 2;
            }
        }
        switch (n) {
            case 0: {
                return null;
            }
            case 1: {
                return new FailChecksumPolicy(resource);
            }
            case 2: {
                return new WarnChecksumPolicy(resource);
            }
        }
        throw new IllegalArgumentException("Unsupported policy: " + policy);
    }

    @Override
    public String getEffectiveChecksumPolicy(RepositorySystemSession session2, String policy1, String policy2) {
        Objects.requireNonNull(session2, "session cannot be null");
        DefaultChecksumPolicyProvider.validatePolicy("policy1", policy1);
        DefaultChecksumPolicyProvider.validatePolicy("policy2", policy2);
        if (policy1.equals(policy2)) {
            return policy1;
        }
        int ordinal1 = DefaultChecksumPolicyProvider.ordinalOfPolicy(policy1);
        int ordinal2 = DefaultChecksumPolicyProvider.ordinalOfPolicy(policy2);
        if (ordinal2 < ordinal1) {
            return ordinal2 != 1 ? policy2 : "warn";
        }
        return ordinal1 != 1 ? policy1 : "warn";
    }

    private static int ordinalOfPolicy(String policy) {
        String string2 = policy;
        int n = -1;
        switch (string2.hashCode()) {
            case -1190396462: {
                if (!string2.equals("ignore")) break;
                n = 0;
                break;
            }
            case 3135262: {
                if (!string2.equals("fail")) break;
                n = 1;
                break;
            }
            case 3641990: {
                if (!string2.equals("warn")) break;
                n = 2;
            }
        }
        switch (n) {
            case 0: {
                return 0;
            }
            case 1: {
                return 2;
            }
            case 2: {
                return 1;
            }
        }
        throw new IllegalArgumentException("Unsupported policy: " + policy);
    }

    private static void validatePolicy(String paramName, String policy) {
        Objects.requireNonNull(policy, paramName + "cannot be null");
        String string2 = policy;
        int n = -1;
        switch (string2.hashCode()) {
            case -1190396462: {
                if (!string2.equals("ignore")) break;
                n = 0;
                break;
            }
            case 3135262: {
                if (!string2.equals("fail")) break;
                n = 1;
                break;
            }
            case 3641990: {
                if (!string2.equals("warn")) break;
                n = 2;
            }
        }
        switch (n) {
            case 0: 
            case 1: 
            case 2: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported policy: " + policy);
            }
        }
    }
}

