/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.org.apache.maven.model.profile.activation;

import java.io.File;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jetbrains.kotlin.org.apache.maven.model.Activation;
import org.jetbrains.kotlin.org.apache.maven.model.ActivationFile;
import org.jetbrains.kotlin.org.apache.maven.model.Profile;
import org.jetbrains.kotlin.org.apache.maven.model.building.ModelProblem;
import org.jetbrains.kotlin.org.apache.maven.model.building.ModelProblemCollector;
import org.jetbrains.kotlin.org.apache.maven.model.building.ModelProblemCollectorRequest;
import org.jetbrains.kotlin.org.apache.maven.model.path.ProfileActivationFilePathInterpolator;
import org.jetbrains.kotlin.org.apache.maven.model.profile.ProfileActivationContext;
import org.jetbrains.kotlin.org.apache.maven.model.profile.activation.ProfileActivator;
import org.jetbrains.kotlin.org.codehaus.plexus.interpolation.InterpolationException;
import org.jetbrains.kotlin.org.codehaus.plexus.util.StringUtils;

@Named(value="file")
@Singleton
public class FileProfileActivator
implements ProfileActivator {
    @Inject
    private ProfileActivationFilePathInterpolator profileActivationFilePathInterpolator;

    public FileProfileActivator setProfileActivationFilePathInterpolator(ProfileActivationFilePathInterpolator profileActivationFilePathInterpolator) {
        this.profileActivationFilePathInterpolator = profileActivationFilePathInterpolator;
        return this;
    }

    @Override
    public boolean isActive(Profile profile, ProfileActivationContext context, ModelProblemCollector problems) {
        boolean missing;
        String path2;
        Activation activation = profile.getActivation();
        if (activation == null) {
            return false;
        }
        ActivationFile file2 = activation.getFile();
        if (file2 == null) {
            return false;
        }
        if (StringUtils.isNotEmpty(file2.getExists())) {
            path2 = file2.getExists();
            missing = false;
        } else if (StringUtils.isNotEmpty(file2.getMissing())) {
            path2 = file2.getMissing();
            missing = true;
        } else {
            return false;
        }
        try {
            path2 = this.profileActivationFilePathInterpolator.interpolate(path2, context);
        }
        catch (InterpolationException e) {
            problems.add(new ModelProblemCollectorRequest(ModelProblem.Severity.ERROR, ModelProblem.Version.BASE).setMessage("Failed to interpolate file location " + path2 + " for profile " + profile.getId() + ": " + e.getMessage()).setLocation(file2.getLocation(missing ? "missing" : "exists")).setException(e));
            return false;
        }
        if (path2 == null) {
            return false;
        }
        File f = new File(path2);
        if (!f.isAbsolute()) {
            return false;
        }
        boolean fileExists = f.exists();
        return missing ? !fileExists : fileExists;
    }

    @Override
    public boolean presentInConfig(Profile profile, ProfileActivationContext context, ModelProblemCollector problems) {
        Activation activation = profile.getActivation();
        if (activation == null) {
            return false;
        }
        ActivationFile file2 = activation.getFile();
        return file2 != null;
    }
}

