/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.backend.js.ic;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Triple;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.serialization.metadata.KlibMetadataModuleDescriptorFactory;
import org.jetbrains.kotlin.backend.common.serialization.signature.IdSignatureDescriptor;
import org.jetbrains.kotlin.config.CommonConfigurationKeysKt;
import org.jetbrains.kotlin.config.CompilerConfiguration;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.impl.ModuleDescriptorImpl;
import org.jetbrains.kotlin.incremental.components.LookupTracker;
import org.jetbrains.kotlin.ir.backend.js.KlibKt;
import org.jetbrains.kotlin.ir.backend.js.lower.serialization.ir.JsIrLinker;
import org.jetbrains.kotlin.ir.backend.js.lower.serialization.ir.JsManglerDesc;
import org.jetbrains.kotlin.ir.declarations.IrFactory;
import org.jetbrains.kotlin.ir.declarations.IrModuleFragment;
import org.jetbrains.kotlin.ir.descriptors.IrBuiltInsOverDescriptors;
import org.jetbrains.kotlin.ir.util.ExternalDependenciesGenerator;
import org.jetbrains.kotlin.ir.util.IrMessageLogger;
import org.jetbrains.kotlin.ir.util.SymbolTable;
import org.jetbrains.kotlin.library.KotlinLibrary;
import org.jetbrains.kotlin.library.KotlinLibraryKt;
import org.jetbrains.kotlin.psi2ir.generators.TypeTranslatorImpl;
import org.jetbrains.kotlin.storage.LockBasedStorageManager;
import org.jetbrains.kotlin.storage.StorageManager;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0000\u0018\u00002\u00020\u0001B7\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0018\u0010\u0006\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\b0\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u001c\u0010\f\u001a\u00020\r2\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00050\u0007H\u0002J\u0014\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00050\u0007H\u0002J.\u0010\u0011\u001a\u001a\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u0013\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00130\u00140\u00122\u000e\u0010\u0015\u001a\n\u0012\u0004\u0012\u00020\u0016\u0018\u00010\u0014R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0006\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/ic/JsIrLinkerLoader;", "", "compilerConfiguration", "Lorg/jetbrains/kotlin/config/CompilerConfiguration;", "library", "Lorg/jetbrains/kotlin/library/KotlinLibrary;", "dependencyGraph", "", "", "irFactory", "Lorg/jetbrains/kotlin/ir/declarations/IrFactory;", "(Lorg/jetbrains/kotlin/config/CompilerConfiguration;Lorg/jetbrains/kotlin/library/KotlinLibrary;Ljava/util/Map;Lorg/jetbrains/kotlin/ir/declarations/IrFactory;)V", "createLinker", "Lorg/jetbrains/kotlin/ir/backend/js/lower/serialization/ir/JsIrLinker;", "loadedModules", "Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;", "loadModules", "processJsIrLinker", "Lkotlin/Triple;", "Lorg/jetbrains/kotlin/ir/declarations/IrModuleFragment;", "", "dirtyFiles", "", "backend.js"})
public final class JsIrLinkerLoader {
    @NotNull
    private final CompilerConfiguration compilerConfiguration;
    @NotNull
    private final KotlinLibrary library;
    @NotNull
    private final Map<KotlinLibrary, List<KotlinLibrary>> dependencyGraph;
    @NotNull
    private final IrFactory irFactory;

    public JsIrLinkerLoader(@NotNull CompilerConfiguration compilerConfiguration, @NotNull KotlinLibrary library, @NotNull Map<KotlinLibrary, ? extends List<? extends KotlinLibrary>> dependencyGraph, @NotNull IrFactory irFactory) {
        Intrinsics.checkNotNullParameter(compilerConfiguration, "compilerConfiguration");
        Intrinsics.checkNotNullParameter(library, "library");
        Intrinsics.checkNotNullParameter(dependencyGraph, "dependencyGraph");
        Intrinsics.checkNotNullParameter(irFactory, "irFactory");
        this.compilerConfiguration = compilerConfiguration;
        this.library = library;
        this.dependencyGraph = dependencyGraph;
        this.irFactory = irFactory;
    }

    private final JsIrLinker createLinker(Map<ModuleDescriptor, ? extends KotlinLibrary> loadedModules) {
        IrMessageLogger irMessageLogger = this.compilerConfiguration.get(IrMessageLogger.Companion.getIR_MESSAGE_LOGGER());
        if (irMessageLogger == null) {
            irMessageLogger = IrMessageLogger.None.INSTANCE;
        }
        Intrinsics.checkNotNullExpressionValue(irMessageLogger, "compilerConfiguration[Ir\u2026] ?: IrMessageLogger.None");
        IrMessageLogger logger = irMessageLogger;
        IdSignatureDescriptor signaturer = new IdSignatureDescriptor(JsManglerDesc.INSTANCE);
        SymbolTable symbolTable = new SymbolTable(signaturer, this.irFactory, null, 4, null);
        ModuleDescriptor moduleDescriptor = (ModuleDescriptor)CollectionsKt.last((Iterable)loadedModules.keySet());
        TypeTranslatorImpl typeTranslator2 = new TypeTranslatorImpl(symbolTable, CommonConfigurationKeysKt.getLanguageVersionSettings(this.compilerConfiguration), moduleDescriptor, null, false, null, null, 120, null);
        IrBuiltInsOverDescriptors irBuiltIns = new IrBuiltInsOverDescriptors(moduleDescriptor.getBuiltIns(), typeTranslator2, symbolTable);
        return new JsIrLinker(null, logger, irBuiltIns, symbolTable, null, null, null, null, 224, null);
    }

    /*
     * WARNING - void declaration
     */
    private final Map<ModuleDescriptor, KotlinLibrary> loadModules() {
        void $this$associateByTo$iv$iv;
        Map descriptors = new LinkedHashMap();
        Ref.ObjectRef<ModuleDescriptorImpl> runtimeModule = new Ref.ObjectRef<ModuleDescriptorImpl>();
        Iterable $this$associateBy$iv = this.dependencyGraph.keySet();
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast(MapsKt.mapCapacity(CollectionsKt.collectionSizeOrDefault($this$associateBy$iv, 10)), 16);
        Iterable iterable = $this$associateBy$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            void klib;
            KotlinLibrary kotlinLibrary = (KotlinLibrary)element$iv$iv;
            Map map2 = destination$iv$iv;
            boolean bl = false;
            map2.put((ModuleDescriptor)JsIrLinkerLoader.loadModules$getModuleDescriptor(descriptors, this, runtimeModule, (KotlinLibrary)klib), element$iv$iv);
        }
        return destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Triple<JsIrLinker, IrModuleFragment, Collection<IrModuleFragment>> processJsIrLinker(@Nullable Collection<String> dirtyFiles) {
        Collection<IrModuleFragment> collection;
        void $this$mapTo$iv$iv;
        Object v0;
        Object loadedLibrary;
        ArrayList<Pair<IrModuleFragment, Object>> irModules;
        JsIrLinker jsIrLinker;
        block5: {
            Map<ModuleDescriptor, KotlinLibrary> loadedModules = this.loadModules();
            jsIrLinker = this.createLinker(loadedModules);
            irModules = new ArrayList<Pair<IrModuleFragment, Object>>(loadedModules.size());
            for (Map.Entry<ModuleDescriptor, KotlinLibrary> object2 : loadedModules.entrySet()) {
                ModuleDescriptor descriptor2 = object2.getKey();
                loadedLibrary = object2.getValue();
                if (Intrinsics.areEqual(this.library, loadedLibrary)) {
                    if (dirtyFiles != null) {
                        irModules.add(TuplesKt.to(jsIrLinker.deserializeDirtyFiles(descriptor2, (KotlinLibrary)loadedLibrary, dirtyFiles), loadedLibrary));
                        continue;
                    }
                    irModules.add(TuplesKt.to(jsIrLinker.deserializeFullModule(descriptor2, (KotlinLibrary)loadedLibrary), loadedLibrary));
                    continue;
                }
                irModules.add(TuplesKt.to(jsIrLinker.deserializeHeadersWithInlineBodies(descriptor2, (KotlinLibrary)loadedLibrary), loadedLibrary));
            }
            jsIrLinker.init(null, CollectionsKt.emptyList());
            new ExternalDependenciesGenerator(jsIrLinker.getSymbolTable(), CollectionsKt.listOf(jsIrLinker)).generateUnboundSymbolsAsDependencies();
            jsIrLinker.postProcess();
            loadedLibrary = irModules;
            Iterator iterator2 = loadedLibrary.iterator();
            while (iterator2.hasNext()) {
                Object t = iterator2.next();
                Pair it = (Pair)t;
                boolean bl = false;
                if (!Intrinsics.areEqual(it.getSecond(), this.library)) continue;
                v0 = t;
                break block5;
            }
            v0 = null;
        }
        Pair pair = v0;
        IrModuleFragment irModuleFragment = pair != null ? (IrModuleFragment)pair.getFirst() : null;
        Intrinsics.checkNotNull(irModuleFragment);
        IrModuleFragment currentIrModule = irModuleFragment;
        Iterable iterable = irModules;
        IrModuleFragment irModuleFragment2 = currentIrModule;
        JsIrLinker jsIrLinker2 = jsIrLinker;
        boolean $i$f$map = false;
        loadedLibrary = iterable;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault(iterable, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Pair pair2 = (Pair)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add((IrModuleFragment)it.getFirst());
        }
        collection = (List)destination$iv$iv;
        List list2 = collection;
        IrModuleFragment irModuleFragment3 = irModuleFragment2;
        JsIrLinker jsIrLinker3 = jsIrLinker2;
        return new Triple<JsIrLinker, IrModuleFragment, Collection<IrModuleFragment>>(jsIrLinker3, irModuleFragment3, list2);
    }

    /*
     * WARNING - void declaration
     */
    private static final ModuleDescriptorImpl loadModules$getModuleDescriptor(Map<KotlinLibrary, ModuleDescriptorImpl> descriptors, JsIrLinkerLoader this$0, Ref.ObjectRef<ModuleDescriptorImpl> runtimeModule, KotlinLibrary current) {
        ModuleDescriptorImpl moduleDescriptorImpl;
        Map<KotlinLibrary, ModuleDescriptorImpl> $this$getOrPut$iv = descriptors;
        boolean $i$f$getOrPut = false;
        ModuleDescriptorImpl value$iv = $this$getOrPut$iv.get(current);
        if (value$iv == null) {
            void $this$mapTo$iv$iv;
            boolean bl = false;
            boolean isBuiltIns = KotlinLibraryKt.getUnresolvedDependencies(current).isEmpty();
            LookupTracker.DO_NOTHING lookupTracker = LookupTracker.DO_NOTHING.INSTANCE;
            KlibMetadataModuleDescriptorFactory klibMetadataModuleDescriptorFactory2 = KlibKt.getJsFactories().getDefaultDeserializedDescriptorFactory();
            LanguageVersionSettings languageVersionSettings = CommonConfigurationKeysKt.getLanguageVersionSettings(this$0.compilerConfiguration);
            StorageManager storageManager = LockBasedStorageManager.NO_LOCKS;
            Intrinsics.checkNotNullExpressionValue(storageManager, "NO_LOCKS");
            ModuleDescriptorImpl moduleDescriptorImpl2 = (ModuleDescriptorImpl)runtimeModule.element;
            ModuleDescriptorImpl md = klibMetadataModuleDescriptorFactory2.createDescriptorOptionalBuiltIns(current, languageVersionSettings, storageManager, moduleDescriptorImpl2 != null ? moduleDescriptorImpl2.getBuiltIns() : null, null, lookupTracker);
            if (isBuiltIns) {
                runtimeModule.element = md;
            }
            List<KotlinLibrary> list2 = this$0.dependencyGraph.get(current);
            Intrinsics.checkNotNull(list2);
            Iterable $this$map$iv = list2;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                KotlinLibrary kotlinLibrary = (KotlinLibrary)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                collection.add(JsIrLinkerLoader.loadModules$getModuleDescriptor(descriptors, this$0, runtimeModule, (KotlinLibrary)it));
            }
            List dependencies2 = (List)destination$iv$iv;
            md.setDependencies(CollectionsKt.plus((Collection)CollectionsKt.listOf(md), (Iterable)dependencies2));
            ModuleDescriptorImpl answer$iv = md;
            $this$getOrPut$iv.put(current, answer$iv);
            moduleDescriptorImpl = answer$iv;
        } else {
            moduleDescriptorImpl = value$iv;
        }
        return moduleDescriptorImpl;
    }
}

